/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CustomerCreateParams
extends ApiRequestParams {
    @SerializedName(value="account_balance")
    Long accountBalance;
    @SerializedName(value="coupon")
    String coupon;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="invoice_prefix")
    String invoicePrefix;
    @SerializedName(value="invoice_settings")
    InvoiceSettings invoiceSettings;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="shipping")
    Object shipping;
    @SerializedName(value="source")
    String source;
    @SerializedName(value="tax_info")
    TaxInfo taxInfo;

    private CustomerCreateParams(Long accountBalance, String coupon, String description, String email, List<String> expand, String invoicePrefix, InvoiceSettings invoiceSettings, Map<String, String> metadata, String paymentMethod, Object shipping, String source, TaxInfo taxInfo) {
        this.accountBalance = accountBalance;
        this.coupon = coupon;
        this.description = description;
        this.email = email;
        this.expand = expand;
        this.invoicePrefix = invoicePrefix;
        this.invoiceSettings = invoiceSettings;
        this.metadata = metadata;
        this.paymentMethod = paymentMethod;
        this.shipping = shipping;
        this.source = source;
        this.taxInfo = taxInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class TaxInfo {
        @SerializedName(value="tax_id")
        String taxId;
        @SerializedName(value="type")
        Type type;

        private TaxInfo(String taxId, Type type) {
            this.taxId = taxId;
            this.type = type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            VAT("vat");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private String taxId;
            private Type type;

            public TaxInfo build() {
                return new TaxInfo(this.taxId, this.type);
            }

            public Builder setTaxId(String taxId) {
                this.taxId = taxId;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }
        }
    }

    public static class Shipping {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        private Shipping(Address address, String name, String phone) {
            this.address = address;
            this.name = name;
            this.phone = phone;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private String name;
            private String phone;

            public Shipping build() {
                return new Shipping(this.address, this.name, this.phone);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }
        }
    }

    public static class InvoiceSettings {
        @SerializedName(value="custom_fields")
        Object customFields;
        @SerializedName(value="footer")
        String footer;

        private InvoiceSettings(Object customFields, String footer) {
            this.customFields = customFields;
            this.footer = footer;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class CustomField {
            @SerializedName(value="name")
            String name;
            @SerializedName(value="value")
            String value;

            private CustomField(String name, String value) {
                this.name = name;
                this.value = value;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String name;
                private String value;

                public CustomField build() {
                    return new CustomField(this.name, this.value);
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setValue(String value) {
                    this.value = value;
                    return this;
                }
            }
        }

        public static class Builder {
            private Object customFields;
            private String footer;

            public InvoiceSettings build() {
                return new InvoiceSettings(this.customFields, this.footer);
            }

            public Builder setCustomFields(EmptyParam customFields) {
                this.customFields = customFields;
                return this;
            }

            public Builder setCustomFields(List<CustomField> customFields) {
                this.customFields = customFields;
                return this;
            }

            public Builder setFooter(String footer) {
                this.footer = footer;
                return this;
            }
        }
    }

    public static class Builder {
        private Long accountBalance;
        private String coupon;
        private String description;
        private String email;
        private List<String> expand;
        private String invoicePrefix;
        private InvoiceSettings invoiceSettings;
        private Map<String, String> metadata;
        private String paymentMethod;
        private Object shipping;
        private String source;
        private TaxInfo taxInfo;

        public CustomerCreateParams build() {
            return new CustomerCreateParams(this.accountBalance, this.coupon, this.description, this.email, this.expand, this.invoicePrefix, this.invoiceSettings, this.metadata, this.paymentMethod, this.shipping, this.source, this.taxInfo);
        }

        public Builder setAccountBalance(Long accountBalance) {
            this.accountBalance = accountBalance;
            return this;
        }

        public Builder setCoupon(String coupon) {
            this.coupon = coupon;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setInvoicePrefix(String invoicePrefix) {
            this.invoicePrefix = invoicePrefix;
            return this;
        }

        public Builder setInvoiceSettings(InvoiceSettings invoiceSettings) {
            this.invoiceSettings = invoiceSettings;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder setShipping(Shipping shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setShipping(EmptyParam shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setTaxInfo(TaxInfo taxInfo) {
            this.taxInfo = taxInfo;
            return this;
        }
    }
}

