/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntentCreateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="capture_method")
    CaptureMethod captureMethod;
    @SerializedName(value="confirm")
    Boolean confirm;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="on_behalf_of")
    String onBehalfOf;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="return_url")
    String returnUrl;
    @SerializedName(value="save_payment_method")
    Boolean savePaymentMethod;
    @SerializedName(value="shipping")
    Shipping shipping;
    @SerializedName(value="source")
    String source;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    String transferGroup;

    private PaymentIntentCreateParams(Long amount, Long applicationFeeAmount, CaptureMethod captureMethod, Boolean confirm, String currency, String customer, String description, List<String> expand, Map<String, String> metadata, String onBehalfOf, String paymentMethod, List<String> paymentMethodTypes, String receiptEmail, String returnUrl, Boolean savePaymentMethod, Shipping shipping, String source, String statementDescriptor, TransferData transferData, String transferGroup) {
        this.amount = amount;
        this.applicationFeeAmount = applicationFeeAmount;
        this.captureMethod = captureMethod;
        this.confirm = confirm;
        this.currency = currency;
        this.customer = customer;
        this.description = description;
        this.expand = expand;
        this.metadata = metadata;
        this.onBehalfOf = onBehalfOf;
        this.paymentMethod = paymentMethod;
        this.paymentMethodTypes = paymentMethodTypes;
        this.receiptEmail = receiptEmail;
        this.returnUrl = returnUrl;
        this.savePaymentMethod = savePaymentMethod;
        this.shipping = shipping;
        this.source = source;
        this.statementDescriptor = statementDescriptor;
        this.transferData = transferData;
        this.transferGroup = transferGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum CaptureMethod implements ApiRequestParams.EnumParam
    {
        AUTOMATIC("automatic"),
        MANUAL("manual");

        private final String value;

        private CaptureMethod(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class TransferData {
        @SerializedName(value="destination")
        String destination;

        private TransferData(String destination) {
            this.destination = destination;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String destination;

            public TransferData build() {
                return new TransferData(this.destination);
            }

            public Builder setDestination(String destination) {
                this.destination = destination;
                return this;
            }
        }
    }

    public static class Shipping {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="carrier")
        String carrier;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="tracking_number")
        String trackingNumber;

        private Shipping(Address address, String carrier, String name, String phone, String trackingNumber) {
            this.address = address;
            this.carrier = carrier;
            this.name = name;
            this.phone = phone;
            this.trackingNumber = trackingNumber;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private String carrier;
            private String name;
            private String phone;
            private String trackingNumber;

            public Shipping build() {
                return new Shipping(this.address, this.carrier, this.name, this.phone, this.trackingNumber);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setCarrier(String carrier) {
                this.carrier = carrier;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setTrackingNumber(String trackingNumber) {
                this.trackingNumber = trackingNumber;
                return this;
            }
        }
    }

    public static class Builder {
        private Long amount;
        private Long applicationFeeAmount;
        private CaptureMethod captureMethod;
        private Boolean confirm;
        private String currency;
        private String customer;
        private String description;
        private List<String> expand;
        private Map<String, String> metadata;
        private String onBehalfOf;
        private String paymentMethod;
        private List<String> paymentMethodTypes;
        private String receiptEmail;
        private String returnUrl;
        private Boolean savePaymentMethod;
        private Shipping shipping;
        private String source;
        private String statementDescriptor;
        private TransferData transferData;
        private String transferGroup;

        public PaymentIntentCreateParams build() {
            return new PaymentIntentCreateParams(this.amount, this.applicationFeeAmount, this.captureMethod, this.confirm, this.currency, this.customer, this.description, this.expand, this.metadata, this.onBehalfOf, this.paymentMethod, this.paymentMethodTypes, this.receiptEmail, this.returnUrl, this.savePaymentMethod, this.shipping, this.source, this.statementDescriptor, this.transferData, this.transferGroup);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setCaptureMethod(CaptureMethod captureMethod) {
            this.captureMethod = captureMethod;
            return this;
        }

        public Builder setConfirm(Boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setOnBehalfOf(String onBehalfOf) {
            this.onBehalfOf = onBehalfOf;
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder addPaymentMethodType(String element) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.add(element);
            return this;
        }

        public Builder addAllPaymentMethodType(List<String> elements) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.addAll(elements);
            return this;
        }

        public Builder setReceiptEmail(String receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder setSavePaymentMethod(Boolean savePaymentMethod) {
            this.savePaymentMethod = savePaymentMethod;
            return this;
        }

        public Builder setShipping(Shipping shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public Builder setTransferGroup(String transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }
    }
}

