// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceItemCreateParams extends ApiRequestParams {
  /**
   * The integer amount in **%s** of the charge to be applied to the upcoming invoice. If you want
   * to apply a credit to the customer's account, pass a negative amount.
   */
  @SerializedName("amount")
  Long amount;

  /**
   * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
   * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
   */
  @SerializedName("currency")
  String currency;

  /** The ID of the customer who will be billed when this invoice item is billed. */
  @SerializedName("customer")
  String customer;

  /**
   * An arbitrary string which you can attach to the invoice item. The description is displayed in
   * the invoice for easy tracking.
   */
  @SerializedName("description")
  String description;

  /**
   * Controls whether discounts apply to this invoice item. Defaults to false for prorations or
   * negative invoice items, and true for all other invoice items.
   */
  @SerializedName("discountable")
  Boolean discountable;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /**
   * The ID of an existing invoice to add this invoice item to. When left blank, the invoice item
   * will be added to the next upcoming scheduled invoice. This is useful when adding invoice items
   * in response to an invoice.created webhook. You can only add invoice items to draft invoices.
   */
  @SerializedName("invoice")
  String invoice;

  /**
   * A set of key-value pairs that you can attach to an invoice item object. It can be useful for
   * storing additional information about the invoice item in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;

  /** The period associated with this invoice item. */
  @SerializedName("period")
  Period period;

  /** Non-negative integer. The quantity of units for the invoice item. */
  @SerializedName("quantity")
  Long quantity;

  /**
   * The ID of a subscription to add this invoice item to. When left blank, the invoice item will be
   * be added to the next upcoming scheduled invoice. When set, scheduled invoices for subscriptions
   * other than the specified subscription will ignore the invoice item. Use this when you want to
   * express that an invoice item has been accrued within the context of a particular subscription.
   */
  @SerializedName("subscription")
  String subscription;

  /**
   * The integer unit amount in **%s** of the charge to be applied to the upcoming invoice. This
   * unit_amount will be multiplied by the quantity to get the full amount. If you want to apply a
   * credit to the customer's account, pass a negative unit_amount.
   */
  @SerializedName("unit_amount")
  Long unitAmount;

  private InvoiceItemCreateParams(
      Long amount,
      String currency,
      String customer,
      String description,
      Boolean discountable,
      List<String> expand,
      String invoice,
      Map<String, String> metadata,
      Period period,
      Long quantity,
      String subscription,
      Long unitAmount) {
    this.amount = amount;
    this.currency = currency;
    this.customer = customer;
    this.description = description;
    this.discountable = discountable;
    this.expand = expand;
    this.invoice = invoice;
    this.metadata = metadata;
    this.period = period;
    this.quantity = quantity;
    this.subscription = subscription;
    this.unitAmount = unitAmount;
  }

  public static Builder builder() {
    return new com.stripe.param.InvoiceItemCreateParams.Builder();
  }

  public static class Builder {
    private Long amount;

    private String currency;

    private String customer;

    private String description;

    private Boolean discountable;

    private List<String> expand;

    private String invoice;

    private Map<String, String> metadata;

    private Period period;

    private Long quantity;

    private String subscription;

    private Long unitAmount;

    /** Finalize and obtain parameter instance from this builder. */
    public InvoiceItemCreateParams build() {
      return new InvoiceItemCreateParams(
          this.amount,
          this.currency,
          this.customer,
          this.description,
          this.discountable,
          this.expand,
          this.invoice,
          this.metadata,
          this.period,
          this.quantity,
          this.subscription,
          this.unitAmount);
    }

    /**
     * The integer amount in **%s** of the charge to be applied to the upcoming invoice. If you want
     * to apply a credit to the customer's account, pass a negative amount.
     */
    public Builder setAmount(Long amount) {
      this.amount = amount;
      return this;
    }

    /**
     * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in
     * lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
     */
    public Builder setCurrency(String currency) {
      this.currency = currency;
      return this;
    }

    /** The ID of the customer who will be billed when this invoice item is billed. */
    public Builder setCustomer(String customer) {
      this.customer = customer;
      return this;
    }

    /**
     * An arbitrary string which you can attach to the invoice item. The description is displayed in
     * the invoice for easy tracking.
     */
    public Builder setDescription(String description) {
      this.description = description;
      return this;
    }

    /**
     * Controls whether discounts apply to this invoice item. Defaults to false for prorations or
     * negative invoice items, and true for all other invoice items.
     */
    public Builder setDiscountable(Boolean discountable) {
      this.discountable = discountable;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * InvoiceItemCreateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * InvoiceItemCreateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * The ID of an existing invoice to add this invoice item to. When left blank, the invoice item
     * will be added to the next upcoming scheduled invoice. This is useful when adding invoice
     * items in response to an invoice.created webhook. You can only add invoice items to draft
     * invoices.
     */
    public Builder setInvoice(String invoice) {
      this.invoice = invoice;
      return this;
    }

    /**
     * Add a key/value pair to `metadata` map. A map is initialized for the first `put/putAll` call,
     * and subsequent calls add additional key/value pairs to the original map. See {@link
     * InvoiceItemCreateParams#metadata} for the field documentation.
     */
    public Builder putMetadata(String key, String value) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `metadata` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link InvoiceItemCreateParams#metadata} for the field documentation.
     */
    public Builder putAllMetadata(Map<String, String> map) {
      if (this.metadata == null) {
        this.metadata = new HashMap<>();
      }
      this.metadata.putAll(map);
      return this;
    }

    /** The period associated with this invoice item. */
    public Builder setPeriod(Period period) {
      this.period = period;
      return this;
    }

    /** Non-negative integer. The quantity of units for the invoice item. */
    public Builder setQuantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    /**
     * The ID of a subscription to add this invoice item to. When left blank, the invoice item will
     * be be added to the next upcoming scheduled invoice. When set, scheduled invoices for
     * subscriptions other than the specified subscription will ignore the invoice item. Use this
     * when you want to express that an invoice item has been accrued within the context of a
     * particular subscription.
     */
    public Builder setSubscription(String subscription) {
      this.subscription = subscription;
      return this;
    }

    /**
     * The integer unit amount in **%s** of the charge to be applied to the upcoming invoice. This
     * unit_amount will be multiplied by the quantity to get the full amount. If you want to apply a
     * credit to the customer's account, pass a negative unit_amount.
     */
    public Builder setUnitAmount(Long unitAmount) {
      this.unitAmount = unitAmount;
      return this;
    }
  }

  public static class Period {
    /** The end of the period, which must be greater than or equal to the start. */
    @SerializedName("end")
    Long end;

    /** The start of the period. */
    @SerializedName("start")
    Long start;

    private Period(Long end, Long start) {
      this.end = end;
      this.start = start;
    }

    public static Builder builder() {
      return new com.stripe.param.InvoiceItemCreateParams.Period.Builder();
    }

    public static class Builder {
      private Long end;

      private Long start;

      /** Finalize and obtain parameter instance from this builder. */
      public Period build() {
        return new Period(this.end, this.start);
      }

      /** The end of the period, which must be greater than or equal to the start. */
      public Builder setEnd(Long end) {
        this.end = end;
        return this;
      }

      /** The start of the period. */
      public Builder setStart(Long start) {
        this.start = start;
        return this;
      }
    }
  }
}
