// Generated by delombok at Thu Apr 11 19:08:13 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class PaymentIntentCancelParams extends ApiRequestParams {
  /**
   * Reason for canceling this PaymentIntent. If set, possible values are `duplicate`, `fraudulent`,
   * `requested_by_customer`, or `failed_invoice`
   */
  @SerializedName("cancellation_reason")
  CancellationReason cancellationReason;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;

  private PaymentIntentCancelParams(CancellationReason cancellationReason, List<String> expand) {
    this.cancellationReason = cancellationReason;
    this.expand = expand;
  }

  public static Builder builder() {
    return new com.stripe.param.PaymentIntentCancelParams.Builder();
  }


  public static class Builder {
    private CancellationReason cancellationReason;
    private List<String> expand;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public PaymentIntentCancelParams build() {
      return new PaymentIntentCancelParams(this.cancellationReason, this.expand);
    }

    /**
     * Reason for canceling this PaymentIntent. If set, possible values are `duplicate`,
     * `fraudulent`, `requested_by_customer`, or `failed_invoice`
     */
    public Builder setCancellationReason(CancellationReason cancellationReason) {
      this.cancellationReason = cancellationReason;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * PaymentIntentCancelParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * PaymentIntentCancelParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }
  }


  public enum CancellationReason implements ApiRequestParams.EnumParam {
    @SerializedName("duplicate")
    DUPLICATE("duplicate"), @SerializedName("failed_invoice")
    FAILED_INVOICE("failed_invoice"), @SerializedName("fraudulent")
    FRAUDULENT("fraudulent"), @SerializedName("requested_by_customer")
    REQUESTED_BY_CUSTOMER("requested_by_customer");
    private final String value;

    CancellationReason(String value) {
      this.value = value;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }
  }
}
