/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.radar;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ValueListCreateParams
extends ApiRequestParams {
    @SerializedName(value="alias")
    String alias;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="item_type")
    ItemType itemType;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;

    private ValueListCreateParams(String alias, List<String> expand, ItemType itemType, Map<String, String> metadata, String name) {
        this.alias = alias;
        this.expand = expand;
        this.itemType = itemType;
        this.metadata = metadata;
        this.name = name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ItemType implements ApiRequestParams.EnumParam
    {
        CARD_BIN("card_bin"),
        CARD_FINGERPRINT("card_fingerprint"),
        CASE_SENSITIVE_STRING("case_sensitive_string"),
        COUNTRY("country"),
        EMAIL("email"),
        IP_ADDRESS("ip_address"),
        STRING("string");

        private final String value;

        private ItemType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private String alias;
        private List<String> expand;
        private ItemType itemType;
        private Map<String, String> metadata;
        private String name;

        public ValueListCreateParams build() {
            return new ValueListCreateParams(this.alias, this.expand, this.itemType, this.metadata, this.name);
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setItemType(ItemType itemType) {
            this.itemType = itemType;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }
    }
}

