/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaymentIntentCaptureParams
extends ApiRequestParams {
    @SerializedName(value="amount_to_capture")
    Long amountToCapture;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;

    private PaymentIntentCaptureParams(Long amountToCapture, Long applicationFeeAmount, List<String> expand, Map<String, Object> extraParams) {
        this.amountToCapture = amountToCapture;
        this.applicationFeeAmount = applicationFeeAmount;
        this.expand = expand;
        this.extraParams = extraParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long amountToCapture;
        private Long applicationFeeAmount;
        private List<String> expand;
        private Map<String, Object> extraParams;

        public PaymentIntentCaptureParams build() {
            return new PaymentIntentCaptureParams(this.amountToCapture, this.applicationFeeAmount, this.expand, this.extraParams);
        }

        public Builder setAmountToCapture(Long amountToCapture) {
            this.amountToCapture = amountToCapture;
            return this;
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }
    }
}

