/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaxRateCreateParams
extends ApiRequestParams {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="inclusive")
    Boolean inclusive;
    @SerializedName(value="jurisdiction")
    String jurisdiction;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="percentage")
    BigDecimal percentage;

    private TaxRateCreateParams(Boolean active, String description, String displayName, List<String> expand, Map<String, Object> extraParams, Boolean inclusive, String jurisdiction, Map<String, String> metadata, BigDecimal percentage) {
        this.active = active;
        this.description = description;
        this.displayName = displayName;
        this.expand = expand;
        this.extraParams = extraParams;
        this.inclusive = inclusive;
        this.jurisdiction = jurisdiction;
        this.metadata = metadata;
        this.percentage = percentage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean active;
        private String description;
        private String displayName;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Boolean inclusive;
        private String jurisdiction;
        private Map<String, String> metadata;
        private BigDecimal percentage;

        public TaxRateCreateParams build() {
            return new TaxRateCreateParams(this.active, this.description, this.displayName, this.expand, this.extraParams, this.inclusive, this.jurisdiction, this.metadata, this.percentage);
        }

        public Builder setActive(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setInclusive(Boolean inclusive) {
            this.inclusive = inclusive;
            return this;
        }

        public Builder setJurisdiction(String jurisdiction) {
            this.jurisdiction = jurisdiction;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setPercentage(BigDecimal percentage) {
            this.percentage = percentage;
            return this;
        }
    }
}

