/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class PersonCollectionListParams
extends ApiRequestParams {
    @SerializedName(value="ending_before")
    String endingBefore;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="limit")
    Long limit;
    @SerializedName(value="relationship")
    Relationship relationship;
    @SerializedName(value="starting_after")
    String startingAfter;

    private PersonCollectionListParams(String endingBefore, List<String> expand, Long limit, Relationship relationship, String startingAfter) {
        this.endingBefore = endingBefore;
        this.expand = expand;
        this.limit = limit;
        this.relationship = relationship;
        this.startingAfter = startingAfter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Relationship {
        @SerializedName(value="account_opener")
        Boolean accountOpener;
        @SerializedName(value="director")
        Boolean director;
        @SerializedName(value="owner")
        Boolean owner;

        private Relationship(Boolean accountOpener, Boolean director, Boolean owner) {
            this.accountOpener = accountOpener;
            this.director = director;
            this.owner = owner;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Boolean accountOpener;
            private Boolean director;
            private Boolean owner;

            public Relationship build() {
                return new Relationship(this.accountOpener, this.director, this.owner);
            }

            public Builder setAccountOpener(Boolean accountOpener) {
                this.accountOpener = accountOpener;
                return this;
            }

            public Builder setDirector(Boolean director) {
                this.director = director;
                return this;
            }

            public Builder setOwner(Boolean owner) {
                this.owner = owner;
                return this;
            }
        }
    }

    public static class Builder {
        private String endingBefore;
        private List<String> expand;
        private Long limit;
        private Relationship relationship;
        private String startingAfter;

        public PersonCollectionListParams build() {
            return new PersonCollectionListParams(this.endingBefore, this.expand, this.limit, this.relationship, this.startingAfter);
        }

        public Builder setEndingBefore(String endingBefore) {
            this.endingBefore = endingBefore;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setLimit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder setRelationship(Relationship relationship) {
            this.relationship = relationship;
            return this;
        }

        public Builder setStartingAfter(String startingAfter) {
            this.startingAfter = startingAfter;
            return this;
        }
    }
}

