/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecipientUpdateParams
extends ApiRequestParams {
    @SerializedName(value="bank_account")
    String bankAccount;
    @SerializedName(value="card")
    String card;
    @SerializedName(value="default_card")
    String defaultCard;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="tax_id")
    String taxId;

    private RecipientUpdateParams(String bankAccount, String card, String defaultCard, String description, String email, List<String> expand, Map<String, String> metadata, String name, String taxId) {
        this.bankAccount = bankAccount;
        this.card = card;
        this.defaultCard = defaultCard;
        this.description = description;
        this.email = email;
        this.expand = expand;
        this.metadata = metadata;
        this.name = name;
        this.taxId = taxId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String bankAccount;
        private String card;
        private String defaultCard;
        private String description;
        private String email;
        private List<String> expand;
        private Map<String, String> metadata;
        private String name;
        private String taxId;

        public RecipientUpdateParams build() {
            return new RecipientUpdateParams(this.bankAccount, this.card, this.defaultCard, this.description, this.email, this.expand, this.metadata, this.name, this.taxId);
        }

        public Builder setBankAccount(String bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public Builder setCard(String card) {
            this.card = card;
            return this;
        }

        public Builder setDefaultCard(String defaultCard) {
            this.defaultCard = defaultCard;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTaxId(String taxId) {
            this.taxId = taxId;
            return this;
        }
    }
}

