/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SourceCreateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="flow")
    Flow flow;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="original_source")
    String originalSource;
    @SerializedName(value="owner")
    Owner owner;
    @SerializedName(value="receiver")
    Receiver receiver;
    @SerializedName(value="redirect")
    Redirect redirect;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="token")
    String token;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="usage")
    Usage usage;

    private SourceCreateParams(Long amount, String currency, String customer, List<String> expand, Flow flow, Map<String, String> metadata, String originalSource, Owner owner, Receiver receiver, Redirect redirect, String statementDescriptor, String token, String type, Usage usage) {
        this.amount = amount;
        this.currency = currency;
        this.customer = customer;
        this.expand = expand;
        this.flow = flow;
        this.metadata = metadata;
        this.originalSource = originalSource;
        this.owner = owner;
        this.receiver = receiver;
        this.redirect = redirect;
        this.statementDescriptor = statementDescriptor;
        this.token = token;
        this.type = type;
        this.usage = usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Usage implements ApiRequestParams.EnumParam
    {
        REUSABLE("reusable"),
        SINGLE_USE("single_use");

        private final String value;

        private Usage(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Flow implements ApiRequestParams.EnumParam
    {
        CODE_VERIFICATION("code_verification"),
        NONE("none"),
        RECEIVER("receiver"),
        REDIRECT("redirect");

        private final String value;

        private Flow(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Redirect {
        @SerializedName(value="return_url")
        String returnUrl;

        private Redirect(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String returnUrl;

            public Redirect build() {
                return new Redirect(this.returnUrl);
            }

            public Builder setReturnUrl(String returnUrl) {
                this.returnUrl = returnUrl;
                return this;
            }
        }
    }

    public static class Receiver {
        @SerializedName(value="refund_attributes_method")
        RefundAttributesMethod refundAttributesMethod;

        private Receiver(RefundAttributesMethod refundAttributesMethod) {
            this.refundAttributesMethod = refundAttributesMethod;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static enum RefundAttributesMethod implements ApiRequestParams.EnumParam
        {
            EMAIL("email"),
            MANUAL("manual"),
            NONE("none");

            private final String value;

            private RefundAttributesMethod(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private RefundAttributesMethod refundAttributesMethod;

            public Receiver build() {
                return new Receiver(this.refundAttributesMethod);
            }

            public Builder setRefundAttributesMethod(RefundAttributesMethod refundAttributesMethod) {
                this.refundAttributesMethod = refundAttributesMethod;
                return this;
            }
        }
    }

    public static class Owner {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        private Owner(Address address, String email, String name, String phone) {
            this.address = address;
            this.email = email;
            this.name = name;
            this.phone = phone;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private String email;
            private String name;
            private String phone;

            public Owner build() {
                return new Owner(this.address, this.email, this.name, this.phone);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setEmail(String email) {
                this.email = email;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }
        }
    }

    public static class Builder {
        private Long amount;
        private String currency;
        private String customer;
        private List<String> expand;
        private Flow flow;
        private Map<String, String> metadata;
        private String originalSource;
        private Owner owner;
        private Receiver receiver;
        private Redirect redirect;
        private String statementDescriptor;
        private String token;
        private String type;
        private Usage usage;

        public SourceCreateParams build() {
            return new SourceCreateParams(this.amount, this.currency, this.customer, this.expand, this.flow, this.metadata, this.originalSource, this.owner, this.receiver, this.redirect, this.statementDescriptor, this.token, this.type, this.usage);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setFlow(Flow flow) {
            this.flow = flow;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setOriginalSource(String originalSource) {
            this.originalSource = originalSource;
            return this;
        }

        public Builder setOwner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public Builder setReceiver(Receiver receiver) {
            this.receiver = receiver;
            return this;
        }

        public Builder setRedirect(Redirect redirect) {
            this.redirect = redirect;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setUsage(Usage usage) {
            this.usage = usage;
            return this;
        }
    }
}

