// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class ReaderListParams extends ApiRequestParams {
  /**
   * A cursor for use in pagination. `ending_before` is an object ID that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, starting with
   * `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the
   * previous page of the list.
   */
  @SerializedName("ending_before")
  String endingBefore;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /**
   * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
   * default is 10.
   */
  @SerializedName("limit")
  Long limit;

  /** A location id to filter the response list to only readers at the specific location. */
  @SerializedName("location")
  String location;

  /**
   * To group objects on your platform account by connected account, set this parameter to the
   * connected account operating your application.
   */
  @SerializedName("operator_account")
  String operatorAccount;

  /**
   * A cursor for use in pagination. `starting_after` is an object ID that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, ending with `obj_foo`,
   * your subsequent call can include `starting_after=obj_foo` in order to fetch the next page of
   * the list.
   */
  @SerializedName("starting_after")
  String startingAfter;

  /** A status filter to filter readers to only offline or online readers. */
  @SerializedName("status")
  String status;

  private ReaderListParams(
      String endingBefore,
      List<String> expand,
      Long limit,
      String location,
      String operatorAccount,
      String startingAfter,
      String status) {
    this.endingBefore = endingBefore;
    this.expand = expand;
    this.limit = limit;
    this.location = location;
    this.operatorAccount = operatorAccount;
    this.startingAfter = startingAfter;
    this.status = status;
  }

  public static Builder builder() {
    return new com.stripe.param.terminal.ReaderListParams.Builder();
  }

  public static class Builder {
    private String endingBefore;

    private List<String> expand;

    private Long limit;

    private String location;

    private String operatorAccount;

    private String startingAfter;

    private String status;

    /** Finalize and obtain parameter instance from this builder. */
    public ReaderListParams build() {
      return new ReaderListParams(
          this.endingBefore,
          this.expand,
          this.limit,
          this.location,
          this.operatorAccount,
          this.startingAfter,
          this.status);
    }

    /**
     * A cursor for use in pagination. `ending_before` is an object ID that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, starting with
     * `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the
     * previous page of the list.
     */
    public Builder setEndingBefore(String endingBefore) {
      this.endingBefore = endingBefore;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * ReaderListParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * ReaderListParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
     * default is 10.
     */
    public Builder setLimit(Long limit) {
      this.limit = limit;
      return this;
    }

    /** A location id to filter the response list to only readers at the specific location. */
    public Builder setLocation(String location) {
      this.location = location;
      return this;
    }

    /**
     * To group objects on your platform account by connected account, set this parameter to the
     * connected account operating your application.
     */
    public Builder setOperatorAccount(String operatorAccount) {
      this.operatorAccount = operatorAccount;
      return this;
    }

    /**
     * A cursor for use in pagination. `starting_after` is an object ID that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, ending with
     * `obj_foo`, your subsequent call can include `starting_after=obj_foo` in order to fetch the
     * next page of the list.
     */
    public Builder setStartingAfter(String startingAfter) {
      this.startingAfter = startingAfter;
      return this;
    }

    /** A status filter to filter readers to only offline or online readers. */
    public Builder setStatus(String status) {
      this.status = status;
      return this;
    }
  }
}
