/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stripe.net.UntypedMapDeserializer;
import java.io.IOException;
import java.util.Map;

public abstract class ApiRequestParams {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapterFactory((TypeAdapterFactory)new HasEmptyEnumTypeAdapterFactory()).create();
    private static final UntypedMapDeserializer UNTYPED_MAP_DESERIALIZER = new UntypedMapDeserializer();

    public Map<String, Object> toMap() {
        JsonObject json = GSON.toJsonTree((Object)this).getAsJsonObject();
        return UNTYPED_MAP_DESERIALIZER.deserialize(json);
    }

    private static class HasEmptyEnumTypeAdapterFactory
    implements TypeAdapterFactory {
        private HasEmptyEnumTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!EnumParam.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            TypeAdapter<EnumParam> paramEnum = new TypeAdapter<EnumParam>(){

                public void write(JsonWriter out, EnumParam value) throws IOException {
                    if (value.getValue().equals("")) {
                        boolean previousSetting = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        out.nullValue();
                        out.setSerializeNulls(previousSetting);
                    } else {
                        out.value(value.getValue());
                    }
                }

                public EnumParam read(JsonReader in) {
                    throw new UnsupportedOperationException("No deserialization is expected from this private type adapter for enum param.");
                }
            };
            return paramEnum.nullSafe();
        }
    }

    public static interface EnumParam {
        public String getValue();
    }
}

