/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ChargeUpdateParams
extends ApiRequestParams {
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="fraud_details")
    FraudDetails fraudDetails;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="shipping")
    Shipping shipping;
    @SerializedName(value="transfer_group")
    String transferGroup;

    private ChargeUpdateParams(String customer, String description, List<String> expand, FraudDetails fraudDetails, Map<String, String> metadata, String receiptEmail, Shipping shipping, String transferGroup) {
        this.customer = customer;
        this.description = description;
        this.expand = expand;
        this.fraudDetails = fraudDetails;
        this.metadata = metadata;
        this.receiptEmail = receiptEmail;
        this.shipping = shipping;
        this.transferGroup = transferGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Shipping {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="carrier")
        String carrier;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="tracking_number")
        String trackingNumber;

        private Shipping(Address address, String carrier, String name, String phone, String trackingNumber) {
            this.address = address;
            this.carrier = carrier;
            this.name = name;
            this.phone = phone;
            this.trackingNumber = trackingNumber;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private String carrier;
            private String name;
            private String phone;
            private String trackingNumber;

            public Shipping build() {
                return new Shipping(this.address, this.carrier, this.name, this.phone, this.trackingNumber);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setCarrier(String carrier) {
                this.carrier = carrier;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setTrackingNumber(String trackingNumber) {
                this.trackingNumber = trackingNumber;
                return this;
            }
        }
    }

    public static class FraudDetails {
        @SerializedName(value="user_report")
        ApiRequestParams.EnumParam userReport;

        private FraudDetails(ApiRequestParams.EnumParam userReport) {
            this.userReport = userReport;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static enum UserReport implements ApiRequestParams.EnumParam
        {
            FRAUDULENT("fraudulent"),
            SAFE("safe");

            private final String value;

            private UserReport(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private ApiRequestParams.EnumParam userReport;

            public FraudDetails build() {
                return new FraudDetails(this.userReport);
            }

            public Builder setUserReport(UserReport userReport) {
                this.userReport = userReport;
                return this;
            }

            public Builder setUserReport(EmptyParam userReport) {
                this.userReport = userReport;
                return this;
            }
        }
    }

    public static class Builder {
        private String customer;
        private String description;
        private List<String> expand;
        private FraudDetails fraudDetails;
        private Map<String, String> metadata;
        private String receiptEmail;
        private Shipping shipping;
        private String transferGroup;

        public ChargeUpdateParams build() {
            return new ChargeUpdateParams(this.customer, this.description, this.expand, this.fraudDetails, this.metadata, this.receiptEmail, this.shipping, this.transferGroup);
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setFraudDetails(FraudDetails fraudDetails) {
            this.fraudDetails = fraudDetails;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setReceiptEmail(String receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setShipping(Shipping shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setTransferGroup(String transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }
    }
}

