/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalAccountCollectionCreateParams
extends ApiRequestParams {
    @SerializedName(value="default_for_currency")
    Boolean defaultForCurrency;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="external_account")
    String externalAccount;
    @SerializedName(value="metadata")
    Map<String, String> metadata;

    private ExternalAccountCollectionCreateParams(Boolean defaultForCurrency, List<String> expand, String externalAccount, Map<String, String> metadata) {
        this.defaultForCurrency = defaultForCurrency;
        this.expand = expand;
        this.externalAccount = externalAccount;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean defaultForCurrency;
        private List<String> expand;
        private String externalAccount;
        private Map<String, String> metadata;

        public ExternalAccountCollectionCreateParams build() {
            return new ExternalAccountCollectionCreateParams(this.defaultForCurrency, this.expand, this.externalAccount, this.metadata);
        }

        public Builder setDefaultForCurrency(Boolean defaultForCurrency) {
            this.defaultForCurrency = defaultForCurrency;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setExternalAccount(String externalAccount) {
            this.externalAccount = externalAccount;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }
    }
}

