/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class InvoicePayParams
extends ApiRequestParams {
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="forgive")
    Boolean forgive;
    @SerializedName(value="paid_out_of_band")
    Boolean paidOutOfBand;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="source")
    String source;

    private InvoicePayParams(List<String> expand, Boolean forgive, Boolean paidOutOfBand, String paymentMethod, String source) {
        this.expand = expand;
        this.forgive = forgive;
        this.paidOutOfBand = paidOutOfBand;
        this.paymentMethod = paymentMethod;
        this.source = source;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> expand;
        private Boolean forgive;
        private Boolean paidOutOfBand;
        private String paymentMethod;
        private String source;

        public InvoicePayParams build() {
            return new InvoicePayParams(this.expand, this.forgive, this.paidOutOfBand, this.paymentMethod, this.source);
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setForgive(Boolean forgive) {
            this.forgive = forgive;
            return this;
        }

        public Builder setPaidOutOfBand(Boolean paidOutOfBand) {
            this.paidOutOfBand = paidOutOfBand;
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }
    }
}

