// Generated by delombok at Thu Apr 18 12:48:43 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.WebhookEndpointCreateParams;
import com.stripe.param.WebhookEndpointListParams;
import com.stripe.param.WebhookEndpointRetrieveParams;
import com.stripe.param.WebhookEndpointUpdateParams;
import java.util.List;
import java.util.Map;

public class WebhookEndpoint extends ApiResource implements HasId {
  /**
   * The API version events are rendered as for this webhook endpoint.
   */
  @SerializedName("api_version")
  String apiVersion;
  /**
   * The ID of the associated Connect application.
   */
  @SerializedName("application")
  String application;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * The list of events to enable for this endpoint. You may specify `['*']` to enable all events.
   */
  @SerializedName("enabled_events")
  List<String> enabledEvents;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * The endpoint's secret, used to generate [webhook
   * signatures](https://stripe.com/docs/webhooks/signatures). Only returned at creation.
   */
  @SerializedName("secret")
  String secret;
  /**
   * The status of the webhook. It can be `enabled` or `disabled`.
   */
  @SerializedName("status")
  String status;
  /**
   * The URL of the webhook endpoint.
   */
  @SerializedName("url")
  String url;

  /**
   * Returns a list of your webhook endpoints.
   */
  public static WebhookEndpointCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your webhook endpoints.
   */
  public static WebhookEndpointCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/webhook_endpoints");
    return requestCollection(url, params, WebhookEndpointCollection.class, options);
  }

  /**
   * Returns a list of your webhook endpoints.
   */
  public static WebhookEndpointCollection list(WebhookEndpointListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your webhook endpoints.
   */
  public static WebhookEndpointCollection list(WebhookEndpointListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/webhook_endpoints");
    return requestCollection(url, params, WebhookEndpointCollection.class, options);
  }

  /**
   * Retrieves the webhook endpoint with the given ID.
   */
  public static WebhookEndpoint retrieve(String webhookEndpoint) throws StripeException {
    return retrieve(webhookEndpoint, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the webhook endpoint with the given ID.
   */
  public static WebhookEndpoint retrieve(String webhookEndpoint, RequestOptions options) throws StripeException {
    return retrieve(webhookEndpoint, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the webhook endpoint with the given ID.
   */
  public static WebhookEndpoint retrieve(String webhookEndpoint, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(webhookEndpoint)));
    return request(ApiResource.RequestMethod.GET, url, params, WebhookEndpoint.class, options);
  }

  /**
   * Retrieves the webhook endpoint with the given ID.
   */
  public static WebhookEndpoint retrieve(String webhookEndpoint, WebhookEndpointRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(webhookEndpoint)));
    return request(ApiResource.RequestMethod.GET, url, params, WebhookEndpoint.class, options);
  }

  /**
   * A webhook endpoint must have a <code>url</code> and a list of <code>enabled_events</code>. You
   * may optionally specify the Boolean <code>connect</code> parameter. If set to true, then a
   * Connect webhook endpoint that notifies the specified <code>url</code> about events from all
   * connected accounts is created; otherwise an account webhook endpoint that notifies the
   * specified <code>url</code> only about events from your account is created. You can also create
   * webhook endpoints in the <a href="https://dashboard.stripe.com/account/webhooks">webhooks
   * settings</a> section of the Dashboard.
   */
  public static WebhookEndpoint create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * A webhook endpoint must have a <code>url</code> and a list of <code>enabled_events</code>. You
   * may optionally specify the Boolean <code>connect</code> parameter. If set to true, then a
   * Connect webhook endpoint that notifies the specified <code>url</code> about events from all
   * connected accounts is created; otherwise an account webhook endpoint that notifies the
   * specified <code>url</code> only about events from your account is created. You can also create
   * webhook endpoints in the <a href="https://dashboard.stripe.com/account/webhooks">webhooks
   * settings</a> section of the Dashboard.
   */
  public static WebhookEndpoint create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/webhook_endpoints");
    return request(ApiResource.RequestMethod.POST, url, params, WebhookEndpoint.class, options);
  }

  /**
   * A webhook endpoint must have a <code>url</code> and a list of <code>enabled_events</code>. You
   * may optionally specify the Boolean <code>connect</code> parameter. If set to true, then a
   * Connect webhook endpoint that notifies the specified <code>url</code> about events from all
   * connected accounts is created; otherwise an account webhook endpoint that notifies the
   * specified <code>url</code> only about events from your account is created. You can also create
   * webhook endpoints in the <a href="https://dashboard.stripe.com/account/webhooks">webhooks
   * settings</a> section of the Dashboard.
   */
  public static WebhookEndpoint create(WebhookEndpointCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * A webhook endpoint must have a <code>url</code> and a list of <code>enabled_events</code>. You
   * may optionally specify the Boolean <code>connect</code> parameter. If set to true, then a
   * Connect webhook endpoint that notifies the specified <code>url</code> about events from all
   * connected accounts is created; otherwise an account webhook endpoint that notifies the
   * specified <code>url</code> only about events from your account is created. You can also create
   * webhook endpoints in the <a href="https://dashboard.stripe.com/account/webhooks">webhooks
   * settings</a> section of the Dashboard.
   */
  public static WebhookEndpoint create(WebhookEndpointCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/webhook_endpoints");
    return request(ApiResource.RequestMethod.POST, url, params, WebhookEndpoint.class, options);
  }

  /**
   * Updates the webhook endpoint. You may edit the <code>url</code>, the list of <code>
   * enabled_events</code>, and the status of your endpoint.
   */
  public WebhookEndpoint update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the webhook endpoint. You may edit the <code>url</code>, the list of <code>
   * enabled_events</code>, and the status of your endpoint.
   */
  public WebhookEndpoint update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, WebhookEndpoint.class, options);
  }

  /**
   * Updates the webhook endpoint. You may edit the <code>url</code>, the list of <code>
   * enabled_events</code>, and the status of your endpoint.
   */
  public WebhookEndpoint update(WebhookEndpointUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the webhook endpoint. You may edit the <code>url</code>, the list of <code>
   * enabled_events</code>, and the status of your endpoint.
   */
  public WebhookEndpoint update(WebhookEndpointUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, WebhookEndpoint.class, options);
  }

  /**
   * You can also delete webhook endpoints via the <a
   * href="https://dashboard.stripe.com/account/webhooks">webhook endpoint management</a> page of
   * the Stripe dashboard.
   */
  public WebhookEndpoint delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * You can also delete webhook endpoints via the <a
   * href="https://dashboard.stripe.com/account/webhooks">webhook endpoint management</a> page of
   * the Stripe dashboard.
   */
  public WebhookEndpoint delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * You can also delete webhook endpoints via the <a
   * href="https://dashboard.stripe.com/account/webhooks">webhook endpoint management</a> page of
   * the Stripe dashboard.
   */
  public WebhookEndpoint delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * You can also delete webhook endpoints via the <a
   * href="https://dashboard.stripe.com/account/webhooks">webhook endpoint management</a> page of
   * the Stripe dashboard.
   */
  public WebhookEndpoint delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.DELETE, url, params, WebhookEndpoint.class, options);
  }

  /**
   * The API version events are rendered as for this webhook endpoint.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getApiVersion() {
    return this.apiVersion;
  }

  /**
   * The ID of the associated Connect application.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getApplication() {
    return this.application;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * The list of events to enable for this endpoint. You may specify `['*']` to enable all events.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getEnabledEvents() {
    return this.enabledEvents;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The endpoint's secret, used to generate [webhook
   * signatures](https://stripe.com/docs/webhooks/signatures). Only returned at creation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSecret() {
    return this.secret;
  }

  /**
   * The status of the webhook. It can be `enabled` or `disabled`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The URL of the webhook endpoint.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUrl() {
    return this.url;
  }

  /**
   * The API version events are rendered as for this webhook endpoint.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApiVersion(final String apiVersion) {
    this.apiVersion = apiVersion;
  }

  /**
   * The ID of the associated Connect application.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplication(final String application) {
    this.application = application;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * The list of events to enable for this endpoint. You may specify `['*']` to enable all events.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEnabledEvents(final List<String> enabledEvents) {
    this.enabledEvents = enabledEvents;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The endpoint's secret, used to generate [webhook
   * signatures](https://stripe.com/docs/webhooks/signatures). Only returned at creation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSecret(final String secret) {
    this.secret = secret;
  }

  /**
   * The status of the webhook. It can be `enabled` or `disabled`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * The URL of the webhook endpoint.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUrl(final String url) {
    this.url = url;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof WebhookEndpoint)) return false;
    final WebhookEndpoint other = (WebhookEndpoint) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$apiVersion = this.getApiVersion();
    final java.lang.Object other$apiVersion = other.getApiVersion();
    if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$enabledEvents = this.getEnabledEvents();
    final java.lang.Object other$enabledEvents = other.getEnabledEvents();
    if (this$enabledEvents == null ? other$enabledEvents != null : !this$enabledEvents.equals(other$enabledEvents)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$secret = this.getSecret();
    final java.lang.Object other$secret = other.getSecret();
    if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$url = this.getUrl();
    final java.lang.Object other$url = other.getUrl();
    if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof WebhookEndpoint;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $apiVersion = this.getApiVersion();
    result = result * PRIME + ($apiVersion == null ? 43 : $apiVersion.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $enabledEvents = this.getEnabledEvents();
    result = result * PRIME + ($enabledEvents == null ? 43 : $enabledEvents.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $secret = this.getSecret();
    result = result * PRIME + ($secret == null ? 43 : $secret.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $url = this.getUrl();
    result = result * PRIME + ($url == null ? 43 : $url.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
