// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class OrderListParams extends ApiRequestParams {
  /** Date this order was created. */
  @SerializedName("created")
  Object created;

  /** Only return orders for the given customer. */
  @SerializedName("customer")
  String customer;

  /**
   * A cursor for use in pagination. `ending_before` is an object ID that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, starting with
   * `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the
   * previous page of the list.
   */
  @SerializedName("ending_before")
  String endingBefore;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /** Only return orders with the given IDs. */
  @SerializedName("ids")
  List<String> ids;

  /**
   * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
   * default is 10.
   */
  @SerializedName("limit")
  Long limit;

  /**
   * A cursor for use in pagination. `starting_after` is an object ID that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, ending with `obj_foo`,
   * your subsequent call can include `starting_after=obj_foo` in order to fetch the next page of
   * the list.
   */
  @SerializedName("starting_after")
  String startingAfter;

  /**
   * Only return orders that have the given status. One of `created`, `paid`, `fulfilled`, or
   * `refunded`.
   */
  @SerializedName("status")
  String status;

  /** Filter orders based on when they were paid, fulfilled, canceled, or returned. */
  @SerializedName("status_transitions")
  StatusTransitions statusTransitions;

  /** Only return orders with the given upstream order IDs. */
  @SerializedName("upstream_ids")
  List<String> upstreamIds;

  private OrderListParams(
      Object created,
      String customer,
      String endingBefore,
      List<String> expand,
      List<String> ids,
      Long limit,
      String startingAfter,
      String status,
      StatusTransitions statusTransitions,
      List<String> upstreamIds) {
    this.created = created;
    this.customer = customer;
    this.endingBefore = endingBefore;
    this.expand = expand;
    this.ids = ids;
    this.limit = limit;
    this.startingAfter = startingAfter;
    this.status = status;
    this.statusTransitions = statusTransitions;
    this.upstreamIds = upstreamIds;
  }

  public static Builder builder() {
    return new com.stripe.param.OrderListParams.Builder();
  }

  public static class Builder {
    private Object created;

    private String customer;

    private String endingBefore;

    private List<String> expand;

    private List<String> ids;

    private Long limit;

    private String startingAfter;

    private String status;

    private StatusTransitions statusTransitions;

    private List<String> upstreamIds;

    /** Finalize and obtain parameter instance from this builder. */
    public OrderListParams build() {
      return new OrderListParams(
          this.created,
          this.customer,
          this.endingBefore,
          this.expand,
          this.ids,
          this.limit,
          this.startingAfter,
          this.status,
          this.statusTransitions,
          this.upstreamIds);
    }

    /** Date this order was created. */
    public Builder setCreated(Created created) {
      this.created = created;
      return this;
    }

    /** Date this order was created. */
    public Builder setCreated(Long created) {
      this.created = created;
      return this;
    }

    /** Only return orders for the given customer. */
    public Builder setCustomer(String customer) {
      this.customer = customer;
      return this;
    }

    /**
     * A cursor for use in pagination. `ending_before` is an object ID that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, starting with
     * `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the
     * previous page of the list.
     */
    public Builder setEndingBefore(String endingBefore) {
      this.endingBefore = endingBefore;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * OrderListParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * OrderListParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add an element to `ids` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * OrderListParams#ids} for the field documentation.
     */
    public Builder addId(String element) {
      if (this.ids == null) {
        this.ids = new ArrayList<>();
      }
      this.ids.add(element);
      return this;
    }

    /**
     * Add all elements to `ids` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * OrderListParams#ids} for the field documentation.
     */
    public Builder addAllId(List<String> elements) {
      if (this.ids == null) {
        this.ids = new ArrayList<>();
      }
      this.ids.addAll(elements);
      return this;
    }

    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
     * default is 10.
     */
    public Builder setLimit(Long limit) {
      this.limit = limit;
      return this;
    }

    /**
     * A cursor for use in pagination. `starting_after` is an object ID that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, ending with
     * `obj_foo`, your subsequent call can include `starting_after=obj_foo` in order to fetch the
     * next page of the list.
     */
    public Builder setStartingAfter(String startingAfter) {
      this.startingAfter = startingAfter;
      return this;
    }

    /**
     * Only return orders that have the given status. One of `created`, `paid`, `fulfilled`, or
     * `refunded`.
     */
    public Builder setStatus(String status) {
      this.status = status;
      return this;
    }

    /** Filter orders based on when they were paid, fulfilled, canceled, or returned. */
    public Builder setStatusTransitions(StatusTransitions statusTransitions) {
      this.statusTransitions = statusTransitions;
      return this;
    }

    /**
     * Add an element to `upstreamIds` list. A list is initialized for the first `add/addAll` call,
     * and subsequent calls adds additional elements to the original list. See {@link
     * OrderListParams#upstreamIds} for the field documentation.
     */
    public Builder addUpstreamId(String element) {
      if (this.upstreamIds == null) {
        this.upstreamIds = new ArrayList<>();
      }
      this.upstreamIds.add(element);
      return this;
    }

    /**
     * Add all elements to `upstreamIds` list. A list is initialized for the first `add/addAll`
     * call, and subsequent calls adds additional elements to the original list. See {@link
     * OrderListParams#upstreamIds} for the field documentation.
     */
    public Builder addAllUpstreamId(List<String> elements) {
      if (this.upstreamIds == null) {
        this.upstreamIds = new ArrayList<>();
      }
      this.upstreamIds.addAll(elements);
      return this;
    }
  }

  public static class Created {
    /** Minimum value to filter by (exclusive). */
    @SerializedName("gt")
    Long gt;

    /** Minimum value to filter by (inclusive). */
    @SerializedName("gte")
    Long gte;

    /** Maximum value to filter by (exclusive). */
    @SerializedName("lt")
    Long lt;

    /** Maximum value to filter by (inclusive). */
    @SerializedName("lte")
    Long lte;

    private Created(Long gt, Long gte, Long lt, Long lte) {
      this.gt = gt;
      this.gte = gte;
      this.lt = lt;
      this.lte = lte;
    }

    public static Builder builder() {
      return new com.stripe.param.OrderListParams.Created.Builder();
    }

    public static class Builder {
      private Long gt;

      private Long gte;

      private Long lt;

      private Long lte;

      /** Finalize and obtain parameter instance from this builder. */
      public Created build() {
        return new Created(this.gt, this.gte, this.lt, this.lte);
      }

      /** Minimum value to filter by (exclusive). */
      public Builder setGt(Long gt) {
        this.gt = gt;
        return this;
      }

      /** Minimum value to filter by (inclusive). */
      public Builder setGte(Long gte) {
        this.gte = gte;
        return this;
      }

      /** Maximum value to filter by (exclusive). */
      public Builder setLt(Long lt) {
        this.lt = lt;
        return this;
      }

      /** Maximum value to filter by (inclusive). */
      public Builder setLte(Long lte) {
        this.lte = lte;
        return this;
      }
    }
  }

  public static class StatusTransitions {
    /** Date this order was canceled. */
    @SerializedName("canceled")
    Object canceled;

    /** Date this order was fulfilled. */
    @SerializedName("fulfilled")
    Object fulfilled;

    /** Date this order was paid. */
    @SerializedName("paid")
    Object paid;

    /** Date this order was returned. */
    @SerializedName("returned")
    Object returned;

    private StatusTransitions(Object canceled, Object fulfilled, Object paid, Object returned) {
      this.canceled = canceled;
      this.fulfilled = fulfilled;
      this.paid = paid;
      this.returned = returned;
    }

    public static Builder builder() {
      return new com.stripe.param.OrderListParams.StatusTransitions.Builder();
    }

    public static class Builder {
      private Object canceled;

      private Object fulfilled;

      private Object paid;

      private Object returned;

      /** Finalize and obtain parameter instance from this builder. */
      public StatusTransitions build() {
        return new StatusTransitions(this.canceled, this.fulfilled, this.paid, this.returned);
      }

      /** Date this order was canceled. */
      public Builder setCanceled(Canceled canceled) {
        this.canceled = canceled;
        return this;
      }

      /** Date this order was canceled. */
      public Builder setCanceled(Long canceled) {
        this.canceled = canceled;
        return this;
      }

      /** Date this order was fulfilled. */
      public Builder setFulfilled(Fulfilled fulfilled) {
        this.fulfilled = fulfilled;
        return this;
      }

      /** Date this order was fulfilled. */
      public Builder setFulfilled(Long fulfilled) {
        this.fulfilled = fulfilled;
        return this;
      }

      /** Date this order was paid. */
      public Builder setPaid(Paid paid) {
        this.paid = paid;
        return this;
      }

      /** Date this order was paid. */
      public Builder setPaid(Long paid) {
        this.paid = paid;
        return this;
      }

      /** Date this order was returned. */
      public Builder setReturned(Returned returned) {
        this.returned = returned;
        return this;
      }

      /** Date this order was returned. */
      public Builder setReturned(Long returned) {
        this.returned = returned;
        return this;
      }
    }

    public static class Canceled {
      /** Minimum value to filter by (exclusive). */
      @SerializedName("gt")
      Long gt;

      /** Minimum value to filter by (inclusive). */
      @SerializedName("gte")
      Long gte;

      /** Maximum value to filter by (exclusive). */
      @SerializedName("lt")
      Long lt;

      /** Maximum value to filter by (inclusive). */
      @SerializedName("lte")
      Long lte;

      private Canceled(Long gt, Long gte, Long lt, Long lte) {
        this.gt = gt;
        this.gte = gte;
        this.lt = lt;
        this.lte = lte;
      }

      public static Builder builder() {
        return new com.stripe.param.OrderListParams.StatusTransitions.Canceled.Builder();
      }

      public static class Builder {
        private Long gt;

        private Long gte;

        private Long lt;

        private Long lte;

        /** Finalize and obtain parameter instance from this builder. */
        public Canceled build() {
          return new Canceled(this.gt, this.gte, this.lt, this.lte);
        }

        /** Minimum value to filter by (exclusive). */
        public Builder setGt(Long gt) {
          this.gt = gt;
          return this;
        }

        /** Minimum value to filter by (inclusive). */
        public Builder setGte(Long gte) {
          this.gte = gte;
          return this;
        }

        /** Maximum value to filter by (exclusive). */
        public Builder setLt(Long lt) {
          this.lt = lt;
          return this;
        }

        /** Maximum value to filter by (inclusive). */
        public Builder setLte(Long lte) {
          this.lte = lte;
          return this;
        }
      }
    }

    public static class Fulfilled {
      /** Minimum value to filter by (exclusive). */
      @SerializedName("gt")
      Long gt;

      /** Minimum value to filter by (inclusive). */
      @SerializedName("gte")
      Long gte;

      /** Maximum value to filter by (exclusive). */
      @SerializedName("lt")
      Long lt;

      /** Maximum value to filter by (inclusive). */
      @SerializedName("lte")
      Long lte;

      private Fulfilled(Long gt, Long gte, Long lt, Long lte) {
        this.gt = gt;
        this.gte = gte;
        this.lt = lt;
        this.lte = lte;
      }

      public static Builder builder() {
        return new com.stripe.param.OrderListParams.StatusTransitions.Fulfilled.Builder();
      }

      public static class Builder {
        private Long gt;

        private Long gte;

        private Long lt;

        private Long lte;

        /** Finalize and obtain parameter instance from this builder. */
        public Fulfilled build() {
          return new Fulfilled(this.gt, this.gte, this.lt, this.lte);
        }

        /** Minimum value to filter by (exclusive). */
        public Builder setGt(Long gt) {
          this.gt = gt;
          return this;
        }

        /** Minimum value to filter by (inclusive). */
        public Builder setGte(Long gte) {
          this.gte = gte;
          return this;
        }

        /** Maximum value to filter by (exclusive). */
        public Builder setLt(Long lt) {
          this.lt = lt;
          return this;
        }

        /** Maximum value to filter by (inclusive). */
        public Builder setLte(Long lte) {
          this.lte = lte;
          return this;
        }
      }
    }

    public static class Paid {
      /** Minimum value to filter by (exclusive). */
      @SerializedName("gt")
      Long gt;

      /** Minimum value to filter by (inclusive). */
      @SerializedName("gte")
      Long gte;

      /** Maximum value to filter by (exclusive). */
      @SerializedName("lt")
      Long lt;

      /** Maximum value to filter by (inclusive). */
      @SerializedName("lte")
      Long lte;

      private Paid(Long gt, Long gte, Long lt, Long lte) {
        this.gt = gt;
        this.gte = gte;
        this.lt = lt;
        this.lte = lte;
      }

      public static Builder builder() {
        return new com.stripe.param.OrderListParams.StatusTransitions.Paid.Builder();
      }

      public static class Builder {
        private Long gt;

        private Long gte;

        private Long lt;

        private Long lte;

        /** Finalize and obtain parameter instance from this builder. */
        public Paid build() {
          return new Paid(this.gt, this.gte, this.lt, this.lte);
        }

        /** Minimum value to filter by (exclusive). */
        public Builder setGt(Long gt) {
          this.gt = gt;
          return this;
        }

        /** Minimum value to filter by (inclusive). */
        public Builder setGte(Long gte) {
          this.gte = gte;
          return this;
        }

        /** Maximum value to filter by (exclusive). */
        public Builder setLt(Long lt) {
          this.lt = lt;
          return this;
        }

        /** Maximum value to filter by (inclusive). */
        public Builder setLte(Long lte) {
          this.lte = lte;
          return this;
        }
      }
    }

    public static class Returned {
      /** Minimum value to filter by (exclusive). */
      @SerializedName("gt")
      Long gt;

      /** Minimum value to filter by (inclusive). */
      @SerializedName("gte")
      Long gte;

      /** Maximum value to filter by (exclusive). */
      @SerializedName("lt")
      Long lt;

      /** Maximum value to filter by (inclusive). */
      @SerializedName("lte")
      Long lte;

      private Returned(Long gt, Long gte, Long lt, Long lte) {
        this.gt = gt;
        this.gte = gte;
        this.lt = lt;
        this.lte = lte;
      }

      public static Builder builder() {
        return new com.stripe.param.OrderListParams.StatusTransitions.Returned.Builder();
      }

      public static class Builder {
        private Long gt;

        private Long gte;

        private Long lt;

        private Long lte;

        /** Finalize and obtain parameter instance from this builder. */
        public Returned build() {
          return new Returned(this.gt, this.gte, this.lt, this.lte);
        }

        /** Minimum value to filter by (exclusive). */
        public Builder setGt(Long gt) {
          this.gt = gt;
          return this;
        }

        /** Minimum value to filter by (inclusive). */
        public Builder setGte(Long gte) {
          this.gte = gte;
          return this;
        }

        /** Maximum value to filter by (exclusive). */
        public Builder setLt(Long lt) {
          this.lt = lt;
          return this;
        }

        /** Maximum value to filter by (inclusive). */
        public Builder setLte(Long lte) {
          this.lte = lte;
          return this;
        }
      }
    }
  }
}
