// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class SourceRetrieveParams extends ApiRequestParams {
  /**
   * The client secret of the source. Required if a publishable key is used to retrieve the source.
   */
  @SerializedName("client_secret")
  String clientSecret;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  private SourceRetrieveParams(String clientSecret, List<String> expand) {
    this.clientSecret = clientSecret;
    this.expand = expand;
  }

  public static Builder builder() {
    return new com.stripe.param.SourceRetrieveParams.Builder();
  }

  public static class Builder {
    private String clientSecret;

    private List<String> expand;

    /** Finalize and obtain parameter instance from this builder. */
    public SourceRetrieveParams build() {
      return new SourceRetrieveParams(this.clientSecret, this.expand);
    }

    /**
     * The client secret of the source. Required if a publishable key is used to retrieve the
     * source.
     */
    public Builder setClientSecret(String clientSecret) {
      this.clientSecret = clientSecret;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SourceRetrieveParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SourceRetrieveParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }
  }
}
