/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PayoutCreateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="destination")
    String destination;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="method")
    Method method;
    @SerializedName(value="source_type")
    SourceType sourceType;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;

    private PayoutCreateParams(Long amount, String currency, String description, String destination, List<String> expand, Map<String, String> metadata, Method method, SourceType sourceType, String statementDescriptor) {
        this.amount = amount;
        this.currency = currency;
        this.description = description;
        this.destination = destination;
        this.expand = expand;
        this.metadata = metadata;
        this.method = method;
        this.sourceType = sourceType;
        this.statementDescriptor = statementDescriptor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum SourceType implements ApiRequestParams.EnumParam
    {
        BANK_ACCOUNT("bank_account"),
        CARD("card");

        private final String value;

        private SourceType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Method implements ApiRequestParams.EnumParam
    {
        INSTANT("instant"),
        STANDARD("standard");

        private final String value;

        private Method(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private Long amount;
        private String currency;
        private String description;
        private String destination;
        private List<String> expand;
        private Map<String, String> metadata;
        private Method method;
        private SourceType sourceType;
        private String statementDescriptor;

        public PayoutCreateParams build() {
            return new PayoutCreateParams(this.amount, this.currency, this.description, this.destination, this.expand, this.metadata, this.method, this.sourceType, this.statementDescriptor);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDestination(String destination) {
            this.destination = destination;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Builder setSourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }
    }
}

