/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SubscriptionScheduleCreateParams
extends ApiRequestParams {
    @SerializedName(value="billing")
    Billing billing;
    @SerializedName(value="billing_thresholds")
    Object billingThresholds;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="from_subscription")
    String fromSubscription;
    @SerializedName(value="invoice_settings")
    InvoiceSettings invoiceSettings;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="phases")
    List<Phase> phases;
    @SerializedName(value="renewal_behavior")
    RenewalBehavior renewalBehavior;
    @SerializedName(value="renewal_interval")
    RenewalInterval renewalInterval;
    @SerializedName(value="start_date")
    Object startDate;

    private SubscriptionScheduleCreateParams(Billing billing, Object billingThresholds, String customer, List<String> expand, String fromSubscription, InvoiceSettings invoiceSettings, Map<String, String> metadata, List<Phase> phases, RenewalBehavior renewalBehavior, RenewalInterval renewalInterval, Object startDate) {
        this.billing = billing;
        this.billingThresholds = billingThresholds;
        this.customer = customer;
        this.expand = expand;
        this.fromSubscription = fromSubscription;
        this.invoiceSettings = invoiceSettings;
        this.metadata = metadata;
        this.phases = phases;
        this.renewalBehavior = renewalBehavior;
        this.renewalInterval = renewalInterval;
        this.startDate = startDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum StartDate implements ApiRequestParams.EnumParam
    {
        NOW("now");

        private final String value;

        private StartDate(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum RenewalBehavior implements ApiRequestParams.EnumParam
    {
        NONE("none"),
        RELEASE("release"),
        RENEW("renew");

        private final String value;

        private RenewalBehavior(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Billing implements ApiRequestParams.EnumParam
    {
        CHARGE_AUTOMATICALLY("charge_automatically"),
        SEND_INVOICE("send_invoice");

        private final String value;

        private Billing(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class RenewalInterval {
        @SerializedName(value="interval")
        Interval interval;
        @SerializedName(value="length")
        Long length;

        private RenewalInterval(Interval interval, Long length) {
            this.interval = interval;
            this.length = length;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static enum Interval implements ApiRequestParams.EnumParam
        {
            DAY("day"),
            MONTH("month"),
            WEEK("week"),
            YEAR("year");

            private final String value;

            private Interval(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Interval interval;
            private Long length;

            public RenewalInterval build() {
                return new RenewalInterval(this.interval, this.length);
            }

            public Builder setInterval(Interval interval) {
                this.interval = interval;
                return this;
            }

            public Builder setLength(Long length) {
                this.length = length;
                return this;
            }
        }
    }

    public static class Phase {
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="coupon")
        String coupon;
        @SerializedName(value="end_date")
        Long endDate;
        @SerializedName(value="iterations")
        Long iterations;
        @SerializedName(value="plans")
        List<Plan> plans;
        @SerializedName(value="tax_percent")
        BigDecimal taxPercent;
        @SerializedName(value="trial")
        Boolean trial;
        @SerializedName(value="trial_end")
        Long trialEnd;

        private Phase(BigDecimal applicationFeePercent, String coupon, Long endDate, Long iterations, List<Plan> plans, BigDecimal taxPercent, Boolean trial, Long trialEnd) {
            this.applicationFeePercent = applicationFeePercent;
            this.coupon = coupon;
            this.endDate = endDate;
            this.iterations = iterations;
            this.plans = plans;
            this.taxPercent = taxPercent;
            this.trial = trial;
            this.trialEnd = trialEnd;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Plan {
            @SerializedName(value="billing_thresholds")
            Object billingThresholds;
            @SerializedName(value="plan")
            String plan;
            @SerializedName(value="quantity")
            Long quantity;

            private Plan(Object billingThresholds, String plan, Long quantity) {
                this.billingThresholds = billingThresholds;
                this.plan = plan;
                this.quantity = quantity;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class BillingThresholds {
                @SerializedName(value="usage_gte")
                Long usageGte;

                private BillingThresholds(Long usageGte) {
                    this.usageGte = usageGte;
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder {
                    private Long usageGte;

                    public BillingThresholds build() {
                        return new BillingThresholds(this.usageGte);
                    }

                    public Builder setUsageGte(Long usageGte) {
                        this.usageGte = usageGte;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Object billingThresholds;
                private String plan;
                private Long quantity;

                public Plan build() {
                    return new Plan(this.billingThresholds, this.plan, this.quantity);
                }

                public Builder setBillingThresholds(BillingThresholds billingThresholds) {
                    this.billingThresholds = billingThresholds;
                    return this;
                }

                public Builder setBillingThresholds(EmptyParam billingThresholds) {
                    this.billingThresholds = billingThresholds;
                    return this;
                }

                public Builder setPlan(String plan) {
                    this.plan = plan;
                    return this;
                }

                public Builder setQuantity(Long quantity) {
                    this.quantity = quantity;
                    return this;
                }
            }
        }

        public static class Builder {
            private BigDecimal applicationFeePercent;
            private String coupon;
            private Long endDate;
            private Long iterations;
            private List<Plan> plans;
            private BigDecimal taxPercent;
            private Boolean trial;
            private Long trialEnd;

            public Phase build() {
                return new Phase(this.applicationFeePercent, this.coupon, this.endDate, this.iterations, this.plans, this.taxPercent, this.trial, this.trialEnd);
            }

            public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
                this.applicationFeePercent = applicationFeePercent;
                return this;
            }

            public Builder setCoupon(String coupon) {
                this.coupon = coupon;
                return this;
            }

            public Builder setEndDate(Long endDate) {
                this.endDate = endDate;
                return this;
            }

            public Builder setIterations(Long iterations) {
                this.iterations = iterations;
                return this;
            }

            public Builder addPlan(Plan element) {
                if (this.plans == null) {
                    this.plans = new ArrayList<Plan>();
                }
                this.plans.add(element);
                return this;
            }

            public Builder addAllPlan(List<Plan> elements) {
                if (this.plans == null) {
                    this.plans = new ArrayList<Plan>();
                }
                this.plans.addAll(elements);
                return this;
            }

            public Builder setTaxPercent(BigDecimal taxPercent) {
                this.taxPercent = taxPercent;
                return this;
            }

            public Builder setTrial(Boolean trial) {
                this.trial = trial;
                return this;
            }

            public Builder setTrialEnd(Long trialEnd) {
                this.trialEnd = trialEnd;
                return this;
            }
        }
    }

    public static class InvoiceSettings {
        @SerializedName(value="days_until_due")
        Long daysUntilDue;

        private InvoiceSettings(Long daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Long daysUntilDue;

            public InvoiceSettings build() {
                return new InvoiceSettings(this.daysUntilDue);
            }

            public Builder setDaysUntilDue(Long daysUntilDue) {
                this.daysUntilDue = daysUntilDue;
                return this;
            }
        }
    }

    public static class BillingThresholds {
        @SerializedName(value="amount_gte")
        Long amountGte;
        @SerializedName(value="reset_billing_cycle_anchor")
        Boolean resetBillingCycleAnchor;

        private BillingThresholds(Long amountGte, Boolean resetBillingCycleAnchor) {
            this.amountGte = amountGte;
            this.resetBillingCycleAnchor = resetBillingCycleAnchor;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Long amountGte;
            private Boolean resetBillingCycleAnchor;

            public BillingThresholds build() {
                return new BillingThresholds(this.amountGte, this.resetBillingCycleAnchor);
            }

            public Builder setAmountGte(Long amountGte) {
                this.amountGte = amountGte;
                return this;
            }

            public Builder setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
                this.resetBillingCycleAnchor = resetBillingCycleAnchor;
                return this;
            }
        }
    }

    public static class Builder {
        private Billing billing;
        private Object billingThresholds;
        private String customer;
        private List<String> expand;
        private String fromSubscription;
        private InvoiceSettings invoiceSettings;
        private Map<String, String> metadata;
        private List<Phase> phases;
        private RenewalBehavior renewalBehavior;
        private RenewalInterval renewalInterval;
        private Object startDate;

        public SubscriptionScheduleCreateParams build() {
            return new SubscriptionScheduleCreateParams(this.billing, this.billingThresholds, this.customer, this.expand, this.fromSubscription, this.invoiceSettings, this.metadata, this.phases, this.renewalBehavior, this.renewalInterval, this.startDate);
        }

        public Builder setBilling(Billing billing) {
            this.billing = billing;
            return this;
        }

        public Builder setBillingThresholds(BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
            return this;
        }

        public Builder setBillingThresholds(EmptyParam billingThresholds) {
            this.billingThresholds = billingThresholds;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setFromSubscription(String fromSubscription) {
            this.fromSubscription = fromSubscription;
            return this;
        }

        public Builder setInvoiceSettings(InvoiceSettings invoiceSettings) {
            this.invoiceSettings = invoiceSettings;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder addPhase(Phase element) {
            if (this.phases == null) {
                this.phases = new ArrayList<Phase>();
            }
            this.phases.add(element);
            return this;
        }

        public Builder addAllPhase(List<Phase> elements) {
            if (this.phases == null) {
                this.phases = new ArrayList<Phase>();
            }
            this.phases.addAll(elements);
            return this;
        }

        public Builder setRenewalBehavior(RenewalBehavior renewalBehavior) {
            this.renewalBehavior = renewalBehavior;
            return this;
        }

        public Builder setRenewalInterval(RenewalInterval renewalInterval) {
            this.renewalInterval = renewalInterval;
            return this;
        }

        public Builder setStartDate(StartDate startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder setStartDate(Long startDate) {
            this.startDate = startDate;
            return this;
        }
    }
}

