// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;

public class SubscriptionItemDeleteParams extends ApiRequestParams {
  /**
   * Delete all usage for the given subscription item. Allowed only when the current plan's
   * `usage_type` is `metered`.
   */
  @SerializedName("clear_usage")
  Boolean clearUsage;

  /**
   * Flag indicating whether to [prorate](https://stripe.com/docs/billing/subscriptions/prorations)
   * switching plans during a billing cycle.
   */
  @SerializedName("prorate")
  Boolean prorate;

  /**
   * If set, the proration will be calculated as though the subscription was updated at the given
   * time. This can be used to apply the same proration that was previewed with the [upcoming
   * invoice](#retrieve_customer_invoice) endpoint.
   */
  @SerializedName("proration_date")
  Long prorationDate;

  private SubscriptionItemDeleteParams(Boolean clearUsage, Boolean prorate, Long prorationDate) {
    this.clearUsage = clearUsage;
    this.prorate = prorate;
    this.prorationDate = prorationDate;
  }

  public static Builder builder() {
    return new com.stripe.param.SubscriptionItemDeleteParams.Builder();
  }

  public static class Builder {
    private Boolean clearUsage;

    private Boolean prorate;

    private Long prorationDate;

    /** Finalize and obtain parameter instance from this builder. */
    public SubscriptionItemDeleteParams build() {
      return new SubscriptionItemDeleteParams(this.clearUsage, this.prorate, this.prorationDate);
    }

    /**
     * Delete all usage for the given subscription item. Allowed only when the current plan's
     * `usage_type` is `metered`.
     */
    public Builder setClearUsage(Boolean clearUsage) {
      this.clearUsage = clearUsage;
      return this;
    }

    /**
     * Flag indicating whether to
     * [prorate](https://stripe.com/docs/billing/subscriptions/prorations) switching plans during a
     * billing cycle.
     */
    public Builder setProrate(Boolean prorate) {
      this.prorate = prorate;
      return this;
    }

    /**
     * If set, the proration will be calculated as though the subscription was updated at the given
     * time. This can be used to apply the same proration that was previewed with the [upcoming
     * invoice](#retrieve_customer_invoice) endpoint.
     */
    public Builder setProrationDate(Long prorationDate) {
      this.prorationDate = prorationDate;
      return this;
    }
  }
}
