/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class OrderCreateParams
extends ApiRequestParams {
    @SerializedName(value="coupon")
    String coupon;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="items")
    List<Item> items;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="shipping")
    Shipping shipping;

    private OrderCreateParams(String coupon, String currency, String customer, String email, List<String> expand, List<Item> items, Map<String, String> metadata, Shipping shipping) {
        this.coupon = coupon;
        this.currency = currency;
        this.customer = customer;
        this.email = email;
        this.expand = expand;
        this.items = items;
        this.metadata = metadata;
        this.shipping = shipping;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Shipping {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        private Shipping(Address address, String name, String phone) {
            this.address = address;
            this.name = name;
            this.phone = phone;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private String name;
            private String phone;

            public Shipping build() {
                return new Shipping(this.address, this.name, this.phone);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }
        }
    }

    public static class Item {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="parent")
        String parent;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="type")
        Type type;

        private Item(Long amount, String currency, String description, String parent, Long quantity, Type type) {
            this.amount = amount;
            this.currency = currency;
            this.description = description;
            this.parent = parent;
            this.quantity = quantity;
            this.type = type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            DISCOUNT("discount"),
            SHIPPING("shipping"),
            SKU("sku"),
            TAX("tax");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Long amount;
            private String currency;
            private String description;
            private String parent;
            private Long quantity;
            private Type type;

            public Item build() {
                return new Item(this.amount, this.currency, this.description, this.parent, this.quantity, this.type);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder setCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setParent(String parent) {
                this.parent = parent;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }
        }
    }

    public static class Builder {
        private String coupon;
        private String currency;
        private String customer;
        private String email;
        private List<String> expand;
        private List<Item> items;
        private Map<String, String> metadata;
        private Shipping shipping;

        public OrderCreateParams build() {
            return new OrderCreateParams(this.coupon, this.currency, this.customer, this.email, this.expand, this.items, this.metadata, this.shipping);
        }

        public Builder setCoupon(String coupon) {
            this.coupon = coupon;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder addItem(Item element) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.add(element);
            return this;
        }

        public Builder addAllItem(List<Item> elements) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.addAll(elements);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setShipping(Shipping shipping) {
            this.shipping = shipping;
            return this;
        }
    }
}

