/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class LocationCreateParams
extends ApiRequestParams {
    @SerializedName(value="address")
    Address address;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="operator_account")
    String operatorAccount;

    private LocationCreateParams(Address address, String displayName, List<String> expand, String operatorAccount) {
        this.address = address;
        this.displayName = displayName;
        this.expand = expand;
        this.operatorAccount = operatorAccount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Address {
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="line1")
        String line1;
        @SerializedName(value="line2")
        String line2;
        @SerializedName(value="postal_code")
        String postalCode;
        @SerializedName(value="state")
        String state;

        private Address(String city, String country, String line1, String line2, String postalCode, String state) {
            this.city = city;
            this.country = country;
            this.line1 = line1;
            this.line2 = line2;
            this.postalCode = postalCode;
            this.state = state;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String city;
            private String country;
            private String line1;
            private String line2;
            private String postalCode;
            private String state;

            public Address build() {
                return new Address(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
            }

            public Builder setCity(String city) {
                this.city = city;
                return this;
            }

            public Builder setCountry(String country) {
                this.country = country;
                return this;
            }

            public Builder setLine1(String line1) {
                this.line1 = line1;
                return this;
            }

            public Builder setLine2(String line2) {
                this.line2 = line2;
                return this;
            }

            public Builder setPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            public Builder setState(String state) {
                this.state = state;
                return this;
            }
        }
    }

    public static class Builder {
        private Address address;
        private String displayName;
        private List<String> expand;
        private String operatorAccount;

        public LocationCreateParams build() {
            return new LocationCreateParams(this.address, this.displayName, this.expand, this.operatorAccount);
        }

        public Builder setAddress(Address address) {
            this.address = address;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setOperatorAccount(String operatorAccount) {
            this.operatorAccount = operatorAccount;
            return this;
        }
    }
}

