// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class LocationUpdateParams extends ApiRequestParams {
  /** The full address of the location. */
  @SerializedName("address")
  Address address;

  /** A name for the location. */
  @SerializedName("display_name")
  String displayName;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /**
   * To group objects on your platform account by connected account, set this parameter to the
   * connected account operating your application.
   */
  @SerializedName("operator_account")
  String operatorAccount;

  private LocationUpdateParams(
      Address address, String displayName, List<String> expand, String operatorAccount) {
    this.address = address;
    this.displayName = displayName;
    this.expand = expand;
    this.operatorAccount = operatorAccount;
  }

  public static Builder builder() {
    return new com.stripe.param.terminal.LocationUpdateParams.Builder();
  }

  public static class Builder {
    private Address address;

    private String displayName;

    private List<String> expand;

    private String operatorAccount;

    /** Finalize and obtain parameter instance from this builder. */
    public LocationUpdateParams build() {
      return new LocationUpdateParams(
          this.address, this.displayName, this.expand, this.operatorAccount);
    }

    /** The full address of the location. */
    public Builder setAddress(Address address) {
      this.address = address;
      return this;
    }

    /** A name for the location. */
    public Builder setDisplayName(String displayName) {
      this.displayName = displayName;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * LocationUpdateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * LocationUpdateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * To group objects on your platform account by connected account, set this parameter to the
     * connected account operating your application.
     */
    public Builder setOperatorAccount(String operatorAccount) {
      this.operatorAccount = operatorAccount;
      return this;
    }
  }

  public static class Address {
    @SerializedName("city")
    String city;

    @SerializedName("country")
    String country;

    @SerializedName("line1")
    String line1;

    @SerializedName("line2")
    String line2;

    @SerializedName("postal_code")
    String postalCode;

    @SerializedName("state")
    String state;

    private Address(
        String city, String country, String line1, String line2, String postalCode, String state) {
      this.city = city;
      this.country = country;
      this.line1 = line1;
      this.line2 = line2;
      this.postalCode = postalCode;
      this.state = state;
    }

    public static Builder builder() {
      return new com.stripe.param.terminal.LocationUpdateParams.Address.Builder();
    }

    public static class Builder {
      private String city;

      private String country;

      private String line1;

      private String line2;

      private String postalCode;

      private String state;

      /** Finalize and obtain parameter instance from this builder. */
      public Address build() {
        return new Address(
            this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
      }

      public Builder setCity(String city) {
        this.city = city;
        return this;
      }

      public Builder setCountry(String country) {
        this.country = country;
        return this;
      }

      public Builder setLine1(String line1) {
        this.line1 = line1;
        return this;
      }

      public Builder setLine2(String line2) {
        this.line2 = line2;
        return this;
      }

      public Builder setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
      }

      public Builder setState(String state) {
        this.state = state;
        return this;
      }
    }
  }
}
