// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class BitcoinReceiverListParams extends ApiRequestParams {
  /** Filter for active receivers. */
  @SerializedName("active")
  Boolean active;

  /**
   * A cursor for use in pagination. `ending_before` is an object ID that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, starting with
   * `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the
   * previous page of the list.
   */
  @SerializedName("ending_before")
  String endingBefore;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /** Filter for filled receivers. */
  @SerializedName("filled")
  Boolean filled;

  /**
   * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
   * default is 10.
   */
  @SerializedName("limit")
  Long limit;

  /**
   * A cursor for use in pagination. `starting_after` is an object ID that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, ending with `obj_foo`,
   * your subsequent call can include `starting_after=obj_foo` in order to fetch the next page of
   * the list.
   */
  @SerializedName("starting_after")
  String startingAfter;

  /** Filter for receivers with uncaptured funds. */
  @SerializedName("uncaptured_funds")
  Boolean uncapturedFunds;

  private BitcoinReceiverListParams(
      Boolean active,
      String endingBefore,
      List<String> expand,
      Boolean filled,
      Long limit,
      String startingAfter,
      Boolean uncapturedFunds) {
    this.active = active;
    this.endingBefore = endingBefore;
    this.expand = expand;
    this.filled = filled;
    this.limit = limit;
    this.startingAfter = startingAfter;
    this.uncapturedFunds = uncapturedFunds;
  }

  public static Builder builder() {
    return new com.stripe.param.BitcoinReceiverListParams.Builder();
  }

  public static class Builder {
    private Boolean active;

    private String endingBefore;

    private List<String> expand;

    private Boolean filled;

    private Long limit;

    private String startingAfter;

    private Boolean uncapturedFunds;

    /** Finalize and obtain parameter instance from this builder. */
    public BitcoinReceiverListParams build() {
      return new BitcoinReceiverListParams(
          this.active,
          this.endingBefore,
          this.expand,
          this.filled,
          this.limit,
          this.startingAfter,
          this.uncapturedFunds);
    }

    /** Filter for active receivers. */
    public Builder setActive(Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * A cursor for use in pagination. `ending_before` is an object ID that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, starting with
     * `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the
     * previous page of the list.
     */
    public Builder setEndingBefore(String endingBefore) {
      this.endingBefore = endingBefore;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * BitcoinReceiverListParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * BitcoinReceiverListParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /** Filter for filled receivers. */
    public Builder setFilled(Boolean filled) {
      this.filled = filled;
      return this;
    }

    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
     * default is 10.
     */
    public Builder setLimit(Long limit) {
      this.limit = limit;
      return this;
    }

    /**
     * A cursor for use in pagination. `starting_after` is an object ID that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, ending with
     * `obj_foo`, your subsequent call can include `starting_after=obj_foo` in order to fetch the
     * next page of the list.
     */
    public Builder setStartingAfter(String startingAfter) {
      this.startingAfter = startingAfter;
      return this;
    }

    /** Filter for receivers with uncaptured funds. */
    public Builder setUncapturedFunds(Boolean uncapturedFunds) {
      this.uncapturedFunds = uncapturedFunds;
      return this;
    }
  }
}
