/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceUpdateParams
extends ApiRequestParams {
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="auto_advance")
    Boolean autoAdvance;
    @SerializedName(value="custom_fields")
    Object customFields;
    @SerializedName(value="days_until_due")
    Long daysUntilDue;
    @SerializedName(value="default_payment_method")
    String defaultPaymentMethod;
    @SerializedName(value="default_source")
    String defaultSource;
    @SerializedName(value="default_tax_rates")
    Object defaultTaxRates;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="due_date")
    Long dueDate;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="footer")
    String footer;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="tax_percent")
    Object taxPercent;
    @SerializedName(value="transfer_data")
    Object transferData;

    private InvoiceUpdateParams(Long applicationFeeAmount, Boolean autoAdvance, Object customFields, Long daysUntilDue, String defaultPaymentMethod, String defaultSource, Object defaultTaxRates, String description, Long dueDate, List<String> expand, String footer, Map<String, String> metadata, String statementDescriptor, Object taxPercent, Object transferData) {
        this.applicationFeeAmount = applicationFeeAmount;
        this.autoAdvance = autoAdvance;
        this.customFields = customFields;
        this.daysUntilDue = daysUntilDue;
        this.defaultPaymentMethod = defaultPaymentMethod;
        this.defaultSource = defaultSource;
        this.defaultTaxRates = defaultTaxRates;
        this.description = description;
        this.dueDate = dueDate;
        this.expand = expand;
        this.footer = footer;
        this.metadata = metadata;
        this.statementDescriptor = statementDescriptor;
        this.taxPercent = taxPercent;
        this.transferData = transferData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class TransferData {
        @SerializedName(value="destination")
        String destination;

        private TransferData(String destination) {
            this.destination = destination;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String destination;

            public TransferData build() {
                return new TransferData(this.destination);
            }

            public Builder setDestination(String destination) {
                this.destination = destination;
                return this;
            }
        }
    }

    public static class CustomField {
        @SerializedName(value="name")
        String name;
        @SerializedName(value="value")
        String value;

        private CustomField(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String name;
            private String value;

            public CustomField build() {
                return new CustomField(this.name, this.value);
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setValue(String value) {
                this.value = value;
                return this;
            }
        }
    }

    public static class Builder {
        private Long applicationFeeAmount;
        private Boolean autoAdvance;
        private Object customFields;
        private Long daysUntilDue;
        private String defaultPaymentMethod;
        private String defaultSource;
        private Object defaultTaxRates;
        private String description;
        private Long dueDate;
        private List<String> expand;
        private String footer;
        private Map<String, String> metadata;
        private String statementDescriptor;
        private Object taxPercent;
        private Object transferData;

        public InvoiceUpdateParams build() {
            return new InvoiceUpdateParams(this.applicationFeeAmount, this.autoAdvance, this.customFields, this.daysUntilDue, this.defaultPaymentMethod, this.defaultSource, this.defaultTaxRates, this.description, this.dueDate, this.expand, this.footer, this.metadata, this.statementDescriptor, this.taxPercent, this.transferData);
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setAutoAdvance(Boolean autoAdvance) {
            this.autoAdvance = autoAdvance;
            return this;
        }

        public Builder setCustomFields(EmptyParam customFields) {
            this.customFields = customFields;
            return this;
        }

        public Builder setCustomFields(List<CustomField> customFields) {
            this.customFields = customFields;
            return this;
        }

        public Builder setDaysUntilDue(Long daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
            return this;
        }

        public Builder setDefaultPaymentMethod(String defaultPaymentMethod) {
            this.defaultPaymentMethod = defaultPaymentMethod;
            return this;
        }

        public Builder setDefaultSource(String defaultSource) {
            this.defaultSource = defaultSource;
            return this;
        }

        public Builder setDefaultTaxRates(EmptyParam defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
            return this;
        }

        public Builder setDefaultTaxRates(List<String> defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDueDate(Long dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setFooter(String footer) {
            this.footer = footer;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setTaxPercent(EmptyParam taxPercent) {
            this.taxPercent = taxPercent;
            return this;
        }

        public Builder setTaxPercent(BigDecimal taxPercent) {
            this.taxPercent = taxPercent;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public Builder setTransferData(EmptyParam transferData) {
            this.transferData = transferData;
            return this;
        }
    }
}

