/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SubscriptionCreateParams
extends ApiRequestParams {
    @SerializedName(value="application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName(value="backdate_start_date")
    Long backdateStartDate;
    @SerializedName(value="billing")
    Billing billing;
    @SerializedName(value="billing_cycle_anchor")
    Long billingCycleAnchor;
    @SerializedName(value="billing_thresholds")
    Object billingThresholds;
    @SerializedName(value="cancel_at")
    Long cancelAt;
    @SerializedName(value="cancel_at_period_end")
    Boolean cancelAtPeriodEnd;
    @SerializedName(value="coupon")
    String coupon;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="days_until_due")
    Long daysUntilDue;
    @SerializedName(value="default_payment_method")
    String defaultPaymentMethod;
    @SerializedName(value="default_source")
    String defaultSource;
    @SerializedName(value="default_tax_rates")
    Object defaultTaxRates;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="items")
    List<Item> items;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="prorate")
    Boolean prorate;
    @SerializedName(value="tax_percent")
    Object taxPercent;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="trial_end")
    Object trialEnd;
    @SerializedName(value="trial_from_plan")
    Boolean trialFromPlan;
    @SerializedName(value="trial_period_days")
    Long trialPeriodDays;

    private SubscriptionCreateParams(BigDecimal applicationFeePercent, Long backdateStartDate, Billing billing, Long billingCycleAnchor, Object billingThresholds, Long cancelAt, Boolean cancelAtPeriodEnd, String coupon, String customer, Long daysUntilDue, String defaultPaymentMethod, String defaultSource, Object defaultTaxRates, List<String> expand, List<Item> items, Map<String, String> metadata, Boolean prorate, Object taxPercent, TransferData transferData, Object trialEnd, Boolean trialFromPlan, Long trialPeriodDays) {
        this.applicationFeePercent = applicationFeePercent;
        this.backdateStartDate = backdateStartDate;
        this.billing = billing;
        this.billingCycleAnchor = billingCycleAnchor;
        this.billingThresholds = billingThresholds;
        this.cancelAt = cancelAt;
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
        this.coupon = coupon;
        this.customer = customer;
        this.daysUntilDue = daysUntilDue;
        this.defaultPaymentMethod = defaultPaymentMethod;
        this.defaultSource = defaultSource;
        this.defaultTaxRates = defaultTaxRates;
        this.expand = expand;
        this.items = items;
        this.metadata = metadata;
        this.prorate = prorate;
        this.taxPercent = taxPercent;
        this.transferData = transferData;
        this.trialEnd = trialEnd;
        this.trialFromPlan = trialFromPlan;
        this.trialPeriodDays = trialPeriodDays;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum TrialEnd implements ApiRequestParams.EnumParam
    {
        NOW("now");

        private final String value;

        private TrialEnd(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Billing implements ApiRequestParams.EnumParam
    {
        CHARGE_AUTOMATICALLY("charge_automatically"),
        SEND_INVOICE("send_invoice");

        private final String value;

        private Billing(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class TransferData {
        @SerializedName(value="destination")
        String destination;

        private TransferData(String destination) {
            this.destination = destination;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String destination;

            public TransferData build() {
                return new TransferData(this.destination);
            }

            public Builder setDestination(String destination) {
                this.destination = destination;
                return this;
            }
        }
    }

    public static class Item {
        @SerializedName(value="billing_thresholds")
        Object billingThresholds;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="plan")
        String plan;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        Object taxRates;

        private Item(Object billingThresholds, Map<String, String> metadata, String plan, Long quantity, Object taxRates) {
            this.billingThresholds = billingThresholds;
            this.metadata = metadata;
            this.plan = plan;
            this.quantity = quantity;
            this.taxRates = taxRates;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class BillingThresholds {
            @SerializedName(value="usage_gte")
            Long usageGte;

            private BillingThresholds(Long usageGte) {
                this.usageGte = usageGte;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private Long usageGte;

                public BillingThresholds build() {
                    return new BillingThresholds(this.usageGte);
                }

                public Builder setUsageGte(Long usageGte) {
                    this.usageGte = usageGte;
                    return this;
                }
            }
        }

        public static class Builder {
            private Object billingThresholds;
            private Map<String, String> metadata;
            private String plan;
            private Long quantity;
            private Object taxRates;

            public Item build() {
                return new Item(this.billingThresholds, this.metadata, this.plan, this.quantity, this.taxRates);
            }

            public Builder setBillingThresholds(BillingThresholds billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder setBillingThresholds(EmptyParam billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setPlan(String plan) {
                this.plan = plan;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder setTaxRates(EmptyParam taxRates) {
                this.taxRates = taxRates;
                return this;
            }

            public Builder setTaxRates(List<String> taxRates) {
                this.taxRates = taxRates;
                return this;
            }
        }
    }

    public static class BillingThresholds {
        @SerializedName(value="amount_gte")
        Long amountGte;
        @SerializedName(value="reset_billing_cycle_anchor")
        Boolean resetBillingCycleAnchor;

        private BillingThresholds(Long amountGte, Boolean resetBillingCycleAnchor) {
            this.amountGte = amountGte;
            this.resetBillingCycleAnchor = resetBillingCycleAnchor;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Long amountGte;
            private Boolean resetBillingCycleAnchor;

            public BillingThresholds build() {
                return new BillingThresholds(this.amountGte, this.resetBillingCycleAnchor);
            }

            public Builder setAmountGte(Long amountGte) {
                this.amountGte = amountGte;
                return this;
            }

            public Builder setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
                this.resetBillingCycleAnchor = resetBillingCycleAnchor;
                return this;
            }
        }
    }

    public static class Builder {
        private BigDecimal applicationFeePercent;
        private Long backdateStartDate;
        private Billing billing;
        private Long billingCycleAnchor;
        private Object billingThresholds;
        private Long cancelAt;
        private Boolean cancelAtPeriodEnd;
        private String coupon;
        private String customer;
        private Long daysUntilDue;
        private String defaultPaymentMethod;
        private String defaultSource;
        private Object defaultTaxRates;
        private List<String> expand;
        private List<Item> items;
        private Map<String, String> metadata;
        private Boolean prorate;
        private Object taxPercent;
        private TransferData transferData;
        private Object trialEnd;
        private Boolean trialFromPlan;
        private Long trialPeriodDays;

        public SubscriptionCreateParams build() {
            return new SubscriptionCreateParams(this.applicationFeePercent, this.backdateStartDate, this.billing, this.billingCycleAnchor, this.billingThresholds, this.cancelAt, this.cancelAtPeriodEnd, this.coupon, this.customer, this.daysUntilDue, this.defaultPaymentMethod, this.defaultSource, this.defaultTaxRates, this.expand, this.items, this.metadata, this.prorate, this.taxPercent, this.transferData, this.trialEnd, this.trialFromPlan, this.trialPeriodDays);
        }

        public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
            this.applicationFeePercent = applicationFeePercent;
            return this;
        }

        public Builder setBackdateStartDate(Long backdateStartDate) {
            this.backdateStartDate = backdateStartDate;
            return this;
        }

        public Builder setBilling(Billing billing) {
            this.billing = billing;
            return this;
        }

        public Builder setBillingCycleAnchor(Long billingCycleAnchor) {
            this.billingCycleAnchor = billingCycleAnchor;
            return this;
        }

        public Builder setBillingThresholds(BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
            return this;
        }

        public Builder setBillingThresholds(EmptyParam billingThresholds) {
            this.billingThresholds = billingThresholds;
            return this;
        }

        public Builder setCancelAt(Long cancelAt) {
            this.cancelAt = cancelAt;
            return this;
        }

        public Builder setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
            this.cancelAtPeriodEnd = cancelAtPeriodEnd;
            return this;
        }

        public Builder setCoupon(String coupon) {
            this.coupon = coupon;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDaysUntilDue(Long daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
            return this;
        }

        public Builder setDefaultPaymentMethod(String defaultPaymentMethod) {
            this.defaultPaymentMethod = defaultPaymentMethod;
            return this;
        }

        public Builder setDefaultSource(String defaultSource) {
            this.defaultSource = defaultSource;
            return this;
        }

        public Builder setDefaultTaxRates(EmptyParam defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
            return this;
        }

        public Builder setDefaultTaxRates(List<String> defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder addItem(Item element) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.add(element);
            return this;
        }

        public Builder addAllItem(List<Item> elements) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.addAll(elements);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setProrate(Boolean prorate) {
            this.prorate = prorate;
            return this;
        }

        public Builder setTaxPercent(EmptyParam taxPercent) {
            this.taxPercent = taxPercent;
            return this;
        }

        public Builder setTaxPercent(BigDecimal taxPercent) {
            this.taxPercent = taxPercent;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public Builder setTrialEnd(TrialEnd trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        public Builder setTrialEnd(Long trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        public Builder setTrialFromPlan(Boolean trialFromPlan) {
            this.trialFromPlan = trialFromPlan;
            return this;
        }

        public Builder setTrialPeriodDays(Long trialPeriodDays) {
            this.trialPeriodDays = trialPeriodDays;
            return this;
        }
    }
}

