/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaxRateUpdateParams
extends ApiRequestParams {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="jurisdiction")
    String jurisdiction;
    @SerializedName(value="metadata")
    Map<String, String> metadata;

    private TaxRateUpdateParams(Boolean active, String description, String displayName, List<String> expand, String jurisdiction, Map<String, String> metadata) {
        this.active = active;
        this.description = description;
        this.displayName = displayName;
        this.expand = expand;
        this.jurisdiction = jurisdiction;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean active;
        private String description;
        private String displayName;
        private List<String> expand;
        private String jurisdiction;
        private Map<String, String> metadata;

        public TaxRateUpdateParams build() {
            return new TaxRateUpdateParams(this.active, this.description, this.displayName, this.expand, this.jurisdiction, this.metadata);
        }

        public Builder setActive(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setJurisdiction(String jurisdiction) {
            this.jurisdiction = jurisdiction;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }
    }
}

