// Generated by delombok at Mon Apr 29 18:43:11 PDT 2019
// Generated by com.stripe.generator.entity.SdkBuilder
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.CardholderCreateParams;
import com.stripe.param.issuing.CardholderListParams;
import com.stripe.param.issuing.CardholderRetrieveParams;
import com.stripe.param.issuing.CardholderUpdateParams;
import java.util.List;
import java.util.Map;

public class Cardholder extends ApiResource implements HasId, MetadataStore<Cardholder> {
  @SerializedName("authorization_controls")
  AuthorizationControls authorizationControls;
  @SerializedName("billing")
  Billing billing;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * The cardholder's email address.
   */
  @SerializedName("email")
  String email;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Whether or not this cardholder is the default cardholder.
   */
  @SerializedName("is_default")
  Boolean isDefault;
  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * The cardholder's name. This will be printed on cards issued to them.
   */
  @SerializedName("name")
  String name;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * The cardholder's phone number.
   */
  @SerializedName("phone_number")
  String phoneNumber;
  /**
   * One of `active`, `inactive`, `blocked`, or `pending`.
   */
  @SerializedName("status")
  String status;
  /**
   * One of `individual` or `business_entity`.
   */
  @SerializedName("type")
  String type;

  /**
   * Returns a list of Issuing <code>Cardholder</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static CardholderCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Cardholder</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static CardholderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
    return requestCollection(url, params, CardholderCollection.class, options);
  }

  /**
   * Returns a list of Issuing <code>Cardholder</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static CardholderCollection list(CardholderListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Cardholder</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static CardholderCollection list(CardholderListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
    return requestCollection(url, params, CardholderCollection.class, options);
  }

  /**
   * Creates a new Issuing <code>Cardholder</code> object that can be issued cards.
   */
  public static Cardholder create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new Issuing <code>Cardholder</code> object that can be issued cards.
   */
  public static Cardholder create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
    return request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
  }

  /**
   * Creates a new Issuing <code>Cardholder</code> object that can be issued cards.
   */
  public static Cardholder create(CardholderCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new Issuing <code>Cardholder</code> object that can be issued cards.
   */
  public static Cardholder create(CardholderCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cardholders");
    return request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
  }

  /**
   * Retrieves an Issuing <code>Cardholder</code> object.
   */
  public static Cardholder retrieve(String cardholder) throws StripeException {
    return retrieve(cardholder, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves an Issuing <code>Cardholder</code> object.
   */
  public static Cardholder retrieve(String cardholder, RequestOptions options) throws StripeException {
    return retrieve(cardholder, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves an Issuing <code>Cardholder</code> object.
   */
  public static Cardholder retrieve(String cardholder, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(cardholder)));
    return request(ApiResource.RequestMethod.GET, url, params, Cardholder.class, options);
  }

  /**
   * Retrieves an Issuing <code>Cardholder</code> object.
   */
  public static Cardholder retrieve(String cardholder, CardholderRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(cardholder)));
    return request(ApiResource.RequestMethod.GET, url, params, Cardholder.class, options);
  }

  /**
   * Updates the specified Issuing <code>Cardholder</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  @Override
  public Cardholder update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Cardholder</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  @Override
  public Cardholder update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
  }

  /**
   * Updates the specified Issuing <code>Cardholder</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  public Cardholder update(CardholderUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Cardholder</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged.
   */
  public Cardholder update(CardholderUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(this.getId())));
    return request(ApiResource.RequestMethod.POST, url, params, Cardholder.class, options);
  }


  public static class AuthorizationControls extends StripeObject {
    /**
     * Array of strings containing
     * [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category)
     * of authorizations permitted on this card.
     */
    @SerializedName("allowed_categories")
    List<String> allowedCategories;
    /**
     * Array of strings containing
     * [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category)
     * of authorizations to always decline on this card.
     */
    @SerializedName("blocked_categories")
    List<String> blockedCategories;
    /**
     * Limit the spending with rules based on time intervals and categories.
     */
    @SerializedName("spending_limits")
    List<SpendingLimit> spendingLimits;

    /**
     * Array of strings containing
     * [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category)
     * of authorizations permitted on this card.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAllowedCategories() {
      return this.allowedCategories;
    }

    /**
     * Array of strings containing
     * [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category)
     * of authorizations to always decline on this card.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getBlockedCategories() {
      return this.blockedCategories;
    }

    /**
     * Limit the spending with rules based on time intervals and categories.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SpendingLimit> getSpendingLimits() {
      return this.spendingLimits;
    }

    /**
     * Array of strings containing
     * [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category)
     * of authorizations permitted on this card.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAllowedCategories(final List<String> allowedCategories) {
      this.allowedCategories = allowedCategories;
    }

    /**
     * Array of strings containing
     * [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category)
     * of authorizations to always decline on this card.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBlockedCategories(final List<String> blockedCategories) {
      this.blockedCategories = blockedCategories;
    }

    /**
     * Limit the spending with rules based on time intervals and categories.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSpendingLimits(final List<SpendingLimit> spendingLimits) {
      this.spendingLimits = spendingLimits;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Cardholder.AuthorizationControls)) return false;
      final Cardholder.AuthorizationControls other = (Cardholder.AuthorizationControls) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$allowedCategories = this.getAllowedCategories();
      final java.lang.Object other$allowedCategories = other.getAllowedCategories();
      if (this$allowedCategories == null ? other$allowedCategories != null : !this$allowedCategories.equals(other$allowedCategories)) return false;
      final java.lang.Object this$blockedCategories = this.getBlockedCategories();
      final java.lang.Object other$blockedCategories = other.getBlockedCategories();
      if (this$blockedCategories == null ? other$blockedCategories != null : !this$blockedCategories.equals(other$blockedCategories)) return false;
      final java.lang.Object this$spendingLimits = this.getSpendingLimits();
      final java.lang.Object other$spendingLimits = other.getSpendingLimits();
      if (this$spendingLimits == null ? other$spendingLimits != null : !this$spendingLimits.equals(other$spendingLimits)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Cardholder.AuthorizationControls;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $allowedCategories = this.getAllowedCategories();
      result = result * PRIME + ($allowedCategories == null ? 43 : $allowedCategories.hashCode());
      final java.lang.Object $blockedCategories = this.getBlockedCategories();
      result = result * PRIME + ($blockedCategories == null ? 43 : $blockedCategories.hashCode());
      final java.lang.Object $spendingLimits = this.getSpendingLimits();
      result = result * PRIME + ($spendingLimits == null ? 43 : $spendingLimits.hashCode());
      return result;
    }
  }


  public static class Billing extends StripeObject {
    @SerializedName("address")
    Address address;
    @SerializedName("name")
    String name;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Cardholder.Billing)) return false;
      final Cardholder.Billing other = (Cardholder.Billing) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Cardholder.Billing;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      return result;
    }
  }


  public static class SpendingLimit extends StripeObject {
    /** Maximum amount allowed to spend per time interval. */
    @SerializedName("amount")
    Long amount;
    /**
     * Array of strings containing
     * [categories](https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category)
     * on which to apply the spending limit. Leave this blank to limit all charges.
     */
    @SerializedName("categories")
    List<String> categories;
    /**
     * The time interval with which to apply this spending limit towards. Allowed values are
     * `per_authorization`, `daily`, `weekly`, `monthly`, `yearly`, or `all_time`.
     */
    @SerializedName("interval")
    String interval;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCategories() {
      return this.categories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getInterval() {
      return this.interval;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCategories(final List<String> categories) {
      this.categories = categories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInterval(final String interval) {
      this.interval = interval;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Cardholder.SpendingLimit)) return false;
      final Cardholder.SpendingLimit other = (Cardholder.SpendingLimit) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$categories = this.getCategories();
      final java.lang.Object other$categories = other.getCategories();
      if (this$categories == null ? other$categories != null : !this$categories.equals(other$categories)) return false;
      final java.lang.Object this$interval = this.getInterval();
      final java.lang.Object other$interval = other.getInterval();
      if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Cardholder.SpendingLimit;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $categories = this.getCategories();
      result = result * PRIME + ($categories == null ? 43 : $categories.hashCode());
      final java.lang.Object $interval = this.getInterval();
      result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AuthorizationControls getAuthorizationControls() {
    return this.authorizationControls;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Billing getBilling() {
    return this.billing;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * The cardholder's email address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  /**
   * Whether or not this cardholder is the default cardholder.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getIsDefault() {
    return this.isDefault;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The cardholder's name. This will be printed on cards issued to them.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The cardholder's phone number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPhoneNumber() {
    return this.phoneNumber;
  }

  /**
   * One of `active`, `inactive`, `blocked`, or `pending`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * One of `individual` or `business_entity`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAuthorizationControls(final AuthorizationControls authorizationControls) {
    this.authorizationControls = authorizationControls;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBilling(final Billing billing) {
    this.billing = billing;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * The cardholder's email address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Whether or not this cardholder is the default cardholder.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIsDefault(final Boolean isDefault) {
    this.isDefault = isDefault;
  }

  /**
   * Has the value `true` if the object exists in live mode or the value `false` if the object
   * exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * The cardholder's name. This will be printed on cards issued to them.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The cardholder's phone number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhoneNumber(final String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  /**
   * One of `active`, `inactive`, `blocked`, or `pending`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * One of `individual` or `business_entity`.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Cardholder)) return false;
    final Cardholder other = (Cardholder) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$authorizationControls = this.getAuthorizationControls();
    final java.lang.Object other$authorizationControls = other.getAuthorizationControls();
    if (this$authorizationControls == null ? other$authorizationControls != null : !this$authorizationControls.equals(other$authorizationControls)) return false;
    final java.lang.Object this$billing = this.getBilling();
    final java.lang.Object other$billing = other.getBilling();
    if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$isDefault = this.getIsDefault();
    final java.lang.Object other$isDefault = other.getIsDefault();
    if (this$isDefault == null ? other$isDefault != null : !this$isDefault.equals(other$isDefault)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$phoneNumber = this.getPhoneNumber();
    final java.lang.Object other$phoneNumber = other.getPhoneNumber();
    if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Cardholder;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $authorizationControls = this.getAuthorizationControls();
    result = result * PRIME + ($authorizationControls == null ? 43 : $authorizationControls.hashCode());
    final java.lang.Object $billing = this.getBilling();
    result = result * PRIME + ($billing == null ? 43 : $billing.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $isDefault = this.getIsDefault();
    result = result * PRIME + ($isDefault == null ? 43 : $isDefault.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $phoneNumber = this.getPhoneNumber();
    result = result * PRIME + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of key-value pairs that you can attach to an object. This can be useful for storing
   * additional information about the object in a structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
