// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class BalanceTransactionListParams extends ApiRequestParams {
  @SerializedName("available_on")
  Object availableOn;

  @SerializedName("created")
  Object created;

  @SerializedName("currency")
  String currency;

  /**
   * A cursor for use in pagination. `ending_before` is an object ID that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, starting with
   * `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the
   * previous page of the list.
   */
  @SerializedName("ending_before")
  String endingBefore;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /**
   * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
   * default is 10.
   */
  @SerializedName("limit")
  Long limit;

  /**
   * For automatic Stripe payouts only, only returns transactions that were paid out on the
   * specified payout ID.
   */
  @SerializedName("payout")
  String payout;

  /** Only returns the original transaction. */
  @SerializedName("source")
  String source;

  /**
   * A cursor for use in pagination. `starting_after` is an object ID that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, ending with `obj_foo`,
   * your subsequent call can include `starting_after=obj_foo` in order to fetch the next page of
   * the list.
   */
  @SerializedName("starting_after")
  String startingAfter;

  /**
   * Only returns transactions of the given type. One of: `charge`, `refund`, `adjustment`,
   * `application_fee`, `application_fee_refund`, `transfer`, `payment`, `payout`, `payout_failure`,
   * `stripe_fee`, or `network_cost`.
   */
  @SerializedName("type")
  String type;

  private BalanceTransactionListParams(
      Object availableOn,
      Object created,
      String currency,
      String endingBefore,
      List<String> expand,
      Long limit,
      String payout,
      String source,
      String startingAfter,
      String type) {
    this.availableOn = availableOn;
    this.created = created;
    this.currency = currency;
    this.endingBefore = endingBefore;
    this.expand = expand;
    this.limit = limit;
    this.payout = payout;
    this.source = source;
    this.startingAfter = startingAfter;
    this.type = type;
  }

  public static Builder builder() {
    return new com.stripe.param.BalanceTransactionListParams.Builder();
  }

  public static class Builder {
    private Object availableOn;

    private Object created;

    private String currency;

    private String endingBefore;

    private List<String> expand;

    private Long limit;

    private String payout;

    private String source;

    private String startingAfter;

    private String type;

    /** Finalize and obtain parameter instance from this builder. */
    public BalanceTransactionListParams build() {
      return new BalanceTransactionListParams(
          this.availableOn,
          this.created,
          this.currency,
          this.endingBefore,
          this.expand,
          this.limit,
          this.payout,
          this.source,
          this.startingAfter,
          this.type);
    }

    public Builder setAvailableOn(AvailableOn availableOn) {
      this.availableOn = availableOn;
      return this;
    }

    public Builder setAvailableOn(Long availableOn) {
      this.availableOn = availableOn;
      return this;
    }

    public Builder setCreated(Created created) {
      this.created = created;
      return this;
    }

    public Builder setCreated(Long created) {
      this.created = created;
      return this;
    }

    public Builder setCurrency(String currency) {
      this.currency = currency;
      return this;
    }

    /**
     * A cursor for use in pagination. `ending_before` is an object ID that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, starting with
     * `obj_bar`, your subsequent call can include `ending_before=obj_bar` in order to fetch the
     * previous page of the list.
     */
    public Builder setEndingBefore(String endingBefore) {
      this.endingBefore = endingBefore;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * BalanceTransactionListParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * BalanceTransactionListParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
     * default is 10.
     */
    public Builder setLimit(Long limit) {
      this.limit = limit;
      return this;
    }

    /**
     * For automatic Stripe payouts only, only returns transactions that were paid out on the
     * specified payout ID.
     */
    public Builder setPayout(String payout) {
      this.payout = payout;
      return this;
    }

    /** Only returns the original transaction. */
    public Builder setSource(String source) {
      this.source = source;
      return this;
    }

    /**
     * A cursor for use in pagination. `starting_after` is an object ID that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, ending with
     * `obj_foo`, your subsequent call can include `starting_after=obj_foo` in order to fetch the
     * next page of the list.
     */
    public Builder setStartingAfter(String startingAfter) {
      this.startingAfter = startingAfter;
      return this;
    }

    /**
     * Only returns transactions of the given type. One of: `charge`, `refund`, `adjustment`,
     * `application_fee`, `application_fee_refund`, `transfer`, `payment`, `payout`,
     * `payout_failure`, `stripe_fee`, or `network_cost`.
     */
    public Builder setType(String type) {
      this.type = type;
      return this;
    }
  }

  public static class AvailableOn {
    /** Minimum value to filter by (exclusive). */
    @SerializedName("gt")
    Long gt;

    /** Minimum value to filter by (inclusive). */
    @SerializedName("gte")
    Long gte;

    /** Maximum value to filter by (exclusive). */
    @SerializedName("lt")
    Long lt;

    /** Maximum value to filter by (inclusive). */
    @SerializedName("lte")
    Long lte;

    private AvailableOn(Long gt, Long gte, Long lt, Long lte) {
      this.gt = gt;
      this.gte = gte;
      this.lt = lt;
      this.lte = lte;
    }

    public static Builder builder() {
      return new com.stripe.param.BalanceTransactionListParams.AvailableOn.Builder();
    }

    public static class Builder {
      private Long gt;

      private Long gte;

      private Long lt;

      private Long lte;

      /** Finalize and obtain parameter instance from this builder. */
      public AvailableOn build() {
        return new AvailableOn(this.gt, this.gte, this.lt, this.lte);
      }

      /** Minimum value to filter by (exclusive). */
      public Builder setGt(Long gt) {
        this.gt = gt;
        return this;
      }

      /** Minimum value to filter by (inclusive). */
      public Builder setGte(Long gte) {
        this.gte = gte;
        return this;
      }

      /** Maximum value to filter by (exclusive). */
      public Builder setLt(Long lt) {
        this.lt = lt;
        return this;
      }

      /** Maximum value to filter by (inclusive). */
      public Builder setLte(Long lte) {
        this.lte = lte;
        return this;
      }
    }
  }

  public static class Created {
    /** Minimum value to filter by (exclusive). */
    @SerializedName("gt")
    Long gt;

    /** Minimum value to filter by (inclusive). */
    @SerializedName("gte")
    Long gte;

    /** Maximum value to filter by (exclusive). */
    @SerializedName("lt")
    Long lt;

    /** Maximum value to filter by (inclusive). */
    @SerializedName("lte")
    Long lte;

    private Created(Long gt, Long gte, Long lt, Long lte) {
      this.gt = gt;
      this.gte = gte;
      this.lt = lt;
      this.lte = lte;
    }

    public static Builder builder() {
      return new com.stripe.param.BalanceTransactionListParams.Created.Builder();
    }

    public static class Builder {
      private Long gt;

      private Long gte;

      private Long lt;

      private Long lte;

      /** Finalize and obtain parameter instance from this builder. */
      public Created build() {
        return new Created(this.gt, this.gte, this.lt, this.lte);
      }

      /** Minimum value to filter by (exclusive). */
      public Builder setGt(Long gt) {
        this.gt = gt;
        return this;
      }

      /** Minimum value to filter by (inclusive). */
      public Builder setGte(Long gte) {
        this.gte = gte;
        return this;
      }

      /** Maximum value to filter by (exclusive). */
      public Builder setLt(Long lt) {
        this.lt = lt;
        return this;
      }

      /** Maximum value to filter by (inclusive). */
      public Builder setLte(Long lte) {
        this.lte = lte;
        return this;
      }
    }
  }
}
