// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class BankAccountVerifyParams extends ApiRequestParams {
  /**
   * Two positive integers, in *cents*, equal to the values of the microdeposits sent to the bank
   * account.
   */
  @SerializedName("amounts")
  List<Long> amounts;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  private BankAccountVerifyParams(List<Long> amounts, List<String> expand) {
    this.amounts = amounts;
    this.expand = expand;
  }

  public static Builder builder() {
    return new com.stripe.param.BankAccountVerifyParams.Builder();
  }

  public static class Builder {
    private List<Long> amounts;

    private List<String> expand;

    /** Finalize and obtain parameter instance from this builder. */
    public BankAccountVerifyParams build() {
      return new BankAccountVerifyParams(this.amounts, this.expand);
    }

    /**
     * Add an element to `amounts` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * BankAccountVerifyParams#amounts} for the field documentation.
     */
    public Builder addAmount(Long element) {
      if (this.amounts == null) {
        this.amounts = new ArrayList<>();
      }
      this.amounts.add(element);
      return this;
    }

    /**
     * Add all elements to `amounts` list. A list is initialized for the first `add/addAll` call,
     * and subsequent calls adds additional elements to the original list. See {@link
     * BankAccountVerifyParams#amounts} for the field documentation.
     */
    public Builder addAllAmount(List<Long> elements) {
      if (this.amounts == null) {
        this.amounts = new ArrayList<>();
      }
      this.amounts.addAll(elements);
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * BankAccountVerifyParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * BankAccountVerifyParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }
  }
}
