// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class ExchangeRateListParams extends ApiRequestParams {
  /**
   * A cursor for use in pagination. `ending_before` is the currency that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, starting with the
   * exchange rate for currency X your subsequent call can include `ending_before=obj_bar` in order
   * to fetch the previous page of the list.
   */
  @SerializedName("ending_before")
  String endingBefore;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /**
   * A limit on the number of objects to be returned. Limit can range between 1 and total number of
   * supported payout currencies, and the default is the max.
   */
  @SerializedName("limit")
  Long limit;

  /**
   * A cursor for use in pagination. `starting_after` is the currency that defines your place in the
   * list. For instance, if you make a list request and receive 100 objects, ending with the
   * exchange rate for currency X, your subsequent call can include `starting_after=X` in order to
   * fetch the next page of the list.
   */
  @SerializedName("starting_after")
  String startingAfter;

  private ExchangeRateListParams(
      String endingBefore, List<String> expand, Long limit, String startingAfter) {
    this.endingBefore = endingBefore;
    this.expand = expand;
    this.limit = limit;
    this.startingAfter = startingAfter;
  }

  public static Builder builder() {
    return new com.stripe.param.ExchangeRateListParams.Builder();
  }

  public static class Builder {
    private String endingBefore;

    private List<String> expand;

    private Long limit;

    private String startingAfter;

    /** Finalize and obtain parameter instance from this builder. */
    public ExchangeRateListParams build() {
      return new ExchangeRateListParams(
          this.endingBefore, this.expand, this.limit, this.startingAfter);
    }

    /**
     * A cursor for use in pagination. `ending_before` is the currency that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, starting with the
     * exchange rate for currency X your subsequent call can include `ending_before=obj_bar` in
     * order to fetch the previous page of the list.
     */
    public Builder setEndingBefore(String endingBefore) {
      this.endingBefore = endingBefore;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * ExchangeRateListParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * ExchangeRateListParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and total number
     * of supported payout currencies, and the default is the max.
     */
    public Builder setLimit(Long limit) {
      this.limit = limit;
      return this;
    }

    /**
     * A cursor for use in pagination. `starting_after` is the currency that defines your place in
     * the list. For instance, if you make a list request and receive 100 objects, ending with the
     * exchange rate for currency X, your subsequent call can include `starting_after=X` in order to
     * fetch the next page of the list.
     */
    public Builder setStartingAfter(String startingAfter) {
      this.startingAfter = startingAfter;
      return this;
    }
  }
}
