// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class SubscriptionScheduleCancelParams extends ApiRequestParams {
  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /**
   * If the subscription schedule is `active`, indicates whether or not to generate a final invoice
   * that contains any un-invoiced metered usage and new/pending proration invoice items. Defaults
   * to `true`.
   */
  @SerializedName("invoice_now")
  Boolean invoiceNow;

  /**
   * If the subscription schedule is `active`, indicates if the cancellation should be prorated.
   * Defaults to `true`.
   */
  @SerializedName("prorate")
  Boolean prorate;

  private SubscriptionScheduleCancelParams(
      List<String> expand, Boolean invoiceNow, Boolean prorate) {
    this.expand = expand;
    this.invoiceNow = invoiceNow;
    this.prorate = prorate;
  }

  public static Builder builder() {
    return new com.stripe.param.SubscriptionScheduleCancelParams.Builder();
  }

  public static class Builder {
    private List<String> expand;

    private Boolean invoiceNow;

    private Boolean prorate;

    /** Finalize and obtain parameter instance from this builder. */
    public SubscriptionScheduleCancelParams build() {
      return new SubscriptionScheduleCancelParams(this.expand, this.invoiceNow, this.prorate);
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SubscriptionScheduleCancelParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SubscriptionScheduleCancelParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * If the subscription schedule is `active`, indicates whether or not to generate a final
     * invoice that contains any un-invoiced metered usage and new/pending proration invoice items.
     * Defaults to `true`.
     */
    public Builder setInvoiceNow(Boolean invoiceNow) {
      this.invoiceNow = invoiceNow;
      return this;
    }

    /**
     * If the subscription schedule is `active`, indicates if the cancellation should be prorated.
     * Defaults to `true`.
     */
    public Builder setProrate(Boolean prorate) {
      this.prorate = prorate;
      return this;
    }
  }
}
