// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class AuthorizationApproveParams extends ApiRequestParams {
  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /**
   * If the authorization's `is_held_amount_controllable` property is `true`, you may provide this
   * value to control how much to hold for the authorization. Must be positive (use
   * [`decline`](https://stripe.com/docs/api/issuing/authorizations/decline) to decline an
   * authorization request).
   */
  @SerializedName("held_amount")
  Long heldAmount;

  private AuthorizationApproveParams(List<String> expand, Long heldAmount) {
    this.expand = expand;
    this.heldAmount = heldAmount;
  }

  public static Builder builder() {
    return new com.stripe.param.issuing.AuthorizationApproveParams.Builder();
  }

  public static class Builder {
    private List<String> expand;

    private Long heldAmount;

    /** Finalize and obtain parameter instance from this builder. */
    public AuthorizationApproveParams build() {
      return new AuthorizationApproveParams(this.expand, this.heldAmount);
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * AuthorizationApproveParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * AuthorizationApproveParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * If the authorization's `is_held_amount_controllable` property is `true`, you may provide this
     * value to control how much to hold for the authorization. Must be positive (use
     * [`decline`](https://stripe.com/docs/api/issuing/authorizations/decline) to decline an
     * authorization request).
     */
    public Builder setHeldAmount(Long heldAmount) {
      this.heldAmount = heldAmount;
      return this;
    }
  }
}
