// Generated by com.stripe.generator.entity.SdkBuilder

package com.stripe.param.radar;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class ValueListItemCreateParams extends ApiRequestParams {
  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /** The value of the item (whose type must match the type of the parent value list). */
  @SerializedName("value")
  String value;

  /** The identifier of the value list which the created item will be added to. */
  @SerializedName("value_list")
  String valueList;

  private ValueListItemCreateParams(List<String> expand, String value, String valueList) {
    this.expand = expand;
    this.value = value;
    this.valueList = valueList;
  }

  public static Builder builder() {
    return new com.stripe.param.radar.ValueListItemCreateParams.Builder();
  }

  public static class Builder {
    private List<String> expand;

    private String value;

    private String valueList;

    /** Finalize and obtain parameter instance from this builder. */
    public ValueListItemCreateParams build() {
      return new ValueListItemCreateParams(this.expand, this.value, this.valueList);
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * ValueListItemCreateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * ValueListItemCreateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /** The value of the item (whose type must match the type of the parent value list). */
    public Builder setValue(String value) {
      this.value = value;
      return this;
    }

    /** The identifier of the value list which the created item will be added to. */
    public Builder setValueList(String valueList) {
      this.valueList = valueList;
      return this;
    }
  }
}
