/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class AccountUpdateParams
extends ApiRequestParams {
    @SerializedName(value="account_token")
    String accountToken;
    @SerializedName(value="business_profile")
    BusinessProfile businessProfile;
    @SerializedName(value="business_type")
    String businessType;
    @SerializedName(value="company")
    Company company;
    @SerializedName(value="default_currency")
    String defaultCurrency;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="external_account")
    String externalAccount;
    @SerializedName(value="individual")
    Individual individual;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="requested_capabilities")
    List<RequestedCapability> requestedCapabilities;
    @SerializedName(value="settings")
    Settings settings;
    @SerializedName(value="tos_acceptance")
    TosAcceptance tosAcceptance;

    private AccountUpdateParams(String accountToken, BusinessProfile businessProfile, String businessType, Company company, String defaultCurrency, String email, List<String> expand, String externalAccount, Individual individual, Map<String, String> metadata, List<RequestedCapability> requestedCapabilities, Settings settings, TosAcceptance tosAcceptance) {
        this.accountToken = accountToken;
        this.businessProfile = businessProfile;
        this.businessType = businessType;
        this.company = company;
        this.defaultCurrency = defaultCurrency;
        this.email = email;
        this.expand = expand;
        this.externalAccount = externalAccount;
        this.individual = individual;
        this.metadata = metadata;
        this.requestedCapabilities = requestedCapabilities;
        this.settings = settings;
        this.tosAcceptance = tosAcceptance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum RequestedCapability implements ApiRequestParams.EnumParam
    {
        CARD_ISSUING("card_issuing"),
        CARD_PAYMENTS("card_payments"),
        PLATFORM_PAYMENTS("platform_payments");

        private final String value;

        private RequestedCapability(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class TosAcceptance {
        @SerializedName(value="date")
        Long date;
        @SerializedName(value="ip")
        String ip;
        @SerializedName(value="user_agent")
        String userAgent;

        private TosAcceptance(Long date, String ip, String userAgent) {
            this.date = date;
            this.ip = ip;
            this.userAgent = userAgent;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Long date;
            private String ip;
            private String userAgent;

            public TosAcceptance build() {
                return new TosAcceptance(this.date, this.ip, this.userAgent);
            }

            public Builder setDate(Long date) {
                this.date = date;
                return this;
            }

            public Builder setIp(String ip) {
                this.ip = ip;
                return this;
            }

            public Builder setUserAgent(String userAgent) {
                this.userAgent = userAgent;
                return this;
            }
        }
    }

    public static class Settings {
        @SerializedName(value="branding")
        Branding branding;
        @SerializedName(value="card_payments")
        CardPayments cardPayments;
        @SerializedName(value="payments")
        Payments payments;
        @SerializedName(value="payouts")
        Payouts payouts;

        private Settings(Branding branding, CardPayments cardPayments, Payments payments, Payouts payouts) {
            this.branding = branding;
            this.cardPayments = cardPayments;
            this.payments = payments;
            this.payouts = payouts;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Payouts {
            @SerializedName(value="debit_negative_balances")
            Boolean debitNegativeBalances;
            @SerializedName(value="schedule")
            Schedule schedule;
            @SerializedName(value="statement_descriptor")
            String statementDescriptor;

            private Payouts(Boolean debitNegativeBalances, Schedule schedule, String statementDescriptor) {
                this.debitNegativeBalances = debitNegativeBalances;
                this.schedule = schedule;
                this.statementDescriptor = statementDescriptor;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Schedule {
                @SerializedName(value="delay_days")
                Object delayDays;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="monthly_anchor")
                Long monthlyAnchor;
                @SerializedName(value="weekly_anchor")
                WeeklyAnchor weeklyAnchor;

                private Schedule(Object delayDays, Interval interval, Long monthlyAnchor, WeeklyAnchor weeklyAnchor) {
                    this.delayDays = delayDays;
                    this.interval = interval;
                    this.monthlyAnchor = monthlyAnchor;
                    this.weeklyAnchor = weeklyAnchor;
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static enum WeeklyAnchor implements ApiRequestParams.EnumParam
                {
                    FRIDAY("friday"),
                    MONDAY("monday"),
                    SATURDAY("saturday"),
                    SUNDAY("sunday"),
                    THURSDAY("thursday"),
                    TUESDAY("tuesday"),
                    WEDNESDAY("wednesday");

                    private final String value;

                    private WeeklyAnchor(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAILY("daily"),
                    MANUAL("manual"),
                    MONTHLY("monthly"),
                    WEEKLY("weekly");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum DelayDays implements ApiRequestParams.EnumParam
                {
                    MINIMUM("minimum");

                    private final String value;

                    private DelayDays(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Object delayDays;
                    private Interval interval;
                    private Long monthlyAnchor;
                    private WeeklyAnchor weeklyAnchor;

                    public Schedule build() {
                        return new Schedule(this.delayDays, this.interval, this.monthlyAnchor, this.weeklyAnchor);
                    }

                    public Builder setDelayDays(DelayDays delayDays) {
                        this.delayDays = delayDays;
                        return this;
                    }

                    public Builder setDelayDays(Long delayDays) {
                        this.delayDays = delayDays;
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setMonthlyAnchor(Long monthlyAnchor) {
                        this.monthlyAnchor = monthlyAnchor;
                        return this;
                    }

                    public Builder setWeeklyAnchor(WeeklyAnchor weeklyAnchor) {
                        this.weeklyAnchor = weeklyAnchor;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Boolean debitNegativeBalances;
                private Schedule schedule;
                private String statementDescriptor;

                public Payouts build() {
                    return new Payouts(this.debitNegativeBalances, this.schedule, this.statementDescriptor);
                }

                public Builder setDebitNegativeBalances(Boolean debitNegativeBalances) {
                    this.debitNegativeBalances = debitNegativeBalances;
                    return this;
                }

                public Builder setSchedule(Schedule schedule) {
                    this.schedule = schedule;
                    return this;
                }

                public Builder setStatementDescriptor(String statementDescriptor) {
                    this.statementDescriptor = statementDescriptor;
                    return this;
                }
            }
        }

        public static class Payments {
            @SerializedName(value="statement_descriptor")
            String statementDescriptor;

            private Payments(String statementDescriptor) {
                this.statementDescriptor = statementDescriptor;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String statementDescriptor;

                public Payments build() {
                    return new Payments(this.statementDescriptor);
                }

                public Builder setStatementDescriptor(String statementDescriptor) {
                    this.statementDescriptor = statementDescriptor;
                    return this;
                }
            }
        }

        public static class CardPayments {
            @SerializedName(value="decline_on")
            DeclineOn declineOn;
            @SerializedName(value="statement_descriptor_prefix")
            String statementDescriptorPrefix;

            private CardPayments(DeclineOn declineOn, String statementDescriptorPrefix) {
                this.declineOn = declineOn;
                this.statementDescriptorPrefix = statementDescriptorPrefix;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class DeclineOn {
                @SerializedName(value="avs_failure")
                Boolean avsFailure;
                @SerializedName(value="cvc_failure")
                Boolean cvcFailure;

                private DeclineOn(Boolean avsFailure, Boolean cvcFailure) {
                    this.avsFailure = avsFailure;
                    this.cvcFailure = cvcFailure;
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder {
                    private Boolean avsFailure;
                    private Boolean cvcFailure;

                    public DeclineOn build() {
                        return new DeclineOn(this.avsFailure, this.cvcFailure);
                    }

                    public Builder setAvsFailure(Boolean avsFailure) {
                        this.avsFailure = avsFailure;
                        return this;
                    }

                    public Builder setCvcFailure(Boolean cvcFailure) {
                        this.cvcFailure = cvcFailure;
                        return this;
                    }
                }
            }

            public static class Builder {
                private DeclineOn declineOn;
                private String statementDescriptorPrefix;

                public CardPayments build() {
                    return new CardPayments(this.declineOn, this.statementDescriptorPrefix);
                }

                public Builder setDeclineOn(DeclineOn declineOn) {
                    this.declineOn = declineOn;
                    return this;
                }

                public Builder setStatementDescriptorPrefix(String statementDescriptorPrefix) {
                    this.statementDescriptorPrefix = statementDescriptorPrefix;
                    return this;
                }
            }
        }

        public static class Branding {
            @SerializedName(value="icon")
            String icon;
            @SerializedName(value="logo")
            String logo;
            @SerializedName(value="primary_color")
            String primaryColor;

            private Branding(String icon, String logo, String primaryColor) {
                this.icon = icon;
                this.logo = logo;
                this.primaryColor = primaryColor;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String icon;
                private String logo;
                private String primaryColor;

                public Branding build() {
                    return new Branding(this.icon, this.logo, this.primaryColor);
                }

                public Builder setIcon(String icon) {
                    this.icon = icon;
                    return this;
                }

                public Builder setLogo(String logo) {
                    this.logo = logo;
                    return this;
                }

                public Builder setPrimaryColor(String primaryColor) {
                    this.primaryColor = primaryColor;
                    return this;
                }
            }
        }

        public static class Builder {
            private Branding branding;
            private CardPayments cardPayments;
            private Payments payments;
            private Payouts payouts;

            public Settings build() {
                return new Settings(this.branding, this.cardPayments, this.payments, this.payouts);
            }

            public Builder setBranding(Branding branding) {
                this.branding = branding;
                return this;
            }

            public Builder setCardPayments(CardPayments cardPayments) {
                this.cardPayments = cardPayments;
                return this;
            }

            public Builder setPayments(Payments payments) {
                this.payments = payments;
                return this;
            }

            public Builder setPayouts(Payouts payouts) {
                this.payouts = payouts;
                return this;
            }
        }
    }

    public static class Individual {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_kana")
        AddressKana addressKana;
        @SerializedName(value="address_kanji")
        AddressKanji addressKanji;
        @SerializedName(value="dob")
        Dob dob;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="first_name")
        String firstName;
        @SerializedName(value="first_name_kana")
        String firstNameKana;
        @SerializedName(value="first_name_kanji")
        String firstNameKanji;
        @SerializedName(value="gender")
        String gender;
        @SerializedName(value="id_number")
        String idNumber;
        @SerializedName(value="last_name")
        String lastName;
        @SerializedName(value="last_name_kana")
        String lastNameKana;
        @SerializedName(value="last_name_kanji")
        String lastNameKanji;
        @SerializedName(value="maiden_name")
        String maidenName;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="ssn_last_4")
        String ssnLast4;
        @SerializedName(value="verification")
        Verification verification;

        private Individual(Address address, AddressKana addressKana, AddressKanji addressKanji, Dob dob, String email, String firstName, String firstNameKana, String firstNameKanji, String gender, String idNumber, String lastName, String lastNameKana, String lastNameKanji, String maidenName, Map<String, String> metadata, String phone, String ssnLast4, Verification verification) {
            this.address = address;
            this.addressKana = addressKana;
            this.addressKanji = addressKanji;
            this.dob = dob;
            this.email = email;
            this.firstName = firstName;
            this.firstNameKana = firstNameKana;
            this.firstNameKanji = firstNameKanji;
            this.gender = gender;
            this.idNumber = idNumber;
            this.lastName = lastName;
            this.lastNameKana = lastNameKana;
            this.lastNameKanji = lastNameKanji;
            this.maidenName = maidenName;
            this.metadata = metadata;
            this.phone = phone;
            this.ssnLast4 = ssnLast4;
            this.verification = verification;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Verification {
            @SerializedName(value="document")
            Document document;

            private Verification(Document document) {
                this.document = document;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Document {
                @SerializedName(value="back")
                String back;
                @SerializedName(value="front")
                String front;

                private Document(String back, String front) {
                    this.back = back;
                    this.front = front;
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder {
                    private String back;
                    private String front;

                    public Document build() {
                        return new Document(this.back, this.front);
                    }

                    public Builder setBack(String back) {
                        this.back = back;
                        return this;
                    }

                    public Builder setFront(String front) {
                        this.front = front;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Document document;

                public Verification build() {
                    return new Verification(this.document);
                }

                public Builder setDocument(Document document) {
                    this.document = document;
                    return this;
                }
            }
        }

        public static class Dob {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            private Dob(Long day, Long month, Long year) {
                this.day = day;
                this.month = month;
                this.year = year;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private Long day;
                private Long month;
                private Long year;

                public Dob build() {
                    return new Dob(this.day, this.month, this.year);
                }

                public Builder setDay(Long day) {
                    this.day = day;
                    return this;
                }

                public Builder setMonth(Long month) {
                    this.month = month;
                    return this;
                }

                public Builder setYear(Long year) {
                    this.year = year;
                    return this;
                }
            }
        }

        public static class AddressKanji {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            private AddressKanji(String city, String country, String line1, String line2, String postalCode, String state, String town) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
                this.town = town;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;
                private String town;

                public AddressKanji build() {
                    return new AddressKanji(this.city, this.country, this.line1, this.line2, this.postalCode, this.state, this.town);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setTown(String town) {
                    this.town = town;
                    return this;
                }
            }
        }

        public static class AddressKana {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            private AddressKana(String city, String country, String line1, String line2, String postalCode, String state, String town) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
                this.town = town;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;
                private String town;

                public AddressKana build() {
                    return new AddressKana(this.city, this.country, this.line1, this.line2, this.postalCode, this.state, this.town);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setTown(String town) {
                    this.town = town;
                    return this;
                }
            }
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private AddressKana addressKana;
            private AddressKanji addressKanji;
            private Dob dob;
            private String email;
            private String firstName;
            private String firstNameKana;
            private String firstNameKanji;
            private String gender;
            private String idNumber;
            private String lastName;
            private String lastNameKana;
            private String lastNameKanji;
            private String maidenName;
            private Map<String, String> metadata;
            private String phone;
            private String ssnLast4;
            private Verification verification;

            public Individual build() {
                return new Individual(this.address, this.addressKana, this.addressKanji, this.dob, this.email, this.firstName, this.firstNameKana, this.firstNameKanji, this.gender, this.idNumber, this.lastName, this.lastNameKana, this.lastNameKanji, this.maidenName, this.metadata, this.phone, this.ssnLast4, this.verification);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setAddressKana(AddressKana addressKana) {
                this.addressKana = addressKana;
                return this;
            }

            public Builder setAddressKanji(AddressKanji addressKanji) {
                this.addressKanji = addressKanji;
                return this;
            }

            public Builder setDob(Dob dob) {
                this.dob = dob;
                return this;
            }

            public Builder setEmail(String email) {
                this.email = email;
                return this;
            }

            public Builder setFirstName(String firstName) {
                this.firstName = firstName;
                return this;
            }

            public Builder setFirstNameKana(String firstNameKana) {
                this.firstNameKana = firstNameKana;
                return this;
            }

            public Builder setFirstNameKanji(String firstNameKanji) {
                this.firstNameKanji = firstNameKanji;
                return this;
            }

            public Builder setGender(String gender) {
                this.gender = gender;
                return this;
            }

            public Builder setIdNumber(String idNumber) {
                this.idNumber = idNumber;
                return this;
            }

            public Builder setLastName(String lastName) {
                this.lastName = lastName;
                return this;
            }

            public Builder setLastNameKana(String lastNameKana) {
                this.lastNameKana = lastNameKana;
                return this;
            }

            public Builder setLastNameKanji(String lastNameKanji) {
                this.lastNameKanji = lastNameKanji;
                return this;
            }

            public Builder setMaidenName(String maidenName) {
                this.maidenName = maidenName;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setSsnLast4(String ssnLast4) {
                this.ssnLast4 = ssnLast4;
                return this;
            }

            public Builder setVerification(Verification verification) {
                this.verification = verification;
                return this;
            }
        }
    }

    public static class Company {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_kana")
        AddressKana addressKana;
        @SerializedName(value="address_kanji")
        AddressKanji addressKanji;
        @SerializedName(value="directors_provided")
        Boolean directorsProvided;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="name_kana")
        String nameKana;
        @SerializedName(value="name_kanji")
        String nameKanji;
        @SerializedName(value="owners_provided")
        Boolean ownersProvided;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="tax_id")
        String taxId;
        @SerializedName(value="tax_id_registrar")
        String taxIdRegistrar;
        @SerializedName(value="vat_id")
        String vatId;

        private Company(Address address, AddressKana addressKana, AddressKanji addressKanji, Boolean directorsProvided, String name, String nameKana, String nameKanji, Boolean ownersProvided, String phone, String taxId, String taxIdRegistrar, String vatId) {
            this.address = address;
            this.addressKana = addressKana;
            this.addressKanji = addressKanji;
            this.directorsProvided = directorsProvided;
            this.name = name;
            this.nameKana = nameKana;
            this.nameKanji = nameKanji;
            this.ownersProvided = ownersProvided;
            this.phone = phone;
            this.taxId = taxId;
            this.taxIdRegistrar = taxIdRegistrar;
            this.vatId = vatId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class AddressKanji {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            private AddressKanji(String city, String country, String line1, String line2, String postalCode, String state, String town) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
                this.town = town;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;
                private String town;

                public AddressKanji build() {
                    return new AddressKanji(this.city, this.country, this.line1, this.line2, this.postalCode, this.state, this.town);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setTown(String town) {
                    this.town = town;
                    return this;
                }
            }
        }

        public static class AddressKana {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="town")
            String town;

            private AddressKana(String city, String country, String line1, String line2, String postalCode, String state, String town) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
                this.town = town;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;
                private String town;

                public AddressKana build() {
                    return new AddressKana(this.city, this.country, this.line1, this.line2, this.postalCode, this.state, this.town);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setTown(String town) {
                    this.town = town;
                    return this;
                }
            }
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private String city;
                private String country;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private AddressKana addressKana;
            private AddressKanji addressKanji;
            private Boolean directorsProvided;
            private String name;
            private String nameKana;
            private String nameKanji;
            private Boolean ownersProvided;
            private String phone;
            private String taxId;
            private String taxIdRegistrar;
            private String vatId;

            public Company build() {
                return new Company(this.address, this.addressKana, this.addressKanji, this.directorsProvided, this.name, this.nameKana, this.nameKanji, this.ownersProvided, this.phone, this.taxId, this.taxIdRegistrar, this.vatId);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setAddressKana(AddressKana addressKana) {
                this.addressKana = addressKana;
                return this;
            }

            public Builder setAddressKanji(AddressKanji addressKanji) {
                this.addressKanji = addressKanji;
                return this;
            }

            public Builder setDirectorsProvided(Boolean directorsProvided) {
                this.directorsProvided = directorsProvided;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setNameKana(String nameKana) {
                this.nameKana = nameKana;
                return this;
            }

            public Builder setNameKanji(String nameKanji) {
                this.nameKanji = nameKanji;
                return this;
            }

            public Builder setOwnersProvided(Boolean ownersProvided) {
                this.ownersProvided = ownersProvided;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setTaxId(String taxId) {
                this.taxId = taxId;
                return this;
            }

            public Builder setTaxIdRegistrar(String taxIdRegistrar) {
                this.taxIdRegistrar = taxIdRegistrar;
                return this;
            }

            public Builder setVatId(String vatId) {
                this.vatId = vatId;
                return this;
            }
        }
    }

    public static class BusinessProfile {
        @SerializedName(value="mcc")
        String mcc;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="product_description")
        String productDescription;
        @SerializedName(value="support_email")
        String supportEmail;
        @SerializedName(value="support_phone")
        String supportPhone;
        @SerializedName(value="support_url")
        String supportUrl;
        @SerializedName(value="url")
        String url;

        private BusinessProfile(String mcc, String name, String productDescription, String supportEmail, String supportPhone, String supportUrl, String url) {
            this.mcc = mcc;
            this.name = name;
            this.productDescription = productDescription;
            this.supportEmail = supportEmail;
            this.supportPhone = supportPhone;
            this.supportUrl = supportUrl;
            this.url = url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String mcc;
            private String name;
            private String productDescription;
            private String supportEmail;
            private String supportPhone;
            private String supportUrl;
            private String url;

            public BusinessProfile build() {
                return new BusinessProfile(this.mcc, this.name, this.productDescription, this.supportEmail, this.supportPhone, this.supportUrl, this.url);
            }

            public Builder setMcc(String mcc) {
                this.mcc = mcc;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setProductDescription(String productDescription) {
                this.productDescription = productDescription;
                return this;
            }

            public Builder setSupportEmail(String supportEmail) {
                this.supportEmail = supportEmail;
                return this;
            }

            public Builder setSupportPhone(String supportPhone) {
                this.supportPhone = supportPhone;
                return this;
            }

            public Builder setSupportUrl(String supportUrl) {
                this.supportUrl = supportUrl;
                return this;
            }

            public Builder setUrl(String url) {
                this.url = url;
                return this;
            }
        }
    }

    public static class Builder {
        private String accountToken;
        private BusinessProfile businessProfile;
        private String businessType;
        private Company company;
        private String defaultCurrency;
        private String email;
        private List<String> expand;
        private String externalAccount;
        private Individual individual;
        private Map<String, String> metadata;
        private List<RequestedCapability> requestedCapabilities;
        private Settings settings;
        private TosAcceptance tosAcceptance;

        public AccountUpdateParams build() {
            return new AccountUpdateParams(this.accountToken, this.businessProfile, this.businessType, this.company, this.defaultCurrency, this.email, this.expand, this.externalAccount, this.individual, this.metadata, this.requestedCapabilities, this.settings, this.tosAcceptance);
        }

        public Builder setAccountToken(String accountToken) {
            this.accountToken = accountToken;
            return this;
        }

        public Builder setBusinessProfile(BusinessProfile businessProfile) {
            this.businessProfile = businessProfile;
            return this;
        }

        public Builder setBusinessType(String businessType) {
            this.businessType = businessType;
            return this;
        }

        public Builder setCompany(Company company) {
            this.company = company;
            return this;
        }

        public Builder setDefaultCurrency(String defaultCurrency) {
            this.defaultCurrency = defaultCurrency;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setExternalAccount(String externalAccount) {
            this.externalAccount = externalAccount;
            return this;
        }

        public Builder setIndividual(Individual individual) {
            this.individual = individual;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder addRequestedCapability(RequestedCapability element) {
            if (this.requestedCapabilities == null) {
                this.requestedCapabilities = new ArrayList<RequestedCapability>();
            }
            this.requestedCapabilities.add(element);
            return this;
        }

        public Builder addAllRequestedCapability(List<RequestedCapability> elements) {
            if (this.requestedCapabilities == null) {
                this.requestedCapabilities = new ArrayList<RequestedCapability>();
            }
            this.requestedCapabilities.addAll(elements);
            return this;
        }

        public Builder setSettings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder setTosAcceptance(TosAcceptance tosAcceptance) {
            this.tosAcceptance = tosAcceptance;
            return this;
        }
    }
}

