/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.List;

public class ChargeCaptureParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="application_fee")
    Long applicationFee;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    String transferGroup;

    private ChargeCaptureParams(Long amount, Long applicationFee, Long applicationFeeAmount, List<String> expand, String receiptEmail, String statementDescriptor, TransferData transferData, String transferGroup) {
        this.amount = amount;
        this.applicationFee = applicationFee;
        this.applicationFeeAmount = applicationFeeAmount;
        this.expand = expand;
        this.receiptEmail = receiptEmail;
        this.statementDescriptor = statementDescriptor;
        this.transferData = transferData;
        this.transferGroup = transferGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class TransferData {
        @SerializedName(value="amount")
        Long amount;

        private TransferData(Long amount) {
            this.amount = amount;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Long amount;

            public TransferData build() {
                return new TransferData(this.amount);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }
        }
    }

    public static class Builder {
        private Long amount;
        private Long applicationFee;
        private Long applicationFeeAmount;
        private List<String> expand;
        private String receiptEmail;
        private String statementDescriptor;
        private TransferData transferData;
        private String transferGroup;

        public ChargeCaptureParams build() {
            return new ChargeCaptureParams(this.amount, this.applicationFee, this.applicationFeeAmount, this.expand, this.receiptEmail, this.statementDescriptor, this.transferData, this.transferGroup);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setApplicationFee(Long applicationFee) {
            this.applicationFee = applicationFee;
            return this;
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setReceiptEmail(String receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public Builder setTransferGroup(String transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }
    }
}

