/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class InvoiceUpcomingParams
extends ApiRequestParams {
    @SerializedName(value="coupon")
    String coupon;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="invoice_items")
    List<InvoiceItem> invoiceItems;
    @SerializedName(value="subscription")
    String subscription;
    @SerializedName(value="subscription_billing_cycle_anchor")
    Object subscriptionBillingCycleAnchor;
    @SerializedName(value="subscription_cancel_at_period_end")
    Boolean subscriptionCancelAtPeriodEnd;
    @SerializedName(value="subscription_cancel_now")
    Boolean subscriptionCancelNow;
    @SerializedName(value="subscription_default_tax_rates")
    Object subscriptionDefaultTaxRates;
    @SerializedName(value="subscription_items")
    List<SubscriptionItem> subscriptionItems;
    @SerializedName(value="subscription_prorate")
    Boolean subscriptionProrate;
    @SerializedName(value="subscription_proration_date")
    Long subscriptionProrationDate;
    @SerializedName(value="subscription_tax_percent")
    BigDecimal subscriptionTaxPercent;
    @SerializedName(value="subscription_trial_end")
    Object subscriptionTrialEnd;
    @SerializedName(value="subscription_trial_from_plan")
    Boolean subscriptionTrialFromPlan;

    private InvoiceUpcomingParams(String coupon, String customer, List<String> expand, List<InvoiceItem> invoiceItems, String subscription, Object subscriptionBillingCycleAnchor, Boolean subscriptionCancelAtPeriodEnd, Boolean subscriptionCancelNow, Object subscriptionDefaultTaxRates, List<SubscriptionItem> subscriptionItems, Boolean subscriptionProrate, Long subscriptionProrationDate, BigDecimal subscriptionTaxPercent, Object subscriptionTrialEnd, Boolean subscriptionTrialFromPlan) {
        this.coupon = coupon;
        this.customer = customer;
        this.expand = expand;
        this.invoiceItems = invoiceItems;
        this.subscription = subscription;
        this.subscriptionBillingCycleAnchor = subscriptionBillingCycleAnchor;
        this.subscriptionCancelAtPeriodEnd = subscriptionCancelAtPeriodEnd;
        this.subscriptionCancelNow = subscriptionCancelNow;
        this.subscriptionDefaultTaxRates = subscriptionDefaultTaxRates;
        this.subscriptionItems = subscriptionItems;
        this.subscriptionProrate = subscriptionProrate;
        this.subscriptionProrationDate = subscriptionProrationDate;
        this.subscriptionTaxPercent = subscriptionTaxPercent;
        this.subscriptionTrialEnd = subscriptionTrialEnd;
        this.subscriptionTrialFromPlan = subscriptionTrialFromPlan;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum SubscriptionTrialEnd implements ApiRequestParams.EnumParam
    {
        NOW("now");

        private final String value;

        private SubscriptionTrialEnd(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum SubscriptionBillingCycleAnchor implements ApiRequestParams.EnumParam
    {
        NOW("now"),
        UNCHANGED("unchanged");

        private final String value;

        private SubscriptionBillingCycleAnchor(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class SubscriptionItem {
        @SerializedName(value="billing_thresholds")
        Object billingThresholds;
        @SerializedName(value="clear_usage")
        Boolean clearUsage;
        @SerializedName(value="deleted")
        Boolean deleted;
        @SerializedName(value="id")
        String id;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="plan")
        String plan;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        Object taxRates;

        private SubscriptionItem(Object billingThresholds, Boolean clearUsage, Boolean deleted, String id, Map<String, String> metadata, String plan, Long quantity, Object taxRates) {
            this.billingThresholds = billingThresholds;
            this.clearUsage = clearUsage;
            this.deleted = deleted;
            this.id = id;
            this.metadata = metadata;
            this.plan = plan;
            this.quantity = quantity;
            this.taxRates = taxRates;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class BillingThresholds {
            @SerializedName(value="usage_gte")
            Long usageGte;

            private BillingThresholds(Long usageGte) {
                this.usageGte = usageGte;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private Long usageGte;

                public BillingThresholds build() {
                    return new BillingThresholds(this.usageGte);
                }

                public Builder setUsageGte(Long usageGte) {
                    this.usageGte = usageGte;
                    return this;
                }
            }
        }

        public static class Builder {
            private Object billingThresholds;
            private Boolean clearUsage;
            private Boolean deleted;
            private String id;
            private Map<String, String> metadata;
            private String plan;
            private Long quantity;
            private Object taxRates;

            public SubscriptionItem build() {
                return new SubscriptionItem(this.billingThresholds, this.clearUsage, this.deleted, this.id, this.metadata, this.plan, this.quantity, this.taxRates);
            }

            public Builder setBillingThresholds(BillingThresholds billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder setBillingThresholds(EmptyParam billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder setClearUsage(Boolean clearUsage) {
                this.clearUsage = clearUsage;
                return this;
            }

            public Builder setDeleted(Boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            public Builder setId(String id) {
                this.id = id;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setPlan(String plan) {
                this.plan = plan;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder setTaxRates(EmptyParam taxRates) {
                this.taxRates = taxRates;
                return this;
            }

            public Builder setTaxRates(List<String> taxRates) {
                this.taxRates = taxRates;
                return this;
            }
        }
    }

    public static class InvoiceItem {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="discountable")
        Boolean discountable;
        @SerializedName(value="invoiceitem")
        String invoiceitem;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="period")
        Period period;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        Object taxRates;
        @SerializedName(value="unit_amount")
        Long unitAmount;

        private InvoiceItem(Long amount, String currency, String description, Boolean discountable, String invoiceitem, Map<String, String> metadata, Period period, Long quantity, Object taxRates, Long unitAmount) {
            this.amount = amount;
            this.currency = currency;
            this.description = description;
            this.discountable = discountable;
            this.invoiceitem = invoiceitem;
            this.metadata = metadata;
            this.period = period;
            this.quantity = quantity;
            this.taxRates = taxRates;
            this.unitAmount = unitAmount;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Period {
            @SerializedName(value="end")
            Long end;
            @SerializedName(value="start")
            Long start;

            private Period(Long end, Long start) {
                this.end = end;
                this.start = start;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private Long end;
                private Long start;

                public Period build() {
                    return new Period(this.end, this.start);
                }

                public Builder setEnd(Long end) {
                    this.end = end;
                    return this;
                }

                public Builder setStart(Long start) {
                    this.start = start;
                    return this;
                }
            }
        }

        public static class Builder {
            private Long amount;
            private String currency;
            private String description;
            private Boolean discountable;
            private String invoiceitem;
            private Map<String, String> metadata;
            private Period period;
            private Long quantity;
            private Object taxRates;
            private Long unitAmount;

            public InvoiceItem build() {
                return new InvoiceItem(this.amount, this.currency, this.description, this.discountable, this.invoiceitem, this.metadata, this.period, this.quantity, this.taxRates, this.unitAmount);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder setCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setDiscountable(Boolean discountable) {
                this.discountable = discountable;
                return this;
            }

            public Builder setInvoiceitem(String invoiceitem) {
                this.invoiceitem = invoiceitem;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setPeriod(Period period) {
                this.period = period;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder setTaxRates(EmptyParam taxRates) {
                this.taxRates = taxRates;
                return this;
            }

            public Builder setTaxRates(List<String> taxRates) {
                this.taxRates = taxRates;
                return this;
            }

            public Builder setUnitAmount(Long unitAmount) {
                this.unitAmount = unitAmount;
                return this;
            }
        }
    }

    public static class Builder {
        private String coupon;
        private String customer;
        private List<String> expand;
        private List<InvoiceItem> invoiceItems;
        private String subscription;
        private Object subscriptionBillingCycleAnchor;
        private Boolean subscriptionCancelAtPeriodEnd;
        private Boolean subscriptionCancelNow;
        private Object subscriptionDefaultTaxRates;
        private List<SubscriptionItem> subscriptionItems;
        private Boolean subscriptionProrate;
        private Long subscriptionProrationDate;
        private BigDecimal subscriptionTaxPercent;
        private Object subscriptionTrialEnd;
        private Boolean subscriptionTrialFromPlan;

        public InvoiceUpcomingParams build() {
            return new InvoiceUpcomingParams(this.coupon, this.customer, this.expand, this.invoiceItems, this.subscription, this.subscriptionBillingCycleAnchor, this.subscriptionCancelAtPeriodEnd, this.subscriptionCancelNow, this.subscriptionDefaultTaxRates, this.subscriptionItems, this.subscriptionProrate, this.subscriptionProrationDate, this.subscriptionTaxPercent, this.subscriptionTrialEnd, this.subscriptionTrialFromPlan);
        }

        public Builder setCoupon(String coupon) {
            this.coupon = coupon;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder addInvoiceItem(InvoiceItem element) {
            if (this.invoiceItems == null) {
                this.invoiceItems = new ArrayList<InvoiceItem>();
            }
            this.invoiceItems.add(element);
            return this;
        }

        public Builder addAllInvoiceItem(List<InvoiceItem> elements) {
            if (this.invoiceItems == null) {
                this.invoiceItems = new ArrayList<InvoiceItem>();
            }
            this.invoiceItems.addAll(elements);
            return this;
        }

        public Builder setSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder setSubscriptionBillingCycleAnchor(SubscriptionBillingCycleAnchor subscriptionBillingCycleAnchor) {
            this.subscriptionBillingCycleAnchor = subscriptionBillingCycleAnchor;
            return this;
        }

        public Builder setSubscriptionBillingCycleAnchor(Long subscriptionBillingCycleAnchor) {
            this.subscriptionBillingCycleAnchor = subscriptionBillingCycleAnchor;
            return this;
        }

        public Builder setSubscriptionCancelAtPeriodEnd(Boolean subscriptionCancelAtPeriodEnd) {
            this.subscriptionCancelAtPeriodEnd = subscriptionCancelAtPeriodEnd;
            return this;
        }

        public Builder setSubscriptionCancelNow(Boolean subscriptionCancelNow) {
            this.subscriptionCancelNow = subscriptionCancelNow;
            return this;
        }

        public Builder setSubscriptionDefaultTaxRates(EmptyParam subscriptionDefaultTaxRates) {
            this.subscriptionDefaultTaxRates = subscriptionDefaultTaxRates;
            return this;
        }

        public Builder setSubscriptionDefaultTaxRates(List<String> subscriptionDefaultTaxRates) {
            this.subscriptionDefaultTaxRates = subscriptionDefaultTaxRates;
            return this;
        }

        public Builder addSubscriptionItem(SubscriptionItem element) {
            if (this.subscriptionItems == null) {
                this.subscriptionItems = new ArrayList<SubscriptionItem>();
            }
            this.subscriptionItems.add(element);
            return this;
        }

        public Builder addAllSubscriptionItem(List<SubscriptionItem> elements) {
            if (this.subscriptionItems == null) {
                this.subscriptionItems = new ArrayList<SubscriptionItem>();
            }
            this.subscriptionItems.addAll(elements);
            return this;
        }

        public Builder setSubscriptionProrate(Boolean subscriptionProrate) {
            this.subscriptionProrate = subscriptionProrate;
            return this;
        }

        public Builder setSubscriptionProrationDate(Long subscriptionProrationDate) {
            this.subscriptionProrationDate = subscriptionProrationDate;
            return this;
        }

        public Builder setSubscriptionTaxPercent(BigDecimal subscriptionTaxPercent) {
            this.subscriptionTaxPercent = subscriptionTaxPercent;
            return this;
        }

        public Builder setSubscriptionTrialEnd(SubscriptionTrialEnd subscriptionTrialEnd) {
            this.subscriptionTrialEnd = subscriptionTrialEnd;
            return this;
        }

        public Builder setSubscriptionTrialEnd(Long subscriptionTrialEnd) {
            this.subscriptionTrialEnd = subscriptionTrialEnd;
            return this;
        }

        public Builder setSubscriptionTrialFromPlan(Boolean subscriptionTrialFromPlan) {
            this.subscriptionTrialFromPlan = subscriptionTrialFromPlan;
            return this;
        }
    }
}

