/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TopupCreateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="source")
    String source;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="transfer_group")
    String transferGroup;

    private TopupCreateParams(Long amount, String currency, String description, List<String> expand, Map<String, String> metadata, String source, String statementDescriptor, String transferGroup) {
        this.amount = amount;
        this.currency = currency;
        this.description = description;
        this.expand = expand;
        this.metadata = metadata;
        this.source = source;
        this.statementDescriptor = statementDescriptor;
        this.transferGroup = transferGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long amount;
        private String currency;
        private String description;
        private List<String> expand;
        private Map<String, String> metadata;
        private String source;
        private String statementDescriptor;
        private String transferGroup;

        public TopupCreateParams build() {
            return new TopupCreateParams(this.amount, this.currency, this.description, this.expand, this.metadata, this.source, this.statementDescriptor, this.transferGroup);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setTransferGroup(String transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }
    }
}

