/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.address;

import android.content.res.Resources;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.uicore.address.CountryAddressSchema;
import com.stripe.android.uicore.address.TransformAddressToElementKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0011\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007R-\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/uicore/address/AddressSchemaRepository;", "", "resources", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources;)V", "countryAddressSchemaMap", "", "", "", "Lcom/stripe/android/uicore/address/CountryAddressSchema;", "getCountryAddressSchemaMap", "()Ljava/util/Map;", "countryAddressSchemaMap$delegate", "Lkotlin/Lazy;", "getResources", "()Landroid/content/res/Resources;", "getSchema", "countryCode", "Companion", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public class AddressSchemaRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Resources resources;
    @NotNull
    private final Lazy countryAddressSchemaMap$delegate;
    public static final int $stable = 8;
    @NotNull
    public static final String DEFAULT_COUNTRY_CODE = "ZZ";
    @NotNull
    private static final Set<String> SUPPORTED_COUNTRIES;

    @Inject
    public AddressSchemaRepository(@Nullable Resources resources) {
        this.resources = resources;
        this.countryAddressSchemaMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends List<? extends CountryAddressSchema>>>(this){
            final /* synthetic */ AddressSchemaRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, List<CountryAddressSchema>> invoke() {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                String string;
                Map map2;
                Object object;
                Object $this$associateWith$iv = AddressSchemaRepository.Companion.getSUPPORTED_COUNTRIES();
                boolean $i$f$associateWith = false;
                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                    void countryCode;
                    String string2 = (String)element$iv$iv;
                    object = element$iv$iv;
                    map2 = result$iv;
                    boolean bl = false;
                    string = "addressinfo/" + (String)countryCode + ".json";
                    map2.put(object, string);
                }
                $this$associateWith$iv = result$iv;
                AddressSchemaRepository addressSchemaRepository = this.this$0;
                boolean $i$f$mapValues = false;
                $this$associateWithTo$iv$iv = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    object = it$iv$iv.getKey();
                    map2 = map3;
                    boolean bl2 = false;
                    String assetFileName = (String)entry2.getValue();
                    Resources resources = addressSchemaRepository.getResources();
                    if (TransformAddressToElementKt.parseAddressesSchema(resources != null && (resources = resources.getAssets()) != null ? resources.open(assetFileName) : null) == null) {
                        String string3 = "Required value was null.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    map2.put(object, string);
                }
                return destination$iv$iv;
            }
        }));
    }

    @Nullable
    public final Resources getResources() {
        return this.resources;
    }

    @NotNull
    protected final Map<String, List<CountryAddressSchema>> getCountryAddressSchemaMap() {
        Lazy lazy = this.countryAddressSchemaMap$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final List<CountryAddressSchema> getSchema(@Nullable String countryCode) {
        Object object;
        block3: {
            block2: {
                object = countryCode;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                List<CountryAddressSchema> list = this.getCountryAddressSchemaMap().get(it);
                object = list;
                if (list != null) break block3;
            }
            object = this.getCountryAddressSchemaMap().get(DEFAULT_COUNTRY_CODE);
        }
        return object;
    }

    static {
        Object[] objectArray = new String[]{"AC", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CV", "CW", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MK", "ML", "MM", "MN", "MO", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SZ", "TA", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VN", "VU", "WF", "WS", "XK", "YE", "YT", "ZA", "ZM", "ZW", DEFAULT_COUNTRY_CODE};
        SUPPORTED_COUNTRIES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/uicore/address/AddressSchemaRepository$Companion;", "", "()V", "DEFAULT_COUNTRY_CODE", "", "SUPPORTED_COUNTRIES", "", "getSUPPORTED_COUNTRIES$annotations", "getSUPPORTED_COUNTRIES", "()Ljava/util/Set;", "stripe-ui-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getSUPPORTED_COUNTRIES() {
            return SUPPORTED_COUNTRIES;
        }

        @VisibleForTesting
        public static /* synthetic */ void getSUPPORTED_COUNTRIES$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

