/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.elements;

import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.R;
import com.stripe.android.core.model.Country;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.CountryUtils;
import com.stripe.android.uicore.elements.DropdownConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000f\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B_\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0016J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u001bH\u0016R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0016\u0010\u001a\u001a\u00020\u001b8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/stripe/android/uicore/elements/CountryConfig;", "Lcom/stripe/android/uicore/elements/DropdownConfig;", "onlyShowCountryCodes", "", "", "locale", "Ljava/util/Locale;", "tinyMode", "", "disableDropdownWithSingleElement", "collapsedLabelMapper", "Lkotlin/Function1;", "Lcom/stripe/android/core/model/Country;", "expandedLabelMapper", "(Ljava/util/Set;Ljava/util/Locale;ZZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "countries", "", "getCountries$stripe_ui_core_release", "()Ljava/util/List;", "debugLabel", "getDebugLabel", "()Ljava/lang/String;", "getDisableDropdownWithSingleElement", "()Z", "displayItems", "getDisplayItems", "label", "", "getLabel", "()I", "getLocale", "()Ljava/util/Locale;", "getOnlyShowCountryCodes", "()Ljava/util/Set;", "rawItems", "getRawItems", "getTinyMode", "convertFromRaw", "rawValue", "getSelectedItemLabel", "index", "Companion", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCountryConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountryConfig.kt\ncom/stripe/android/uicore/elements/CountryConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n766#2:77\n857#2,2:78\n1549#2:80\n1620#2,3:81\n1549#2:84\n1620#2,3:85\n1#3:88\n*S KotlinDebug\n*F\n+ 1 CountryConfig.kt\ncom/stripe/android/uicore/elements/CountryConfig\n*L\n39#1:77\n39#1:78,2\n43#1:80\n43#1:81,3\n45#1:84\n45#1:85,3\n*E\n"})
public final class CountryConfig
implements DropdownConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> onlyShowCountryCodes;
    @NotNull
    private final Locale locale;
    private final boolean tinyMode;
    private final boolean disableDropdownWithSingleElement;
    @NotNull
    private final Function1<Country, String> collapsedLabelMapper;
    @NotNull
    private final String debugLabel;
    @StringRes
    private final int label;
    @NotNull
    private final List<Country> countries;
    @NotNull
    private final List<String> rawItems;
    @NotNull
    private final List<String> displayItems;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public CountryConfig(@NotNull Set<String> onlyShowCountryCodes, @NotNull Locale locale, boolean tinyMode, boolean disableDropdownWithSingleElement, @NotNull Function1<? super Country, String> collapsedLabelMapper, @NotNull Function1<? super Country, String> expandedLabelMapper) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Country it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(onlyShowCountryCodes, (String)"onlyShowCountryCodes");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter(collapsedLabelMapper, (String)"collapsedLabelMapper");
        Intrinsics.checkNotNullParameter(expandedLabelMapper, (String)"expandedLabelMapper");
        this.onlyShowCountryCodes = onlyShowCountryCodes;
        this.locale = locale;
        this.tinyMode = tinyMode;
        this.disableDropdownWithSingleElement = disableDropdownWithSingleElement;
        this.collapsedLabelMapper = collapsedLabelMapper;
        this.debugLabel = "country";
        this.label = R.string.stripe_address_label_country_or_region;
        Iterable iterable = CountryUtils.INSTANCE.getOrderedCountries(this.locale);
        CountryConfig countryConfig2 = this;
        boolean $i$f$filter = false;
        void var9_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Country)element$iv$iv;
            boolean bl = false;
            if (!(this.onlyShowCountryCodes.isEmpty() || this.onlyShowCountryCodes.contains(it.getCode().getValue()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        countryConfig2.countries = (List)destination$iv$iv;
        $this$filter$iv = this.countries;
        countryConfig2 = this;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Country)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCode().getValue());
        }
        countryConfig2.rawItems = (List)destination$iv$iv;
        $this$map$iv = this.countries;
        countryConfig2 = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(expandedLabelMapper.invoke(item$iv$iv));
        }
        countryConfig2.displayItems = (List)destination$iv$iv;
    }

    public /* synthetic */ CountryConfig(Set set, Locale locale, boolean bl, boolean bl2, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function12 = 2.INSTANCE;
        }
        this(set, locale, bl, bl2, (Function1<? super Country, String>)function1, (Function1<? super Country, String>)function12);
    }

    @NotNull
    public final Set<String> getOnlyShowCountryCodes() {
        return this.onlyShowCountryCodes;
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean getTinyMode() {
        return this.tinyMode;
    }

    @Override
    public boolean getDisableDropdownWithSingleElement() {
        return this.disableDropdownWithSingleElement;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    @NotNull
    public final List<Country> getCountries$stripe_ui_core_release() {
        return this.countries;
    }

    @Override
    @NotNull
    public List<String> getRawItems() {
        return this.rawItems;
    }

    @Override
    @NotNull
    public List<String> getDisplayItems() {
        return this.displayItems;
    }

    @Override
    @NotNull
    public String getSelectedItemLabel(int index) {
        Country country;
        Object object = (Country)CollectionsKt.getOrNull(this.countries, (int)index);
        if (object == null || (object = (String)this.collapsedLabelMapper.invoke((Object)(country = object))) == null) {
            object = "";
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        String string2;
        String string3;
        block6: {
            block5: {
                String string4;
                Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
                CountryCode countryCode = CountryCode.Companion.create(rawValue);
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                Country country = CountryUtils.INSTANCE.getCountryByCode(countryCode, locale);
                if (country == null) break block5;
                Country country2 = country;
                boolean bl = false;
                Integer n = this.countries.indexOf(country2);
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                Integer n2 = !(it == -1) ? n : null;
                if (n2 != null) {
                    it = ((Number)n2).intValue();
                    boolean bl3 = false;
                    string4 = this.getDisplayItems().get(it);
                } else {
                    string4 = null;
                }
                if ((string3 = string4) != null) break block6;
            }
            String string5 = (String)CollectionsKt.firstOrNull(this.getDisplayItems());
            string2 = string5;
            if (string5 != null) return string2;
            return "";
        }
        string2 = string3;
        return string2;
    }

    public CountryConfig() {
        this(null, null, false, false, null, null, 63, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/uicore/elements/CountryConfig$Companion;", "", "()V", "countryCodeToEmoji", "", "countryCode", "countryCodeToEmoji$stripe_ui_core_release", "stripe-ui-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String countryCodeToEmoji$stripe_ui_core_release(@NotNull String countryCode) {
            Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
            if (countryCode.length() != 2) {
                return "\ud83c\udf10";
            }
            int firstLetter = Character.codePointAt(countryCode, 0) - 65 + 127462;
            int secondLetter = Character.codePointAt(countryCode, 1) - 65 + 127462;
            char[] cArray = Character.toChars(firstLetter);
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toChars(firstLetter)");
            char[] cArray2 = Character.toChars(secondLetter);
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toChars(secondLetter)");
            char[] cArray3 = ArraysKt.plus((char[])cArray, (char[])cArray2);
            return new String(cArray3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

