/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.elements;

import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.VisualTransformation;
import com.stripe.android.uicore.R;
import com.stripe.android.uicore.elements.SimpleTextFieldController;
import com.stripe.android.uicore.elements.TextFieldConfig;
import com.stripe.android.uicore.elements.TextFieldIcon;
import com.stripe.android.uicore.elements.TextFieldState;
import com.stripe.android.uicore.elements.TextFieldStateConstants;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\tH\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\tH\u0016J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tH\u0016R\u001f\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\f\u001a\u00020\rX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000e\u0010\u0006R\u0016\u0010\u000f\u001a\u00020\u00108\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006."}, d2={"Lcom/stripe/android/uicore/elements/EmailConfig;", "Lcom/stripe/android/uicore/elements/TextFieldConfig;", "()V", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "", "getDebugLabel", "()Ljava/lang/String;", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboard-PjHm6EE", "label", "", "getLabel", "()Ljava/lang/Integer;", "loading", "Lkotlinx/coroutines/flow/StateFlow;", "", "getLoading", "()Lkotlinx/coroutines/flow/StateFlow;", "trailingIcon", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/uicore/elements/TextFieldIcon;", "getTrailingIcon", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "()Landroidx/compose/ui/text/input/VisualTransformation;", "cannotBecomeValid", "str", "containsNameAndDomain", "convertFromRaw", "rawValue", "convertToRaw", "displayName", "determineState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "input", "filter", "userTyped", "Companion", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEmailConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailConfig.kt\ncom/stripe/android/uicore/elements/EmailConfig\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,73:1\n483#2,11:74\n1099#2,3:85\n*S KotlinDebug\n*F\n+ 1 EmailConfig.kt\ncom/stripe/android/uicore/elements/EmailConfig\n*L\n31#1:74,11\n51#1:85,3\n*E\n"})
public final class EmailConfig
implements TextFieldConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int capitalization = KeyboardCapitalization.Companion.getNone-IUNYP9k();
    @NotNull
    private final String debugLabel;
    @StringRes
    private final int label = R.string.stripe_email;
    private final int keyboard = KeyboardType.Companion.getEmail-PjHm6EE();
    @Nullable
    private final VisualTransformation visualTransformation;
    @NotNull
    private final MutableStateFlow<TextFieldIcon> trailingIcon = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private final StateFlow<Boolean> loading = (StateFlow)StateFlowKt.MutableStateFlow((Object)false);
    public static final int $stable = 8;
    @NotNull
    private static final Pattern PATTERN;

    public EmailConfig() {
        this.debugLabel = "email";
    }

    @Override
    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    @NotNull
    public Integer getLabel() {
        return this.label;
    }

    @Override
    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @Override
    @Nullable
    public VisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    @NotNull
    public MutableStateFlow<TextFieldIcon> getTrailingIcon() {
        return this.trailingIcon;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> getLoading() {
        return this.loading;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String filter(@NotNull String userTyped) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        String $this$filterNot$iv = userTyped;
        boolean $i$f$filterNot = false;
        CharSequence charSequence = $this$filterNot$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterNotTo = false;
        for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
            boolean bl = false;
            if (CharsKt.isWhitespace((char)it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filterNotTo(StringBuilder(), predicate).toString()");
        return string2;
    }

    @Override
    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        return rawValue;
    }

    @Override
    @NotNull
    public TextFieldState determineState(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return ((CharSequence)input).length() == 0 ? (TextFieldState)TextFieldStateConstants.Error.Blank.INSTANCE : (PATTERN.matcher(input).matches() ? (TextFieldState)TextFieldStateConstants.Valid.Limitless.INSTANCE : (this.containsNameAndDomain(input) || this.cannotBecomeValid(input) ? (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_email_is_invalid, null, 2, null) : (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.stripe_email_is_invalid)));
    }

    private final boolean containsNameAndDomain(String str) {
        CharSequence charSequence;
        return StringsKt.contains$default((CharSequence)str, (CharSequence)"@", (boolean)false, (int)2, null) && new Regex(".*@.*\\..+").matches(charSequence = (CharSequence)str);
    }

    private final boolean cannotBecomeValid(String str) {
        CharSequence $this$count$iv = str;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '@')) continue;
            ++count$iv;
        }
        return count$iv > 1;
    }

    @Override
    @Nullable
    public String getPlaceHolder() {
        return TextFieldConfig.DefaultImpls.getPlaceHolder(this);
    }

    static {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9\\+\\.\\_\\%\\-\\+]{1,256}\\@[a-zA-Z0-9][a-zA-Z0-9\\-]{0,64}(\\.[a-zA-Z0-9][a-zA-Z0-9\\-]{0,25})+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\n            \"[a\u2026           \")+\"\n        )");
        PATTERN = pattern;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/uicore/elements/EmailConfig$Companion;", "", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "getPATTERN", "()Ljava/util/regex/Pattern;", "createController", "Lcom/stripe/android/uicore/elements/SimpleTextFieldController;", "initialValue", "", "stripe-ui-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleTextFieldController createController(@Nullable String initialValue) {
            return new SimpleTextFieldController(new EmailConfig(), false, initialValue, 2, null);
        }

        @NotNull
        public final Pattern getPATTERN() {
            return PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

