/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.elements;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TransformedText;
import androidx.compose.ui.text.input.VisualTransformation;
import com.stripe.android.uicore.elements.PostalCodeConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/stripe/android/uicore/elements/PostalCodeVisualTransformation;", "Landroidx/compose/ui/text/input/VisualTransformation;", "format", "Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;", "(Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;)V", "getFormat", "()Lcom/stripe/android/uicore/elements/PostalCodeConfig$CountryPostalFormat;", "filter", "Landroidx/compose/ui/text/input/TransformedText;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "postalForCanada", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class PostalCodeVisualTransformation
implements VisualTransformation {
    @NotNull
    private final PostalCodeConfig.CountryPostalFormat format;
    public static final int $stable;

    public PostalCodeVisualTransformation(@NotNull PostalCodeConfig.CountryPostalFormat format2) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        this.format = format2;
    }

    @NotNull
    public final PostalCodeConfig.CountryPostalFormat getFormat() {
        return this.format;
    }

    @NotNull
    public TransformedText filter(@NotNull AnnotatedString text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.format instanceof PostalCodeConfig.CountryPostalFormat.CA ? this.postalForCanada(text) : new TransformedText(text, OffsetMapping.Companion.getIdentity());
    }

    private final TransformedText postalForCanada(AnnotatedString text) {
        Object out = "";
        int n = text.getText().length();
        for (int i = 0; i < n; ++i) {
            out = (String)out + Character.toUpperCase(text.getText().charAt(i));
            if (i != 2) continue;
            out = (String)out + " ";
        }
        OffsetMapping postalCodeOffsetTranslator2 = new OffsetMapping(){

            public int originalToTransformed(int offset) {
                if (offset <= 2) {
                    return offset;
                }
                if (offset <= 5) {
                    return offset + 1;
                }
                return 7;
            }

            public int transformedToOriginal(int offset) {
                if (offset <= 3) {
                    return offset;
                }
                if (offset <= 6) {
                    return offset - 1;
                }
                return 6;
            }
        };
        return new TransformedText(new AnnotatedString((String)out, null, null, 6, null), postalCodeOffsetTranslator2);
    }
}

