/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.jakewharton.disklrucache.DiskLruCache;
import com.stripe.android.uicore.image.ImageType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001aJ,\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001a2\n\u0010\"\u001a\u00060#R\u00020\n2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0002J\f\u0010'\u001a\u00020&*\u00020\u0012H\u0002J\f\u0010(\u001a\u00020\u0005*\u00020\u0005H\u0002R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006*"}, d2={"Lcom/stripe/android/uicore/image/ImageLruDiskCache;", "", "context", "Landroid/content/Context;", "cacheFolder", "", "maxSizeBytes", "", "(Landroid/content/Context;Ljava/lang/String;J)V", "diskLruCache", "Lcom/jakewharton/disklrucache/DiskLruCache;", "getDiskLruCache", "()Lcom/jakewharton/disklrucache/DiskLruCache;", "diskLruCache$delegate", "Lkotlin/Lazy;", "clearCache", "", "compressFormatFromUrl", "Landroid/graphics/Bitmap$CompressFormat;", "url", "containsKey", "", "key", "debug", "s", "getBitmap", "Landroid/graphics/Bitmap;", "getDiskCacheDir", "Ljava/io/File;", "uniqueName", "put", "data", "writeBitmapToFile", "bitmap", "editor", "Lcom/jakewharton/disklrucache/DiskLruCache$Editor;", "compressFormat", "compressQuality", "", "quality", "toKey", "Companion", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nImageLruDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageLruDiskCache.kt\ncom/stripe/android/uicore/image/ImageLruDiskCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class ImageLruDiskCache {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy diskLruCache$delegate;
    public static final int $stable = 8;
    @Deprecated
    @NotNull
    private static final String TAG = "stripe_image_disk_cache";
    @Deprecated
    private static final int APP_VERSION = 1;
    @Deprecated
    private static final int VALUE_COUNT = 1;
    @Deprecated
    private static final int IO_BUFFER_SIZE = 8192;
    @Deprecated
    private static final int PNG_COMPRESS_QUALITY = 100;
    @Deprecated
    private static final int JPEG_COMPRESS_QUALITY = 80;
    @Deprecated
    private static final int WEBP_COMPRESS_QUALITY = 80;

    public ImageLruDiskCache(@NotNull Context context, @NotNull String cacheFolder, long maxSizeBytes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cacheFolder, (String)"cacheFolder");
        this.diskLruCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DiskLruCache>(this, context, cacheFolder, maxSizeBytes){
            final /* synthetic */ ImageLruDiskCache this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $cacheFolder;
            final /* synthetic */ long $maxSizeBytes;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$cacheFolder = $cacheFolder;
                this.$maxSizeBytes = $maxSizeBytes;
                super(0);
            }

            @Nullable
            public final DiskLruCache invoke() {
                DiskLruCache diskLruCache2;
                try {
                    diskLruCache2 = DiskLruCache.open((File)ImageLruDiskCache.access$getDiskCacheDir(this.this$0, this.$context, this.$cacheFolder), (int)1, (int)1, (long)this.$maxSizeBytes);
                }
                catch (IOException e) {
                    Log.e((String)"stripe_image_disk_cache", (String)"error opening cache", (Throwable)e);
                    diskLruCache2 = null;
                }
                return diskLruCache2;
            }
        }));
    }

    public /* synthetic */ ImageLruDiskCache(Context context, String string2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 0xA00000L;
        }
        this(context, string2, l);
    }

    private final DiskLruCache getDiskLruCache() {
        Lazy lazy = this.diskLruCache$delegate;
        return (DiskLruCache)lazy.getValue();
    }

    public final void put(@NotNull String key, @NotNull Bitmap data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DiskLruCache.Editor editor = null;
        String hashedKey = this.toKey(key);
        if (this.containsKey(key)) {
            this.debug("Image already cached");
        } else {
            try {
                DiskLruCache diskLruCache2 = this.getDiskLruCache();
                Object object = editor = diskLruCache2 != null ? diskLruCache2.edit(hashedKey) : null;
                if (editor == null) {
                    return;
                }
                Bitmap.CompressFormat compressFormat = this.compressFormatFromUrl(key);
                if (this.writeBitmapToFile(data, editor, compressFormat, this.quality(compressFormat))) {
                    DiskLruCache diskLruCache3 = this.getDiskLruCache();
                    if (diskLruCache3 != null) {
                        diskLruCache3.flush();
                    }
                    editor.commit();
                    this.debug("image put on disk cache " + hashedKey);
                } else {
                    editor.abort();
                    Log.e((String)TAG, (String)("ERROR on: image put on disk cache " + hashedKey));
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("ERROR on: image put on disk cache " + hashedKey));
                try {
                    Unit unit;
                    boolean bl = false;
                    DiskLruCache.Editor editor2 = editor;
                    if (editor2 != null) {
                        editor2.abort();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Object object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable) {
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
            }
        }
    }

    private final Bitmap.CompressFormat compressFormatFromUrl(String url) {
        ImageType imageType = ImageType.Companion.fromUrl(url);
        if (imageType == null || (imageType = imageType.getCompressFormat()) == null) {
            throw new IllegalArgumentException("Unexpected image format: " + url);
        }
        return imageType;
    }

    private final int quality(Bitmap.CompressFormat $this$quality) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$quality.ordinal()]) {
            case 1: {
                n = 80;
                break;
            }
            case 2: {
                n = 100;
                break;
            }
            case 3: {
                n = 80;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected compress format: " + $this$quality);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Bitmap getBitmap(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Bitmap bitmap = null;
        DiskLruCache.Snapshot snapshot = null;
        String hashedKey = this.toKey(key);
        try {
            DiskLruCache diskLruCache2 = this.getDiskLruCache();
            Object object = snapshot = diskLruCache2 != null ? diskLruCache2.get(hashedKey) : null;
            if (snapshot == null) {
                this.debug("image not in cache: " + hashedKey);
                Bitmap bitmap2 = null;
                return bitmap2;
            }
            InputStream inputStream = snapshot.getInputStream(0);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"snapshot.getInputStream(0)");
            InputStream inputStream2 = inputStream;
            BufferedInputStream buffIn = new BufferedInputStream(inputStream2, 8192);
            bitmap = BitmapFactory.decodeStream((InputStream)buffIn);
            snapshot.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"error getting bitmap from cache", (Throwable)e);
        }
        finally {
            DiskLruCache.Snapshot snapshot2 = snapshot;
            if (snapshot2 != null) {
                snapshot2.close();
            }
        }
        this.debug(bitmap == null ? "image not in cache: " + hashedKey : "image read from disk " + hashedKey);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean contained = false;
        DiskLruCache.Snapshot snapshot = null;
        try {
            DiskLruCache diskLruCache2 = this.getDiskLruCache();
            snapshot = diskLruCache2 != null ? diskLruCache2.get(this.toKey(key)) : null;
            contained = snapshot != null;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"error reading from cache", (Throwable)e);
        }
        finally {
            DiskLruCache.Snapshot snapshot2 = snapshot;
            if (snapshot2 != null) {
                snapshot2.close();
            }
        }
        return contained;
    }

    public final void clearCache() {
        this.debug("disk cache CLEARED");
        try {
            DiskLruCache diskLruCache2 = this.getDiskLruCache();
            if (diskLruCache2 != null) {
                diskLruCache2.delete();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"error clearing cache", (Throwable)e);
        }
    }

    private final void debug(String s) {
    }

    private final String toKey(String $this$toKey) {
        return String.valueOf($this$toKey.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean writeBitmapToFile(Bitmap bitmap, DiskLruCache.Editor editor, Bitmap.CompressFormat compressFormat, int compressQuality) throws IOException, FileNotFoundException {
        boolean bl;
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(editor.newOutputStream(0), 8192);
            bl = bitmap.compress(compressFormat, compressQuality, out);
        }
        catch (Throwable throwable) {
            OutputStream outputStream = out;
            if (outputStream != null) {
                outputStream.close();
            }
            throw throwable;
        }
        out.close();
        return bl;
    }

    private final File getDiskCacheDir(Context context, String uniqueName) {
        String string2 = context.getCacheDir().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.cacheDir.path");
        String cachePath = string2;
        return new File(cachePath + File.separator + uniqueName);
    }

    public static final /* synthetic */ File access$getDiskCacheDir(ImageLruDiskCache $this, Context context, String uniqueName) {
        return $this.getDiskCacheDir(context, uniqueName);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bitmap.CompressFormat.values().length];
            try {
                nArray[Bitmap.CompressFormat.JPEG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.CompressFormat.PNG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.CompressFormat.WEBP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/uicore/image/ImageLruDiskCache$Companion;", "", "()V", "APP_VERSION", "", "IO_BUFFER_SIZE", "JPEG_COMPRESS_QUALITY", "PNG_COMPRESS_QUALITY", "TAG", "", "VALUE_COUNT", "WEBP_COMPRESS_QUALITY", "stripe-ui-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

