/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.elements;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.R;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.uicore.R;
import com.stripe.android.uicore.address.AddressSchemaRegistry;
import com.stripe.android.uicore.elements.AddressController;
import com.stripe.android.uicore.elements.AddressElement;
import com.stripe.android.uicore.elements.AddressElementKt;
import com.stripe.android.uicore.elements.AddressElementUiRegistry;
import com.stripe.android.uicore.elements.AddressTextFieldElement;
import com.stripe.android.uicore.elements.AddressType;
import com.stripe.android.uicore.elements.CountryConfig;
import com.stripe.android.uicore.elements.CountryElement;
import com.stripe.android.uicore.elements.DefaultIsPlacesAvailable;
import com.stripe.android.uicore.elements.DropdownFieldController;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.elements.IsPlacesAvailable;
import com.stripe.android.uicore.elements.PhoneNumberController;
import com.stripe.android.uicore.elements.PhoneNumberElement;
import com.stripe.android.uicore.elements.PhoneNumberState;
import com.stripe.android.uicore.elements.SameAsShippingElement;
import com.stripe.android.uicore.elements.SectionFieldElement;
import com.stripe.android.uicore.elements.SectionFieldErrorController;
import com.stripe.android.uicore.elements.SectionMultiFieldElement;
import com.stripe.android.uicore.elements.SectionSingleFieldElement;
import com.stripe.android.uicore.elements.SimpleTextElement;
import com.stripe.android.uicore.elements.SimpleTextFieldConfig;
import com.stripe.android.uicore.elements.SimpleTextFieldController;
import com.stripe.android.uicore.forms.FormFieldEntry;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J \u0010>\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020@0?0(0'H\u0016J\u0014\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030(0'H\u0016J\b\u0010B\u001a\u00020CH\u0016J\u001e\u0010D\u001a\u00020-2\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0016R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0016\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010.\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010/R\u0016\u00100\u001a\u0004\u0018\u000101X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00107\u001a\u0002088\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b9\u0010:\u001a\u0004\b;\u0010<R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/stripe/android/uicore/elements/AddressElement;", "Lcom/stripe/android/uicore/elements/SectionMultiFieldElement;", "_identifier", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "rawValuesMap", "", "", "addressType", "Lcom/stripe/android/uicore/elements/AddressType;", "countryCodes", "", "countryDropdownFieldController", "Lcom/stripe/android/uicore/elements/DropdownFieldController;", "sameAsShippingElement", "Lcom/stripe/android/uicore/elements/SameAsShippingElement;", "shippingValuesMap", "isPlacesAvailable", "Lcom/stripe/android/uicore/elements/IsPlacesAvailable;", "hideCountry", "", "(Lcom/stripe/android/uicore/elements/IdentifierSpec;Ljava/util/Map;Lcom/stripe/android/uicore/elements/AddressType;Ljava/util/Set;Lcom/stripe/android/uicore/elements/DropdownFieldController;Lcom/stripe/android/uicore/elements/SameAsShippingElement;Ljava/util/Map;Lcom/stripe/android/uicore/elements/IsPlacesAvailable;Z)V", "addressAutoCompleteElement", "Lcom/stripe/android/uicore/elements/AddressTextFieldElement;", "allowsUserInteraction", "getAllowsUserInteraction", "()Z", "controller", "Lcom/stripe/android/uicore/elements/AddressController;", "getController", "()Lcom/stripe/android/uicore/elements/AddressController;", "countryElement", "Lcom/stripe/android/uicore/elements/CountryElement;", "getCountryElement", "()Lcom/stripe/android/uicore/elements/CountryElement;", "currentValuesMap", "", "elementsRegistry", "Lcom/stripe/android/uicore/elements/AddressElementUiRegistry;", "fields", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lcom/stripe/android/uicore/elements/SectionFieldElement;", "getFields", "()Lkotlinx/coroutines/flow/StateFlow;", "fieldsUpdatedFlow", "", "lastSameAsShipping", "Ljava/lang/Boolean;", "mandateText", "Lcom/stripe/android/core/strings/ResolvableString;", "getMandateText", "()Lcom/stripe/android/core/strings/ResolvableString;", "nameElement", "Lcom/stripe/android/uicore/elements/SimpleTextElement;", "otherFields", "phoneNumberElement", "Lcom/stripe/android/uicore/elements/PhoneNumberElement;", "getPhoneNumberElement$annotations", "()V", "getPhoneNumberElement", "()Lcom/stripe/android/uicore/elements/PhoneNumberElement;", "sameAsShippingUpdatedFlow", "getFormFieldValueFlow", "Lkotlin/Pair;", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "getTextFieldIdentifiers", "sectionFieldErrorController", "Lcom/stripe/android/uicore/elements/SectionFieldErrorController;", "setRawValue", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public class AddressElement
extends SectionMultiFieldElement {
    @NotNull
    private Map<IdentifierSpec, String> rawValuesMap;
    @NotNull
    private final AddressType addressType;
    @NotNull
    private final IsPlacesAvailable isPlacesAvailable;
    private final boolean hideCountry;
    private final boolean allowsUserInteraction;
    @Nullable
    private final ResolvableString mandateText;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final CountryElement countryElement;
    @NotNull
    private final SimpleTextElement nameElement;
    @NotNull
    private final AddressTextFieldElement addressAutoCompleteElement;
    @NotNull
    private final PhoneNumberElement phoneNumberElement;
    @NotNull
    private final Map<IdentifierSpec, String> currentValuesMap;
    @NotNull
    private final AddressElementUiRegistry elementsRegistry;
    @NotNull
    private final StateFlow<List<SectionFieldElement>> otherFields;
    @Nullable
    private Boolean lastSameAsShipping;
    @NotNull
    private final StateFlow<Unit> sameAsShippingUpdatedFlow;
    @NotNull
    private final StateFlow<Unit> fieldsUpdatedFlow;
    @NotNull
    private final StateFlow<List<SectionFieldElement>> fields;
    @NotNull
    private final AddressController controller;
    public static final int $stable = 8;

    public AddressElement(@NotNull IdentifierSpec _identifier, @NotNull Map<IdentifierSpec, String> rawValuesMap, @NotNull AddressType addressType, @NotNull Set<String> countryCodes, @NotNull DropdownFieldController countryDropdownFieldController, @Nullable SameAsShippingElement sameAsShippingElement, @Nullable Map<IdentifierSpec, String> shippingValuesMap, @NotNull IsPlacesAvailable isPlacesAvailable, boolean hideCountry) {
        Intrinsics.checkNotNullParameter((Object)_identifier, (String)"_identifier");
        Intrinsics.checkNotNullParameter(rawValuesMap, (String)"rawValuesMap");
        Intrinsics.checkNotNullParameter((Object)addressType, (String)"addressType");
        Intrinsics.checkNotNullParameter(countryCodes, (String)"countryCodes");
        Intrinsics.checkNotNullParameter((Object)countryDropdownFieldController, (String)"countryDropdownFieldController");
        Intrinsics.checkNotNullParameter((Object)isPlacesAvailable, (String)"isPlacesAvailable");
        super(_identifier);
        this.rawValuesMap = rawValuesMap;
        this.addressType = addressType;
        this.isPlacesAvailable = isPlacesAvailable;
        this.hideCountry = hideCountry;
        this.allowsUserInteraction = true;
        this.countryElement = new CountryElement(IdentifierSpec.Companion.getCountry(), countryDropdownFieldController);
        this.nameElement = new SimpleTextElement(IdentifierSpec.Companion.getName(), new SimpleTextFieldController(new SimpleTextFieldConfig(R.string.stripe_address_label_full_name, 0, 0, null, 14, null), false, this.rawValuesMap.get(IdentifierSpec.Companion.getName()), 2, null));
        AddressType addressType2 = this.addressType;
        AddressType.ShippingCondensed shippingCondensed = addressType2 instanceof AddressType.ShippingCondensed ? (AddressType.ShippingCondensed)addressType2 : null;
        this.addressAutoCompleteElement = new AddressTextFieldElement(IdentifierSpec.Companion.getOneLineAddress(), new SimpleTextFieldConfig(R.string.stripe_address_label_address, 0, 0, null, 14, null), (Function0<Unit>)(shippingCondensed != null ? shippingCondensed.getOnNavigation() : null));
        IdentifierSpec identifierSpec = IdentifierSpec.Companion.getPhone();
        String string2 = this.rawValuesMap.get(IdentifierSpec.Companion.getPhone());
        if (string2 == null) {
            string2 = "";
        }
        this.phoneNumberElement = new PhoneNumberElement(identifierSpec, PhoneNumberController.Companion.createPhoneNumberController$default(PhoneNumberController.Companion, string2, null, null, this.addressType.getPhoneNumberState() == PhoneNumberState.OPTIONAL, true, 6, null));
        this.currentValuesMap = new LinkedHashMap();
        this.elementsRegistry = new AddressElementUiRegistry(AddressSchemaRegistry.INSTANCE);
        this.otherFields = StateFlowsKt.mapAsStateFlow(this.countryElement.getController().getRawFieldValue(), (Function1)new Function1<String, List<? extends SectionFieldElement>>(this){
            final /* synthetic */ AddressElement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<SectionFieldElement> invoke(@Nullable String countryCode) {
                void $this$onEach$iv;
                void var5_7;
                List list;
                AddressElement addressElement;
                Object object;
                String string2 = countryCode;
                if (string2 != null) {
                    object = string2;
                    addressElement = this.this$0;
                    String it = object;
                    boolean bl = false;
                    addressElement.getPhoneNumberElement().getController().getCountryDropdownController().onRawValueChange(it);
                }
                if ((list = AddressElement.access$getElementsRegistry$p(this.this$0).get(countryCode)) == null) {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                addressElement = this.this$0;
                boolean $i$f$onEach = false;
                void $this$onEach_u24lambda_u2416$iv = var5_7 = $this$onEach$iv;
                boolean bl = false;
                for (T element$iv : $this$onEach_u24lambda_u2416$iv) {
                    SectionFieldElement field = (SectionFieldElement)element$iv;
                    boolean bl2 = false;
                    AddressElementKt.updateLine1WithAutocompleteAffordance(field, countryCode, AddressElement.access$getAddressType$p(addressElement), AddressElement.access$isPlacesAvailable$p(addressElement));
                    field.setRawValue(AddressElement.access$getRawValuesMap$p(addressElement));
                }
                return (List)var5_7;
            }
        });
        Object object = sameAsShippingElement;
        if (object == null || (object = object.getController()) == null || (object = object.getValue()) == null) {
            object = StateFlowsKt.stateFlowOf(null);
        }
        this.sameAsShippingUpdatedFlow = StateFlowsKt.combineAsStateFlow(this.otherFields, object, (Function2)new Function2<List<? extends SectionFieldElement>, Boolean, Unit>(this, shippingValuesMap){
            final /* synthetic */ AddressElement this$0;
            final /* synthetic */ Map<IdentifierSpec, String> $shippingValuesMap;
            {
                this.this$0 = $receiver;
                this.$shippingValuesMap = $shippingValuesMap;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Unit invoke(@NotNull List<? extends SectionFieldElement> fields2, @Nullable Boolean sameAsShippingValue) {
                Unit unit;
                Boolean bl;
                Intrinsics.checkNotNullParameter(fields2, (String)"fields");
                if (!Intrinsics.areEqual((Object)sameAsShippingValue, (Object)AddressElement.access$getLastSameAsShipping$p(this.this$0))) {
                    AddressElement.access$setLastSameAsShipping$p(this.this$0, sameAsShippingValue);
                    bl = sameAsShippingValue;
                } else {
                    bl = null;
                }
                Boolean sameAsShipping = bl;
                Object object = this.this$0.getCountryElement();
                Object object2 = this.this$0;
                CountryElement it = object;
                boolean bl2 = false;
                List allFields = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)(!AddressElement.access$getHideCountry$p((AddressElement)object2) ? object : null)), (Iterable)fields2);
                Boolean bl3 = sameAsShipping;
                if (bl3 != null) {
                    Object object3;
                    object = bl3;
                    object2 = this.$shippingValuesMap;
                    AddressElement addressElement = this.this$0;
                    boolean same = (Boolean)object;
                    boolean bl4 = false;
                    if (same) {
                        object3 = object2;
                        if (object3 == null) {
                            object3 = MapsKt.emptyMap();
                        }
                    } else {
                        void $this$mapValuesTo$iv$iv;
                        Map $this$mapValues$iv = AddressElement.access$getCurrentValuesMap$p(addressElement);
                        boolean $i$f$mapValues = false;
                        Map map2 = $this$mapValues$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                        boolean $i$f$mapValuesTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            String string2;
                            void it2;
                            void it$iv$iv;
                            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                            Map map3 = destination$iv$iv;
                            boolean bl5 = false;
                            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                            K k = it$iv$iv.getKey();
                            Map map4 = map3;
                            boolean bl6 = false;
                            if (Intrinsics.areEqual(it2.getKey(), (Object)IdentifierSpec.Companion.getCountry())) {
                                string2 = (String)it2.getValue();
                            } else {
                                string2 = (String)AddressElement.access$getRawValuesMap$p(addressElement).get(it2.getKey());
                                if (string2 == null) {
                                    string2 = "";
                                }
                            }
                            String string3 = string2;
                            map4.put(k, string3);
                        }
                        object3 = destination$iv$iv;
                    }
                    Object values = object3;
                    Iterable $this$forEach$iv = allFields;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        SectionFieldElement field = (SectionFieldElement)element$iv;
                        boolean bl7 = false;
                        field.setRawValue((Map<IdentifierSpec, String>)values);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        });
        this.fieldsUpdatedFlow = StateFlowsKt.combineAsStateFlow(this.countryElement.getController().getRawFieldValue(), StateFlowsKt.flatMapLatestAsStateFlow(this.otherFields, fieldsUpdatedFlow.1.INSTANCE), (Function2)new Function2<String, List<? extends Pair<? extends IdentifierSpec, ? extends FormFieldEntry>>, Unit>(this, (SameAsShippingElement)sameAsShippingElement, shippingValuesMap){
            final /* synthetic */ AddressElement this$0;
            final /* synthetic */ SameAsShippingElement $sameAsShippingElement;
            final /* synthetic */ Map<IdentifierSpec, String> $shippingValuesMap;
            {
                this.this$0 = $receiver;
                this.$sameAsShippingElement = $sameAsShippingElement;
                this.$shippingValuesMap = $shippingValuesMap;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Unit invoke(@Nullable String country, @NotNull List<Pair<IdentifierSpec, FormFieldEntry>> values) {
                Unit unit;
                boolean bl;
                block8: {
                    void $this$all$iv;
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    Object object;
                    Intrinsics.checkNotNullParameter(values, (String)"values");
                    String string2 = country;
                    if (string2 != null) {
                        object = string2;
                        AddressElement addressElement = this.this$0;
                        String it = object;
                        boolean bl2 = false;
                        AddressElement.access$getCurrentValuesMap$p(addressElement).put(IdentifierSpec.Companion.getCountry(), it);
                    }
                    object = values;
                    Map map2 = AddressElement.access$getCurrentValuesMap$p(this.this$0);
                    boolean $i$f$associate22 = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    void bl2 = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (T element$iv$iv : $this$associateTo$iv$iv) {
                        Map map3 = destination$iv$iv;
                        Pair it = (Pair)element$iv$iv;
                        boolean bl3 = false;
                        Pair pair = new Pair(it.getFirst(), (Object)((FormFieldEntry)it.getSecond()).getValue());
                        map3.put(pair.getFirst(), pair.getSecond());
                    }
                    map2.putAll(destination$iv$iv);
                    Map $i$f$associate22 = AddressElement.access$getCurrentValuesMap$p(this.this$0);
                    Map<IdentifierSpec, String> map4 = this.$shippingValuesMap;
                    boolean $i$f$all = false;
                    if ($this$all$iv.isEmpty()) {
                        bl = true;
                    } else {
                        Iterator<Map.Entry<K, V>> iterator = $this$all$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> it = element$iv = iterator.next();
                            boolean bl4 = false;
                            Map<IdentifierSpec, String> map5 = map4;
                            if (map5 == null || (map5 = (String)map5.get(it.getKey())) == null) {
                                map5 = "";
                            }
                            if (Intrinsics.areEqual((Object)map5, it.getValue())) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                boolean same = bl;
                AddressElement.access$setLastSameAsShipping$p(this.this$0, same);
                SameAsShippingElement sameAsShippingElement = this.$sameAsShippingElement;
                if (sameAsShippingElement != null) {
                    sameAsShippingElement.setRawValue(MapsKt.mapOf((Pair)TuplesKt.to((Object)this.$sameAsShippingElement.getIdentifier(), (Object)String.valueOf(same))));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        });
        this.fields = StateFlowsKt.combineAsStateFlow(this.countryElement.getController().getRawFieldValue(), this.otherFields, this.sameAsShippingUpdatedFlow, this.fieldsUpdatedFlow, (Function4)new Function4<String, List<? extends SectionFieldElement>, Unit, Unit, List<? extends SectionFieldElement>>(this){
            final /* synthetic */ AddressElement this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final List<SectionFieldElement> invoke(@Nullable String country, @NotNull List<? extends SectionFieldElement> otherFields2, @Nullable Unit unit, @Nullable Unit unit2) {
                List list;
                Intrinsics.checkNotNullParameter(otherFields2, (String)"otherFields");
                Object[] objectArray = new SectionSingleFieldElement[3];
                objectArray[0] = AddressElement.access$getNameElement$p(this.this$0);
                Object[] objectArray2 = this.this$0.getCountryElement();
                Object object = this.this$0;
                Object object2 = objectArray2;
                int n = 1;
                Object[] objectArray3 = objectArray;
                boolean $i$a$-takeUnless-AddressElement$fields$1$condensed$22 = false;
                boolean bl = AddressElement.access$getHideCountry$p((AddressElement)object);
                objectArray3[n] = !bl ? objectArray2 : null;
                objectArray[2] = AddressElement.access$getAddressAutoCompleteElement$p(this.this$0);
                List condensed = CollectionsKt.listOfNotNull((Object[])objectArray);
                objectArray2 = new SectionSingleFieldElement[2];
                objectArray2[0] = AddressElement.access$getNameElement$p(this.this$0);
                object = this.this$0.getCountryElement();
                object2 = this.this$0;
                SectionFieldElement $i$a$-takeUnless-AddressElement$fields$1$condensed$22 = object;
                n = 1;
                objectArray3 = objectArray2;
                boolean bl2 = false;
                bl = AddressElement.access$getHideCountry$p((AddressElement)object2);
                objectArray3[n] = !bl ? object : null;
                List expanded = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray2), (Iterable)otherFields2);
                object = AddressElement.access$getAddressType$p(this.this$0);
                if (object instanceof AddressType.ShippingCondensed) {
                    list = ((AddressType.ShippingCondensed)AddressElement.access$getAddressType$p(this.this$0)).supportsAutoComplete(country, AddressElement.access$isPlacesAvailable$p(this.this$0)) ? condensed : expanded;
                } else if (object instanceof AddressType.ShippingExpanded) {
                    list = expanded;
                } else {
                    object2 = this.this$0.getCountryElement();
                    AddressElement addressElement = this.this$0;
                    Object it = object2;
                    boolean bl3 = false;
                    list = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)(!AddressElement.access$getHideCountry$p(addressElement) ? object2 : null)), (Iterable)otherFields2);
                }
                List baseElements = list;
                List fields2 = AddressElement.access$getAddressType$p(this.this$0).getPhoneNumberState() != PhoneNumberState.HIDDEN ? CollectionsKt.plus((Collection)baseElements, (Object)this.this$0.getPhoneNumberElement()) : baseElements;
                return fields2;
            }
        });
        this.controller = new AddressController(this.fields);
    }

    public /* synthetic */ AddressElement(IdentifierSpec identifierSpec, Map map2, AddressType addressType, Set set, DropdownFieldController dropdownFieldController, SameAsShippingElement sameAsShippingElement, Map map3, IsPlacesAvailable isPlacesAvailable, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            addressType = new AddressType.Normal(null, 1, null);
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            dropdownFieldController = new DropdownFieldController(new CountryConfig(set, null, false, false, null, null, 62, null), (String)map2.get(IdentifierSpec.Companion.getCountry()));
        }
        if ((n & 0x80) != 0) {
            isPlacesAvailable = new DefaultIsPlacesAvailable();
        }
        if ((n & 0x100) != 0) {
            bl = false;
        }
        this(identifierSpec, map2, addressType, set, dropdownFieldController, sameAsShippingElement, map3, isPlacesAvailable, bl);
    }

    @Override
    public boolean getAllowsUserInteraction() {
        return this.allowsUserInteraction;
    }

    @Override
    @Nullable
    public ResolvableString getMandateText() {
        return this.mandateText;
    }

    @NotNull
    public final CountryElement getCountryElement() {
        return this.countryElement;
    }

    @NotNull
    public final PhoneNumberElement getPhoneNumberElement() {
        return this.phoneNumberElement;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPhoneNumberElement$annotations() {
    }

    @NotNull
    public final StateFlow<List<SectionFieldElement>> getFields() {
        return this.fields;
    }

    @NotNull
    public final AddressController getController() {
        return this.controller;
    }

    @Override
    @NotNull
    public SectionFieldErrorController sectionFieldErrorController() {
        return this.controller;
    }

    @Override
    @NotNull
    public StateFlow<List<Pair<IdentifierSpec, FormFieldEntry>>> getFormFieldValueFlow() {
        return StateFlowsKt.flatMapLatestAsStateFlow(this.fields, getFormFieldValueFlow.1.INSTANCE);
    }

    @Override
    @NotNull
    public StateFlow<List<IdentifierSpec>> getTextFieldIdentifiers() {
        return StateFlowsKt.flatMapLatestAsStateFlow(this.fields, getTextFieldIdentifiers.1.INSTANCE);
    }

    @Override
    public void setRawValue(@NotNull Map<IdentifierSpec, String> rawValuesMap) {
        Intrinsics.checkNotNullParameter(rawValuesMap, (String)"rawValuesMap");
        this.rawValuesMap = rawValuesMap;
    }

    public static final /* synthetic */ AddressElementUiRegistry access$getElementsRegistry$p(AddressElement $this) {
        return $this.elementsRegistry;
    }

    public static final /* synthetic */ AddressType access$getAddressType$p(AddressElement $this) {
        return $this.addressType;
    }

    public static final /* synthetic */ IsPlacesAvailable access$isPlacesAvailable$p(AddressElement $this) {
        return $this.isPlacesAvailable;
    }

    public static final /* synthetic */ Map access$getRawValuesMap$p(AddressElement $this) {
        return $this.rawValuesMap;
    }

    public static final /* synthetic */ Boolean access$getLastSameAsShipping$p(AddressElement $this) {
        return $this.lastSameAsShipping;
    }

    public static final /* synthetic */ void access$setLastSameAsShipping$p(AddressElement $this, Boolean bl) {
        $this.lastSameAsShipping = bl;
    }

    public static final /* synthetic */ boolean access$getHideCountry$p(AddressElement $this) {
        return $this.hideCountry;
    }

    public static final /* synthetic */ Map access$getCurrentValuesMap$p(AddressElement $this) {
        return $this.currentValuesMap;
    }

    public static final /* synthetic */ SimpleTextElement access$getNameElement$p(AddressElement $this) {
        return $this.nameElement;
    }

    public static final /* synthetic */ AddressTextFieldElement access$getAddressAutoCompleteElement$p(AddressElement $this) {
        return $this.addressAutoCompleteElement;
    }
}

