package com.stripe.android.uicore.address.schemas

import com.stripe.android.uicore.address.AddressSchemaDefinition
import com.stripe.android.uicore.address.CountryAddressSchema
import com.stripe.android.uicore.address.FieldSchema
import com.stripe.android.uicore.address.FieldType
import com.stripe.android.uicore.address.NameType
import kotlin.String
import kotlin.collections.List

internal object IeAddressSchemaDefinition : AddressSchemaDefinition {
    override val countryCode: String = "IE"

    override fun schemaElements(): List<CountryAddressSchema> = listOf(
        CountryAddressSchema(
            type = FieldType.AddressLine1,
            required = true,
            schema = null,
        ),
        CountryAddressSchema(
            type = FieldType.AddressLine2,
            required = false,
            schema = null,
        ),
        CountryAddressSchema(
            type = FieldType.DependentLocality,
            required = false,
            schema = FieldSchema(
                nameType = NameType.Townload,
                isNumeric = false,
            ),
        ),
        CountryAddressSchema(
            type = FieldType.Locality,
            required = true,
            schema = FieldSchema(
                nameType = NameType.City,
                isNumeric = false,
            ),
        ),
        CountryAddressSchema(
            type = FieldType.AdministrativeArea,
            required = false,
            schema = FieldSchema(
                nameType = NameType.County,
                isNumeric = false,
            ),
        ),
        CountryAddressSchema(
            type = FieldType.PostalCode,
            required = false,
            schema = FieldSchema(
                nameType = NameType.Eircode,
                isNumeric = false,
            ),
        ),
    )
}
