/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.elements;

import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.unit.LayoutDirection;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.uicore.R;
import com.stripe.android.uicore.elements.ConvertTo4DigitDateKt;
import com.stripe.android.uicore.elements.ExpiryDateVisualTransformation;
import com.stripe.android.uicore.elements.TextFieldConfig;
import com.stripe.android.uicore.elements.TextFieldIcon;
import com.stripe.android.uicore.elements.TextFieldState;
import com.stripe.android.uicore.elements.TextFieldStateConstants;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nH\u0016J\u0010\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nH\u0016J\u0010\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\nH\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\nH\u0016R\u0016\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u001eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&\u00a8\u00063"}, d2={"Lcom/stripe/android/uicore/elements/DateConfig;", "Lcom/stripe/android/uicore/elements/TextFieldConfig;", "<init>", "()V", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "", "getDebugLabel", "()Ljava/lang/String;", "label", "", "getLabel", "()Ljava/lang/Integer;", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboard-PjHm6EE", "visualTransformation", "Lcom/stripe/android/uicore/elements/ExpiryDateVisualTransformation;", "getVisualTransformation", "()Lcom/stripe/android/uicore/elements/ExpiryDateVisualTransformation;", "trailingIcon", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/uicore/elements/TextFieldIcon;", "getTrailingIcon", "()Lkotlinx/coroutines/flow/StateFlow;", "loading", "", "getLoading", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "shouldAnnounceFieldValue", "getShouldAnnounceFieldValue", "()Z", "shouldAnnounceLabel", "getShouldAnnounceLabel", "filter", "userTyped", "convertToRaw", "displayName", "convertFromRaw", "rawValue", "determineState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "input", "Companion", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDateConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateConfig.kt\ncom/stripe/android/uicore/elements/DateConfig\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,94:1\n434#2:95\n507#2,5:96\n*S KotlinDebug\n*F\n+ 1 DateConfig.kt\ncom/stripe/android/uicore/elements/DateConfig\n*L\n31#1:95\n31#1:96,5\n*E\n"})
public final class DateConfig
implements TextFieldConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int capitalization = KeyboardCapitalization.Companion.getNone-IUNYP9k();
    @NotNull
    private final String debugLabel;
    @StringRes
    private final int label = R.string.stripe_expiration_date_hint;
    private final int keyboard = KeyboardType.Companion.getNumberPassword-PjHm6EE();
    @NotNull
    private final ExpiryDateVisualTransformation visualTransformation = new ExpiryDateVisualTransformation(null, 1, null);
    @NotNull
    private final StateFlow<TextFieldIcon> trailingIcon = (StateFlow)StateFlowKt.MutableStateFlow(null);
    @NotNull
    private final StateFlow<Boolean> loading = (StateFlow)StateFlowKt.MutableStateFlow((Object)false);
    @NotNull
    private final LayoutDirection layoutDirection = LayoutDirection.Ltr;
    private final boolean shouldAnnounceFieldValue;
    private final boolean shouldAnnounceLabel;
    public static final int $stable = 8;

    public DateConfig() {
        this.debugLabel = "date";
    }

    @Override
    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    @NotNull
    public Integer getLabel() {
        return this.label;
    }

    @Override
    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @Override
    @NotNull
    public ExpiryDateVisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    @Override
    @NotNull
    public StateFlow<TextFieldIcon> getTrailingIcon() {
        return this.trailingIcon;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> getLoading() {
        return this.loading;
    }

    @Override
    @NotNull
    public LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    @Override
    public boolean getShouldAnnounceFieldValue() {
        return this.shouldAnnounceFieldValue;
    }

    @Override
    public boolean getShouldAnnounceLabel() {
        return this.shouldAnnounceLabel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String filter(@NotNull String userTyped) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        String $this$filter$iv = userTyped;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return ((StringBuilder)destination$iv$iv).toString();
    }

    @Override
    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        return rawValue;
    }

    @Override
    @NotNull
    public TextFieldState determineState(@NotNull String input) {
        TextFieldState textFieldState;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (StringsKt.isBlank((CharSequence)input)) {
            textFieldState = TextFieldStateConstants.Error.Blank.INSTANCE;
        } else {
            String newString = ConvertTo4DigitDateKt.convertTo4DigitDate(input);
            if (newString.length() < 4) {
                textFieldState = new TextFieldStateConstants.Error.Incomplete(R.string.stripe_incomplete_expiry_date);
            } else if (newString.length() > 4) {
                textFieldState = new TextFieldStateConstants.Error.Invalid(R.string.stripe_incomplete_expiry_date, null, false, 6, null);
            } else {
                Integer n = StringsKt.toIntOrNull((String)StringsKt.take((String)newString, (int)2));
                if (n == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                Integer n2 = StringsKt.toIntOrNull((String)StringsKt.takeLast((String)newString, (int)2));
                if (n2 == null) {
                    String string3 = "Required value was null.";
                    throw new IllegalArgumentException(string3.toString());
                }
                textFieldState = Companion.determineTextFieldState(((Number)n).intValue(), ((Number)n2).intValue(), Calendar.getInstance().get(2) + 1, Calendar.getInstance().get(1));
            }
        }
        return textFieldState;
    }

    @Override
    @Nullable
    public String getPlaceHolder() {
        return TextFieldConfig.DefaultImpls.getPlaceHolder(this);
    }

    @Override
    @Nullable
    public Function1<String, ResolvableString> getOverrideContentDescriptionProvider() {
        return TextFieldConfig.DefaultImpls.getOverrideContentDescriptionProvider(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/uicore/elements/DateConfig$Companion;", "", "<init>", "()V", "determineTextFieldState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "month1Based", "", "twoDigitYear", "current1BasedMonth", "currentYear", "stripe-ui-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final TextFieldState determineTextFieldState(int month1Based, int twoDigitYear, int current1BasedMonth, int currentYear) {
            boolean isMonthInvalid;
            boolean isExpiredMonth;
            int twoDigitCurrentYear = currentYear % 100;
            boolean isExpiredYear = twoDigitYear - twoDigitCurrentYear < 0;
            boolean isYearTooLarge = twoDigitYear - twoDigitCurrentYear > 50;
            boolean bl = isExpiredMonth = twoDigitYear - twoDigitCurrentYear == 0 && current1BasedMonth > month1Based;
            boolean bl2 = isMonthInvalid = !(1 <= month1Based ? month1Based < 13 : false);
            return isExpiredYear ? (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_invalid_expiry_year, null, true, 2, null) : (isYearTooLarge ? (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_invalid_expiry_year, null, true, 2, null) : (isExpiredMonth ? (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_invalid_expiry_month, null, true, 2, null) : (isMonthInvalid ? (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.stripe_invalid_expiry_month) : (TextFieldState)TextFieldStateConstants.Valid.Full.INSTANCE)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

