/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal;

import android.content.Context;
import androidx.annotation.RequiresPermission;
import com.stripe.core.bbpos.dagger.BbposSdkModule;
import com.stripe.core.stripeterminal.storage.EventEntity;
import com.stripe.core.stripeterminal.storage.LogPointEntity;
import com.stripe.core.stripeterminal.storage.StripeTerminalDatabase;
import com.stripe.core.stripeterminal.storage.TraceEntity;
import com.stripe.jvmcore.clientlogger.dagger.ClientLoggerDispatcherModule;
import com.stripe.jvmcore.logging.dagger.MetricLoggerCollectorModule;
import com.stripe.jvmcore.logging.dagger.TraceLoggerCollectorModule;
import com.stripe.jvmcore.logging.terminal.dagger.LogLevelModule;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.logging.terminal.log.LogFlusher;
import com.stripe.jvmcore.logging.terminal.log.SimpleLogger;
import com.stripe.loggingmodels.ApplicationTrace;
import com.stripe.loggingmodels.ApplicationTraceResult;
import com.stripe.stripeterminal.DaggerTerminalComponent;
import com.stripe.stripeterminal.Terminal;
import com.stripe.stripeterminal.TerminalApplicationDelegate;
import com.stripe.stripeterminal.TerminalComponent;
import com.stripe.stripeterminal.TerminalExtensionsKt;
import com.stripe.stripeterminal.dagger.ContextModule;
import com.stripe.stripeterminal.dagger.OfflineModule;
import com.stripe.stripeterminal.dagger.TerminalModule;
import com.stripe.stripeterminal.external.OfflineMode;
import com.stripe.stripeterminal.external.callable.Callback;
import com.stripe.stripeterminal.external.callable.Cancelable;
import com.stripe.stripeterminal.external.callable.CollectInputsResultCallback;
import com.stripe.stripeterminal.external.callable.CollectedDataCallback;
import com.stripe.stripeterminal.external.callable.ConnectionTokenProvider;
import com.stripe.stripeterminal.external.callable.DiscoveryListener;
import com.stripe.stripeterminal.external.callable.HandoffReaderListener;
import com.stripe.stripeterminal.external.callable.LocationListCallback;
import com.stripe.stripeterminal.external.callable.OfflineListener;
import com.stripe.stripeterminal.external.callable.PaymentIntentCallback;
import com.stripe.stripeterminal.external.callable.ReaderCallback;
import com.stripe.stripeterminal.external.callable.ReaderListener;
import com.stripe.stripeterminal.external.callable.ReaderSettingsCallback;
import com.stripe.stripeterminal.external.callable.RefundCallback;
import com.stripe.stripeterminal.external.callable.SetupIntentCallback;
import com.stripe.stripeterminal.external.callable.TerminalListener;
import com.stripe.stripeterminal.external.models.Cart;
import com.stripe.stripeterminal.external.models.CollectConfiguration;
import com.stripe.stripeterminal.external.models.CollectDataConfiguration;
import com.stripe.stripeterminal.external.models.CollectInputsParameters;
import com.stripe.stripeterminal.external.models.ConfirmConfiguration;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.ConnectionStatus;
import com.stripe.stripeterminal.external.models.CreateConfiguration;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.DiscoveryConfiguration;
import com.stripe.stripeterminal.external.models.ListLocationsParameters;
import com.stripe.stripeterminal.external.models.LocalMobileUxConfiguration;
import com.stripe.stripeterminal.external.models.OfflineStatus;
import com.stripe.stripeterminal.external.models.PaymentIntent;
import com.stripe.stripeterminal.external.models.PaymentIntentParameters;
import com.stripe.stripeterminal.external.models.PaymentStatus;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.ReaderSettingsParameters;
import com.stripe.stripeterminal.external.models.ReaderSupportResult;
import com.stripe.stripeterminal.external.models.RefundConfiguration;
import com.stripe.stripeterminal.external.models.RefundParameters;
import com.stripe.stripeterminal.external.models.SetupIntent;
import com.stripe.stripeterminal.external.models.SetupIntentCancellationParameters;
import com.stripe.stripeterminal.external.models.SetupIntentConfiguration;
import com.stripe.stripeterminal.external.models.SetupIntentParameters;
import com.stripe.stripeterminal.external.models.SimulatorConfiguration;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.LocationHandler;
import com.stripe.stripeterminal.internal.common.adapter.CotsAdapter;
import com.stripe.stripeterminal.internal.common.callable.ProxyDiscoveryListener;
import com.stripe.stripeterminal.internal.common.log.SdkRequest;
import com.stripe.stripeterminal.internal.common.log.SdkResponse;
import com.stripe.stripeterminal.internal.common.storage.DatabaseProvider;
import com.stripe.stripeterminal.internal.common.terminalsession.TerminalSession;
import com.stripe.stripeterminal.log.LogLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 |2\u00020\u0001:\u0001|B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020)J\u0006\u0010*\u001a\u00020\u001fJ\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020,J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\"\u001a\u000201J\u0016\u00102\u001a\u00020.2\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u000205J \u00106\u001a\u00020.2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010/\u001a\u000207J\"\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:2\b\b\u0002\u0010/\u001a\u00020;2\u0006\u0010\"\u001a\u00020,H\u0007J*\u0010<\u001a\u00020.2\u0006\u0010 \u001a\u00020&2\u0006\u0010=\u001a\u00020>2\b\b\u0002\u0010/\u001a\u00020?2\u0006\u0010\"\u001a\u00020)H\u0007J\"\u0010@\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010/\u001a\u00020AH\u0007J\u000e\u0010B\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020CJ\u0016\u0010D\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020&2\u0006\u0010\"\u001a\u00020)J(\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010/\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020KJ(\u0010L\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010/\u001a\u00020M2\b\u0010H\u001a\u0004\u0018\u00010N2\u0006\u0010J\u001a\u00020KJ\u001e\u0010O\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010/\u001a\u00020P2\u0006\u0010J\u001a\u00020KJ\u001e\u0010Q\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010/\u001a\u00020R2\u0006\u0010J\u001a\u00020KJ(\u0010S\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010/\u001a\u00020T2\b\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020KJ\u0016\u0010U\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020V2\u0006\u0010\"\u001a\u00020#J\"\u0010U\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020V2\u0006\u0010\"\u001a\u00020#2\b\u0010W\u001a\u0004\u0018\u00010XH\u0007J\u0016\u0010Y\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020Z2\u0006\u0010\"\u001a\u00020)J\"\u0010Y\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020Z2\u0006\u0010\"\u001a\u00020)2\b\u0010W\u001a\u0004\u0018\u00010XH\u0007J\u000e\u0010[\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020,J \u0010\\\u001a\u00020.2\u0006\u0010/\u001a\u00020]2\u0006\u0010^\u001a\u00020_2\u0006\u0010\"\u001a\u00020,H\u0007J\u000e\u0010`\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020aJ\u0006\u0010b\u001a\u00020\u001fJ\u0016\u0010c\u001a\u00020\u001f2\u0006\u0010d\u001a\u00020e2\u0006\u0010\"\u001a\u00020fJ\u000e\u0010g\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020,J\u0016\u0010h\u001a\u00020\u001f2\u0006\u0010i\u001a\u00020j2\u0006\u0010\"\u001a\u00020#J\u0016\u0010k\u001a\u00020\u001f2\u0006\u0010i\u001a\u00020j2\u0006\u0010\"\u001a\u00020)J\u000e\u0010l\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020mJ\u0010\u0010n\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020oH\u0007J\u0016\u0010p\u001a\u00020\u001f2\u0006\u0010q\u001a\u00020r2\u0006\u0010\"\u001a\u00020,J\u0016\u0010s\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020t2\u0006\u0010\"\u001a\u00020aJ\u000e\u0010u\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020vJ\u0016\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020]R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lcom/stripe/stripeterminal/Terminal;", "", "terminalSession", "Lcom/stripe/stripeterminal/internal/common/terminalsession/TerminalSession;", "(Lcom/stripe/stripeterminal/internal/common/terminalsession/TerminalSession;)V", "connectedReader", "Lcom/stripe/stripeterminal/external/models/Reader;", "getConnectedReader", "()Lcom/stripe/stripeterminal/external/models/Reader;", "connectionStatus", "Lcom/stripe/stripeterminal/external/models/ConnectionStatus;", "getConnectionStatus", "()Lcom/stripe/stripeterminal/external/models/ConnectionStatus;", "offlineStatus", "Lcom/stripe/stripeterminal/external/models/OfflineStatus;", "getOfflineStatus$annotations", "()V", "getOfflineStatus", "()Lcom/stripe/stripeterminal/external/models/OfflineStatus;", "paymentStatus", "Lcom/stripe/stripeterminal/external/models/PaymentStatus;", "getPaymentStatus", "()Lcom/stripe/stripeterminal/external/models/PaymentStatus;", "value", "Lcom/stripe/stripeterminal/external/models/SimulatorConfiguration;", "simulatorConfiguration", "getSimulatorConfiguration", "()Lcom/stripe/stripeterminal/external/models/SimulatorConfiguration;", "setSimulatorConfiguration", "(Lcom/stripe/stripeterminal/external/models/SimulatorConfiguration;)V", "cancelPaymentIntent", "", "intent", "Lcom/stripe/stripeterminal/external/models/PaymentIntent;", "callback", "Lcom/stripe/stripeterminal/external/callable/PaymentIntentCallback;", "cancelSetupIntent", "setupIntent", "Lcom/stripe/stripeterminal/external/models/SetupIntent;", "params", "Lcom/stripe/stripeterminal/external/models/SetupIntentCancellationParameters;", "Lcom/stripe/stripeterminal/external/callable/SetupIntentCallback;", "clearCachedCredentials", "clearReaderDisplay", "Lcom/stripe/stripeterminal/external/callable/Callback;", "collectData", "Lcom/stripe/stripeterminal/external/callable/Cancelable;", "config", "Lcom/stripe/stripeterminal/external/models/CollectDataConfiguration;", "Lcom/stripe/stripeterminal/external/callable/CollectedDataCallback;", "collectInputs", "collectInputsParameters", "Lcom/stripe/stripeterminal/external/models/CollectInputsParameters;", "Lcom/stripe/stripeterminal/external/callable/CollectInputsResultCallback;", "collectPaymentMethod", "Lcom/stripe/stripeterminal/external/models/CollectConfiguration;", "collectRefundPaymentMethod", "refundParams", "Lcom/stripe/stripeterminal/external/models/RefundParameters;", "Lcom/stripe/stripeterminal/external/models/RefundConfiguration;", "collectSetupIntentPaymentMethod", "customerConsentCollected", "", "Lcom/stripe/stripeterminal/external/models/SetupIntentConfiguration;", "confirmPaymentIntent", "Lcom/stripe/stripeterminal/external/models/ConfirmConfiguration;", "confirmRefund", "Lcom/stripe/stripeterminal/external/callable/RefundCallback;", "confirmSetupIntent", "connectBluetoothReader", "reader", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration$BluetoothConnectionConfiguration;", "listener", "Lcom/stripe/stripeterminal/external/callable/ReaderListener;", "connectionCallback", "Lcom/stripe/stripeterminal/external/callable/ReaderCallback;", "connectHandoffReader", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration$HandoffConnectionConfiguration;", "Lcom/stripe/stripeterminal/external/callable/HandoffReaderListener;", "connectInternetReader", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration$InternetConnectionConfiguration;", "connectLocalMobileReader", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration$LocalMobileConnectionConfiguration;", "connectUsbReader", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration$UsbConnectionConfiguration;", "createPaymentIntent", "Lcom/stripe/stripeterminal/external/models/PaymentIntentParameters;", "createConfiguration", "Lcom/stripe/stripeterminal/external/models/CreateConfiguration;", "createSetupIntent", "Lcom/stripe/stripeterminal/external/models/SetupIntentParameters;", "disconnectReader", "discoverReaders", "Lcom/stripe/stripeterminal/external/models/DiscoveryConfiguration;", "discoveryListener", "Lcom/stripe/stripeterminal/external/callable/DiscoveryListener;", "getReaderSettings", "Lcom/stripe/stripeterminal/external/callable/ReaderSettingsCallback;", "installAvailableUpdate", "listLocations", "parameters", "Lcom/stripe/stripeterminal/external/models/ListLocationsParameters;", "Lcom/stripe/stripeterminal/external/callable/LocationListCallback;", "rebootReader", "retrievePaymentIntent", "clientSecret", "", "retrieveSetupIntent", "setLocalMobileUxConfiguration", "Lcom/stripe/stripeterminal/external/models/LocalMobileUxConfiguration;", "setOfflineListener", "Lcom/stripe/stripeterminal/external/callable/OfflineListener;", "setReaderDisplay", "cart", "Lcom/stripe/stripeterminal/external/models/Cart;", "setReaderSettings", "Lcom/stripe/stripeterminal/external/models/ReaderSettingsParameters;", "setTerminalListener", "Lcom/stripe/stripeterminal/external/callable/TerminalListener;", "supportsReadersOfType", "Lcom/stripe/stripeterminal/external/models/ReaderSupportResult;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "discoveryConfiguration", "Companion", "core_publish"})
public final class Terminal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalSession terminalSession;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(Terminal.class);
    private static final long FLUSH_PENDING_LOGS_MS = 60000L;
    private static final long AUTO_SUBMIT_LOGS_MS = 300000L;
    @NotNull
    private static final CompletableJob initCoroutineContext = SupervisorKt.SupervisorJob$default(null, (int)1, null);
    @NotNull
    private static final String IDENTIFIER = "sdk_init";
    @NotNull
    private static final String METRICS_FILE_NAME = "terminal_sdk_wire_metrics";
    @NotNull
    private static final String EVENTS_FILE_NAME = "terminal_sdk_wire_events";
    @NotNull
    private static final String LEGACY_TRACES_FILE_NAME = "terminal_sdk_wire_traces";
    @NotNull
    private static final String TRACES_FILE_NAME = "terminal_sdk_wire_traces_2";
    @Nullable
    private static LocationHandler locationHandler;
    @Nullable
    private static LogFlusher logFlusher;
    @NotNull
    private static final List<ExecutorService> executors;
    @Nullable
    private static Terminal instance;

    public Terminal(@NotNull TerminalSession terminalSession) {
        Intrinsics.checkNotNullParameter((Object)terminalSession, (String)"terminalSession");
        this.terminalSession = terminalSession;
    }

    @NotNull
    public final ConnectionStatus getConnectionStatus() {
        return this.terminalSession.getConnectionStatus();
    }

    @NotNull
    public final PaymentStatus getPaymentStatus() {
        return this.terminalSession.getPaymentStatus();
    }

    @Nullable
    public final Reader getConnectedReader() {
        return this.terminalSession.getConnectedReader();
    }

    @NotNull
    public final OfflineStatus getOfflineStatus() {
        return (OfflineStatus)this.terminalSession.getOfflineStatusStateFlow().getValue();
    }

    @OfflineMode
    public static /* synthetic */ void getOfflineStatus$annotations() {
    }

    @NotNull
    public final SimulatorConfiguration getSimulatorConfiguration() {
        return this.terminalSession.getSimulatorConfiguration();
    }

    public final void setSimulatorConfiguration(@NotNull SimulatorConfiguration value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.terminalSession.setSimulatorConfiguration(value);
    }

    public final void setTerminalListener(@NotNull TerminalListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        LOGGER.d("setTerminalListener", new Pair[0]);
        this.terminalSession.setTerminalListener(listener);
    }

    public final void cancelPaymentIntent(@NotNull PaymentIntent intent, @NotNull PaymentIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("cancelPaymentIntent", new Pair[0]);
        this.terminalSession.cancelPaymentIntent(intent, callback);
    }

    public final void clearCachedCredentials() {
        LOGGER.d("clearCachedCredentials", new Pair[0]);
        this.terminalSession.clearCachedCredentials();
    }

    public final void clearReaderDisplay(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("clearReaderDisplay", new Pair[0]);
        this.terminalSession.clearReaderDisplay(callback);
    }

    @NotNull
    public final Cancelable collectPaymentMethod(@NotNull PaymentIntent intent, @NotNull PaymentIntentCallback callback, @NotNull CollectConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"config", (Object)config)};
        LOGGER.d("collectPaymentMethod", pairArray);
        return this.terminalSession.collectPaymentMethod(intent, callback, config);
    }

    public static /* synthetic */ Cancelable collectPaymentMethod$default(Terminal terminal, PaymentIntent paymentIntent, PaymentIntentCallback paymentIntentCallback, CollectConfiguration collectConfiguration, int n, Object object) {
        if ((n & 4) != 0) {
            collectConfiguration = new CollectConfiguration.Builder().build();
        }
        return terminal.collectPaymentMethod(paymentIntent, paymentIntentCallback, collectConfiguration);
    }

    public final void listLocations(@NotNull ListLocationsParameters parameters, @NotNull LocationListCallback callback) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("listLocations", new Pair[0]);
        this.terminalSession.listLocations(parameters, callback);
    }

    @JvmOverloads
    @NotNull
    public final Cancelable collectRefundPaymentMethod(@NotNull RefundParameters refundParams, @NotNull RefundConfiguration config, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)refundParams, (String)"refundParams");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"config", (Object)config)};
        LOGGER.d("collectRefundPaymentMethod", pairArray);
        return this.terminalSession.collectRefundPaymentMethod(refundParams, config, callback);
    }

    public static /* synthetic */ Cancelable collectRefundPaymentMethod$default(Terminal terminal, RefundParameters refundParameters, RefundConfiguration refundConfiguration, Callback callback, int n, Object object) {
        if ((n & 2) != 0) {
            refundConfiguration = new RefundConfiguration.Builder().build();
        }
        return terminal.collectRefundPaymentMethod(refundParameters, refundConfiguration, callback);
    }

    public final void retrieveSetupIntent(@NotNull String clientSecret, @NotNull SetupIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("retrieveSetupIntent", new Pair[0]);
        this.terminalSession.retrieveSetupIntent(clientSecret, callback);
    }

    @JvmOverloads
    @NotNull
    public final Cancelable collectSetupIntentPaymentMethod(@NotNull SetupIntent intent, boolean customerConsentCollected, @NotNull SetupIntentConfiguration config, @NotNull SetupIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"config", (Object)config)};
        LOGGER.d("collectSetupIntentPaymentMethod", pairArray);
        return this.terminalSession.collectSetupIntentPaymentMethod(intent, customerConsentCollected, config, callback);
    }

    public static /* synthetic */ Cancelable collectSetupIntentPaymentMethod$default(Terminal terminal, SetupIntent setupIntent, boolean bl, SetupIntentConfiguration setupIntentConfiguration, SetupIntentCallback setupIntentCallback, int n, Object object) {
        if ((n & 4) != 0) {
            setupIntentConfiguration = new SetupIntentConfiguration.Builder().build();
        }
        return terminal.collectSetupIntentPaymentMethod(setupIntent, bl, setupIntentConfiguration, setupIntentCallback);
    }

    public final void confirmSetupIntent(@NotNull SetupIntent intent, @NotNull SetupIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("confirmSetupIntent", new Pair[0]);
        this.terminalSession.confirmSetupIntent(intent, callback);
    }

    public final void connectLocalMobileReader(@NotNull Reader reader, @NotNull ConnectionConfiguration.LocalMobileConnectionConfiguration config, @NotNull ReaderCallback connectionCallback) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)connectionCallback, (String)"connectionCallback");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"serial_number", (Object)reader.getSerialNumber())};
        LOGGER.d("connectLocalMobileReader", pairArray);
        this.terminalSession.connectLocalMobileReader(reader, config, connectionCallback);
    }

    public final void connectBluetoothReader(@NotNull Reader reader, @NotNull ConnectionConfiguration.BluetoothConnectionConfiguration config, @Nullable ReaderListener listener, @NotNull ReaderCallback connectionCallback) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)connectionCallback, (String)"connectionCallback");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"serial_number", (Object)reader.getSerialNumber())};
        LOGGER.d("connectBluetoothReader", pairArray);
        this.terminalSession.connectBluetoothReader(reader, config, listener, connectionCallback);
    }

    public final void connectUsbReader(@NotNull Reader reader, @NotNull ConnectionConfiguration.UsbConnectionConfiguration config, @Nullable ReaderListener listener, @NotNull ReaderCallback connectionCallback) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)connectionCallback, (String)"connectionCallback");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"serial_number", (Object)reader.getSerialNumber())};
        LOGGER.d("connectUsbReader", pairArray);
        this.terminalSession.connectUsbReader(reader, config, listener, connectionCallback);
    }

    public final void connectInternetReader(@NotNull Reader reader, @NotNull ConnectionConfiguration.InternetConnectionConfiguration config, @NotNull ReaderCallback connectionCallback) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)connectionCallback, (String)"connectionCallback");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"serial_number", (Object)reader.getSerialNumber())};
        LOGGER.d("connectInternetReader", pairArray);
        this.terminalSession.connectInternetReader(reader, config, connectionCallback);
    }

    public final void connectHandoffReader(@NotNull Reader reader, @NotNull ConnectionConfiguration.HandoffConnectionConfiguration config, @Nullable HandoffReaderListener listener, @NotNull ReaderCallback connectionCallback) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)connectionCallback, (String)"connectionCallback");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"serial_number", (Object)reader.getSerialNumber())};
        LOGGER.d("connectHandoffReader", pairArray);
        this.terminalSession.connectHandoffReader(reader, config, listener, connectionCallback);
    }

    public final void createPaymentIntent(@NotNull PaymentIntentParameters params, @NotNull PaymentIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("createPaymentIntent", new Pair[0]);
        this.terminalSession.createPaymentIntent(params, callback);
    }

    @OfflineMode
    public final void createPaymentIntent(@NotNull PaymentIntentParameters params, @NotNull PaymentIntentCallback callback, @Nullable CreateConfiguration createConfiguration) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("createPaymentIntent", new Pair[0]);
        this.terminalSession.createPaymentIntent(params, callback, createConfiguration);
    }

    public final void createSetupIntent(@NotNull SetupIntentParameters params, @NotNull SetupIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("createSetupIntent", new Pair[0]);
        this.terminalSession.createSetupIntent(params, callback, null);
    }

    @OfflineMode
    public final void createSetupIntent(@NotNull SetupIntentParameters params, @NotNull SetupIntentCallback callback, @Nullable CreateConfiguration createConfiguration) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("createSetupIntent", new Pair[0]);
        this.terminalSession.createSetupIntent(params, callback, createConfiguration);
    }

    public final void cancelSetupIntent(@NotNull SetupIntent setupIntent, @NotNull SetupIntentCancellationParameters params, @NotNull SetupIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)setupIntent, (String)"setupIntent");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("cancelSetupIntent", new Pair[0]);
        this.terminalSession.cancelSetupIntent(setupIntent, params, callback);
    }

    public final void rebootReader(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("rebootReader", new Pair[0]);
        this.terminalSession.rebootReader(callback);
    }

    public final void disconnectReader(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("disconnectReader", new Pair[0]);
        this.terminalSession.disconnectReader(callback);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NotNull
    public final Cancelable discoverReaders(@NotNull DiscoveryConfiguration config, @NotNull DiscoveryListener discoveryListener, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)discoveryListener, (String)"discoveryListener");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("discoverReaders", new Pair[0]);
        return this.terminalSession.discoverReaders(config, (DiscoveryListener)new ProxyDiscoveryListener(discoveryListener), callback);
    }

    @JvmOverloads
    public final void confirmPaymentIntent(@NotNull PaymentIntent intent, @NotNull PaymentIntentCallback callback, @NotNull ConfirmConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        LOGGER.d("confirmPaymentIntent", new Pair[0]);
        this.terminalSession.confirmPaymentIntent(intent, callback, config);
    }

    public static /* synthetic */ void confirmPaymentIntent$default(Terminal terminal, PaymentIntent paymentIntent, PaymentIntentCallback paymentIntentCallback, ConfirmConfiguration confirmConfiguration, int n, Object object) {
        if ((n & 4) != 0) {
            confirmConfiguration = new ConfirmConfiguration.Builder().build();
        }
        terminal.confirmPaymentIntent(paymentIntent, paymentIntentCallback, confirmConfiguration);
    }

    public final void confirmRefund(@NotNull RefundCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("confirmRefund", new Pair[0]);
        this.terminalSession.confirmRefund(callback);
    }

    public final void retrievePaymentIntent(@NotNull String clientSecret, @NotNull PaymentIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("retrievePaymentIntent", new Pair[0]);
        this.terminalSession.retrievePaymentIntent(clientSecret, callback);
    }

    public final void setReaderDisplay(@NotNull Cart cart, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)cart, (String)"cart");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("setReaderDisplay", new Pair[0]);
        this.terminalSession.setReaderDisplay(cart, callback);
    }

    @NotNull
    public final Cancelable collectInputs(@NotNull CollectInputsParameters collectInputsParameters, @NotNull CollectInputsResultCallback callback) {
        Intrinsics.checkNotNullParameter((Object)collectInputsParameters, (String)"collectInputsParameters");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("collectInputs", new Pair[0]);
        return this.terminalSession.collectInputs(collectInputsParameters, callback);
    }

    @NotNull
    public final Cancelable collectData(@NotNull CollectDataConfiguration config, @NotNull CollectedDataCallback callback) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("collectData", new Pair[0]);
        return this.terminalSession.collectData(config, callback);
    }

    @NotNull
    public final ReaderSupportResult supportsReadersOfType(@NotNull DeviceType deviceType, @NotNull DiscoveryConfiguration discoveryConfiguration) {
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Intrinsics.checkNotNullParameter((Object)discoveryConfiguration, (String)"discoveryConfiguration");
        LOGGER.d("supportsReaderOfType", new Pair[0]);
        return this.terminalSession.supportsReadersOfType(deviceType, discoveryConfiguration);
    }

    public final void installAvailableUpdate() {
        LOGGER.d("installAvailableUpdate", new Pair[0]);
        this.terminalSession.installAvailableUpdate();
    }

    @OfflineMode
    public final void setOfflineListener(@NotNull OfflineListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        LOGGER.d("setOfflineListener", new Pair[0]);
        this.terminalSession.setOfflineListener(listener);
    }

    public final void setReaderSettings(@NotNull ReaderSettingsParameters params, @NotNull ReaderSettingsCallback callback) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("setReaderSettings", new Pair[0]);
        this.terminalSession.setReaderSettings(params, callback);
    }

    public final void setLocalMobileUxConfiguration(@NotNull LocalMobileUxConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        LOGGER.d("setLocalMobileUxConfiguration", new Pair[0]);
        this.terminalSession.setLocalMobileUxConfiguration(config);
    }

    public final void getReaderSettings(@NotNull ReaderSettingsCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LOGGER.d("getReaderSettings", new Pair[0]);
        this.terminalSession.getReaderSettings(callback);
    }

    @JvmOverloads
    @NotNull
    public final Cancelable collectRefundPaymentMethod(@NotNull RefundParameters refundParams, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)refundParams, (String)"refundParams");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return Terminal.collectRefundPaymentMethod$default(this, refundParams, null, callback, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Cancelable collectSetupIntentPaymentMethod(@NotNull SetupIntent intent, boolean customerConsentCollected, @NotNull SetupIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return Terminal.collectSetupIntentPaymentMethod$default(this, intent, customerConsentCollected, null, callback, 4, null);
    }

    @JvmOverloads
    public final void confirmPaymentIntent(@NotNull PaymentIntent intent, @NotNull PaymentIntentCallback callback) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Terminal.confirmPaymentIntent$default(this, intent, callback, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initTerminal(@NotNull Context context, @NotNull LogLevel logLevel, @NotNull ConnectionTokenProvider tokenProvider, @NotNull TerminalListener listener) throws TerminalException {
        Companion.initTerminal(context, logLevel, tokenProvider, listener);
    }

    @JvmStatic
    @OfflineMode
    public static final void initTerminal(@NotNull Context context, @NotNull LogLevel logLevel, @NotNull ConnectionTokenProvider tokenProvider, @NotNull TerminalListener listener, @Nullable OfflineListener offlineListener) throws TerminalException {
        Companion.initTerminal(context, logLevel, tokenProvider, listener, offlineListener);
    }

    @JvmStatic
    public static final boolean isInitialized() {
        return Companion.isInitialized();
    }

    @JvmStatic
    @NotNull
    public static final Terminal getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @JvmOverloads
    public static final void initTerminal(@NotNull Context context, @NotNull ConnectionTokenProvider tokenProvider, @NotNull TerminalListener listener) throws TerminalException {
        Companion.initTerminal(context, tokenProvider, listener);
    }

    static {
        executors = new ArrayList();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\r\u0010\u001b\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0014H\u0007J*\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0007J4\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0007J\b\u0010)\u001a\u00020*H\u0007J\r\u0010+\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b,J\r\u0010-\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b0J\b\u00101\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/stripe/stripeterminal/Terminal$Companion;", "", "()V", "AUTO_SUBMIT_LOGS_MS", "", "EVENTS_FILE_NAME", "", "FLUSH_PENDING_LOGS_MS", "IDENTIFIER", "LEGACY_TRACES_FILE_NAME", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "METRICS_FILE_NAME", "TRACES_FILE_NAME", "executors", "", "Ljava/util/concurrent/ExecutorService;", "initCoroutineContext", "Lkotlinx/coroutines/CompletableJob;", "instance", "Lcom/stripe/stripeterminal/Terminal;", "locationHandler", "Lcom/stripe/stripeterminal/internal/common/LocationHandler;", "logFlusher", "Lcom/stripe/jvmcore/logging/terminal/log/LogFlusher;", "checkAppDelegateInitialized", "", "destroyTerminal", "destroyTerminal$core_publish", "getInstance", "initTerminal", "context", "Landroid/content/Context;", "logLevel", "Lcom/stripe/stripeterminal/log/LogLevel;", "tokenProvider", "Lcom/stripe/stripeterminal/external/callable/ConnectionTokenProvider;", "listener", "Lcom/stripe/stripeterminal/external/callable/TerminalListener;", "offlineListener", "Lcom/stripe/stripeterminal/external/callable/OfflineListener;", "isInitialized", "", "pauseTerminal", "pauseTerminal$core_publish", "resumeTerminal", "resumeTerminal$core_publish", "startTerminal", "startTerminal$core_publish", "submitStoredLogEvents", "core_publish"})
    @SourceDebugExtension(value={"SMAP\nTerminal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Terminal.kt\ncom/stripe/stripeterminal/Terminal$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1182:1\n1855#2,2:1183\n*S KotlinDebug\n*F\n+ 1 Terminal.kt\ncom/stripe/stripeterminal/Terminal$Companion\n*L\n1161#1:1183,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void initTerminal(@NotNull Context context, @NotNull LogLevel logLevel, @NotNull ConnectionTokenProvider tokenProvider, @NotNull TerminalListener listener) throws TerminalException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
            Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.initTerminal(context, logLevel, tokenProvider, listener, null);
        }

        public static /* synthetic */ void initTerminal$default(Companion companion, Context context, LogLevel logLevel, ConnectionTokenProvider connectionTokenProvider, TerminalListener terminalListener, int n, Object object) throws TerminalException {
            if ((n & 2) != 0) {
                logLevel = LogLevel.NONE;
            }
            companion.initTerminal(context, logLevel, connectionTokenProvider, terminalListener);
        }

        @JvmStatic
        @OfflineMode
        public final void initTerminal(@NotNull Context context, @NotNull LogLevel logLevel, @NotNull ConnectionTokenProvider tokenProvider, @NotNull TerminalListener listener, @Nullable OfflineListener offlineListener) throws TerminalException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
            Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            if (!(instance == null)) {
                boolean $i$a$-check-Terminal$Companion$initTerminal$22 = false;
                String $i$a$-check-Terminal$Companion$initTerminal$22 = "You can only call initTerminal *before* requesting the Terminal instance for the first time. If you are trying to switch accounts in your app, refer to the documentation for the `clearCachedCredentials` method.";
                throw new IllegalStateException($i$a$-check-Terminal$Companion$initTerminal$22.toString());
            }
            this.checkAppDelegateInitialized();
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
            DatabaseProvider.INSTANCE.createInstance(context2);
            TerminalComponent component = DaggerTerminalComponent.builder().bbposSdkModule(new BbposSdkModule()).terminalModule(new TerminalModule(tokenProvider, listener)).offlineModule(new OfflineModule(offlineListener)).contextModule(new ContextModule(context)).logLevelModule(new LogLevelModule(logLevel.toCoreObject$core_publish())).metricLoggerCollectorModule(new MetricLoggerCollectorModule(Terminal.METRICS_FILE_NAME, null, null, null, null, 30, null)).traceLoggerCollectorModule(new TraceLoggerCollectorModule(Terminal.TRACES_FILE_NAME, null, null, null, null, 30, null)).clientLoggerDispatcherModule(new ClientLoggerDispatcherModule(Terminal.EVENTS_FILE_NAME, 0L, null, null, null, null, 62, null)).build();
            Intrinsics.checkNotNull((Object)component);
            TerminalExtensionsKt.initLoggers$default(component, new File(context.getFilesDir(), Terminal.LEGACY_TRACES_FILE_NAME), null, 2, null);
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)initCoroutineContext)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;
                private /* synthetic */ Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            TerminalExtensionsKt.flushPendingLogsLoop$default($this$launch, (SimpleLogger)Terminal.access$getLOGGER$cp(), 60000L, null, 4, null);
                            TerminalExtensionsKt.autoSubmitLoop$default($this$launch, (SimpleLogger)Terminal.access$getLOGGER$cp(), 300000L, null, 4, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            try {
                Terminal terminal;
                Unit unit;
                LOGGER.startOperation((ApplicationTrace)SdkRequest.Companion.initialize(), Terminal.IDENTIFIER);
                component.getApiLevelValidator().logSdkVersions((SimpleLogger)LOGGER);
                component.getApiLevelValidator().validateMinSdkVersion();
                component.getRootAccessDetector().detectRootAccess((Function0)initTerminal.3.INSTANCE);
                CotsAdapter cotsAdapter = component.getCotsAdapter();
                if (cotsAdapter != null) {
                    CotsAdapter cotsAdapter2 = cotsAdapter;
                    boolean bl = false;
                    LOGGER.i("localmobile module detected", new Pair[0]);
                    cotsAdapter2.initKeystore();
                }
                StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                StackTraceElement stackTraceElement = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTraceElementArray, (int)1);
                if (stackTraceElement != null) {
                    StackTraceElement it = stackTraceElement;
                    boolean bl = false;
                    boolean isJava = Intrinsics.areEqual((Object)it.getFileName(), (Object)"Terminal.kt");
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"app_language", (Object)(isJava ? "JAVA" : "KOTLIN"))};
                    LOGGER.d(null, pairArray);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"app_language", (Object)"UNKNOWN")};
                    LOGGER.d(null, pairArray);
                }
                Terminal.locationHandler = component.getLocationHandler();
                Terminal.logFlusher = component.getTraceFlusher();
                ((Collection)executors).add(component.getConnectionExecutorService());
                ((Collection)executors).add(component.getTransactionExecutorService());
                instance = component.getTerminal();
                this.submitStoredLogEvents();
                LocationHandler locationHandler = locationHandler;
                if (locationHandler != null) {
                    locationHandler.startListening();
                }
                if ((terminal = instance) != null && (terminal = terminal.terminalSession) != null) {
                    terminal.resume();
                }
                LOGGER.endOperation((ApplicationTraceResult)SdkResponse.Companion.success(), Terminal.IDENTIFIER);
            }
            catch (TerminalException terminalException) {
                LOGGER.e((Throwable)terminalException);
                LOGGER.endOperation((ApplicationTraceResult)SdkResponse.Companion.failure(terminalException), Terminal.IDENTIFIER);
                throw terminalException;
            }
            catch (Throwable exception) {
                LOGGER.e(exception);
                TerminalException terminalException = new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Unknown sdk error during initialization", exception, null, 8, null);
                LOGGER.endOperation((ApplicationTraceResult)SdkResponse.Companion.failure(terminalException), Terminal.IDENTIFIER);
                throw exception;
            }
        }

        public static /* synthetic */ void initTerminal$default(Companion companion, Context context, LogLevel logLevel, ConnectionTokenProvider connectionTokenProvider, TerminalListener terminalListener, OfflineListener offlineListener, int n, Object object) throws TerminalException {
            if ((n & 2) != 0) {
                logLevel = LogLevel.NONE;
            }
            companion.initTerminal(context, logLevel, connectionTokenProvider, terminalListener, offlineListener);
        }

        @JvmStatic
        public final boolean isInitialized() {
            return instance != null;
        }

        private final void checkAppDelegateInitialized() {
            if (!TerminalApplicationDelegate.INSTANCE.isInitialized$core_publish().get()) {
                LOGGER.w("TerminalApplicationDelegate::onCreate was not called before initTerminal.", new Pair[0]);
            }
        }

        private final void submitStoredLogEvents() {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            StripeTerminalDatabase stripeTerminalDatabase = DatabaseProvider.INSTANCE.getInstance();
                            if (stripeTerminalDatabase != null) {
                                StripeTerminalDatabase db = stripeTerminalDatabase;
                                boolean bl = false;
                                LogFlusher logFlusher = Terminal.access$getLogFlusher$cp();
                                if (logFlusher != null) {
                                    TraceEntity p0;
                                    Collection collection;
                                    Iterable $this$mapTo$iv$iv;
                                    Iterable $this$map$iv;
                                    LogFlusher flusher = logFlusher;
                                    boolean bl2 = false;
                                    List events = db.eventDao().getAll();
                                    List traces = db.traceDao().getAll();
                                    db.eventDao().deleteAll();
                                    Iterable iterable = events;
                                    LogFlusher logFlusher2 = flusher;
                                    boolean $i$f$map = false;
                                    void var11_11 = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        EventEntity eventEntity = (EventEntity)item$iv$iv;
                                        collection = destination$iv$iv;
                                        boolean bl3 = false;
                                        collection.add(p0.toModel());
                                    }
                                    logFlusher2.submitEvents((List)destination$iv$iv);
                                    db.traceDao().deleteAll();
                                    $this$map$iv = traces;
                                    logFlusher2 = flusher;
                                    $i$f$map = false;
                                    $this$mapTo$iv$iv = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        void $this$mapTo$iv$iv2;
                                        void traceEntity;
                                        p0 = (TraceEntity)item$iv$iv;
                                        collection = destination$iv$iv;
                                        boolean bl4 = false;
                                        Iterable $this$map$iv2 = db.logPointDao().getLogPointsForTrace(traceEntity.getId());
                                        boolean $i$f$map2 = false;
                                        Iterable iterable2 = $this$map$iv2;
                                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                        boolean $i$f$mapTo2 = false;
                                        for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                                            void p02;
                                            LogPointEntity logPointEntity = (LogPointEntity)item$iv$iv2;
                                            Collection collection2 = destination$iv$iv2;
                                            boolean bl5 = false;
                                            collection2.add(p02.toModel());
                                        }
                                        List logPoints = (List)destination$iv$iv2;
                                        collection.add(traceEntity.toModel(logPoints));
                                    }
                                    logFlusher2.submitTraces((List)destination$iv$iv);
                                    db.logPointDao().deleteAll();
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public final void startTerminal$core_publish() {
            this.submitStoredLogEvents();
        }

        public final void resumeTerminal$core_publish() {
            block1: {
                Terminal terminal;
                LocationHandler locationHandler = locationHandler;
                if (locationHandler != null) {
                    locationHandler.startListening();
                }
                if ((terminal = instance) == null || (terminal = terminal.terminalSession) == null) break block1;
                terminal.resume();
            }
        }

        public final void pauseTerminal$core_publish() {
            block1: {
                Terminal terminal;
                LocationHandler locationHandler = locationHandler;
                if (locationHandler != null) {
                    locationHandler.stopListening();
                }
                if ((terminal = instance) == null || (terminal = terminal.terminalSession) == null) break block1;
                terminal.pause();
            }
        }

        public final void destroyTerminal$core_publish() {
            Terminal terminal = instance;
            TerminalSession session = terminal != null ? terminal.terminalSession : null;
            instance = null;
            LocationHandler locationHandler = locationHandler;
            if (locationHandler != null) {
                locationHandler.stopListening();
            }
            TerminalSession terminalSession = session;
            if (terminalSession != null) {
                terminalSession.destroy();
            }
            LogFlusher logFlusher = logFlusher;
            if (logFlusher != null) {
                logFlusher.stopExecutingJobs();
            }
            initCoroutineContext.cancel(new CancellationException("Terminal destroyed."));
            DatabaseProvider.INSTANCE.destroyInstance();
            Iterable $this$forEach$iv = executors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExecutorService it = (ExecutorService)element$iv;
                boolean bl = false;
                it.shutdown();
            }
            executors.clear();
            LOGGER.onShutDown();
        }

        @JvmStatic
        @NotNull
        public final Terminal getInstance() {
            Terminal terminal = instance;
            if (terminal == null) {
                boolean bl = false;
                String string = "initTerminal must be called before attempting to get the instance";
                throw new IllegalStateException(string.toString());
            }
            return terminal;
        }

        @JvmStatic
        @JvmOverloads
        public final void initTerminal(@NotNull Context context, @NotNull ConnectionTokenProvider tokenProvider, @NotNull TerminalListener listener) throws TerminalException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            com.stripe.stripeterminal.Terminal$Companion.initTerminal$default(this, context, null, tokenProvider, listener, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

