/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.stripeterminal.Terminal;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/stripe/stripeterminal/TerminalLifecycleObserver;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Landroidx/lifecycle/LifecycleEventObserver;", "Landroid/content/ComponentCallbacks2;", "packageName", "", "(Ljava/lang/String;)V", "appName", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "onStateChanged", "source", "Landroidx/lifecycle/LifecycleOwner;", "event", "Landroidx/lifecycle/Lifecycle$Event;", "onTrimMemory", "level", "", "Companion", "core_publish"})
public final class TerminalLifecycleObserver
implements Application.ActivityLifecycleCallbacks,
LifecycleEventObserver,
ComponentCallbacks2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String packageName;
    @Nullable
    private String appName;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(TerminalLifecycleObserver.class);
    @NotNull
    private static final String APP_FOREGROUND = "applicationDidEnterForeground";
    @NotNull
    private static final String APP_BACKGROUND = "applicationDidEnterBackground";
    @NotNull
    private static final String APP_TRIM_MEMORY = "applicationDidReceiveMemoryWarning";
    @NotNull
    private static final String APP_ID = "appId";
    @NotNull
    private static final String MEMORY_LEVEL = "memoryLevel";
    @NotNull
    private static final String MEMORY_PROFILE = "memoryProfile";
    @NotNull
    private static final String TRIM_MEMORY_COMPLETE = "TRIM_MEMORY_COMPLETE";
    @NotNull
    private static final String TRIM_MEMORY_MODERATE = "TRIM_MEMORY_MODERATE";
    @NotNull
    private static final String TRIM_MEMORY_BACKGROUND = "TRIM_MEMORY_BACKGROUND";
    @NotNull
    private static final String TRIM_MEMORY_UI_HIDDEN = "TRIM_MEMORY_UI_HIDDEN";
    @NotNull
    private static final String TRIM_MEMORY_RUNNING_CRITICAL = "TRIM_MEMORY_RUNNING_CRITICAL";
    @NotNull
    private static final String TRIM_MEMORY_RUNNING_LOW = "TRIM_MEMORY_RUNNING_LOW";
    @NotNull
    private static final String TRIM_MEMORY_RUNNING_MODERATE = "TRIM_MEMORY_RUNNING_MODERATE";
    @NotNull
    private static final String UNKNOWN = "unknown";

    public TerminalLifecycleObserver(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.packageName = packageName;
    }

    public void onTrimMemory(int level) {
        String string;
        switch (level) {
            case 80: {
                string = TRIM_MEMORY_COMPLETE;
                break;
            }
            case 60: {
                string = TRIM_MEMORY_MODERATE;
                break;
            }
            case 40: {
                string = TRIM_MEMORY_BACKGROUND;
                break;
            }
            case 20: {
                string = TRIM_MEMORY_UI_HIDDEN;
                break;
            }
            case 15: {
                string = TRIM_MEMORY_RUNNING_CRITICAL;
                break;
            }
            case 10: {
                string = TRIM_MEMORY_RUNNING_LOW;
                break;
            }
            case 5: {
                string = TRIM_MEMORY_RUNNING_MODERATE;
                break;
            }
            default: {
                string = UNKNOWN;
            }
        }
        String profile = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MEMORY_LEVEL, (Object)String.valueOf(level)), TuplesKt.to((Object)MEMORY_PROFILE, (Object)profile), TuplesKt.to((Object)APP_ID, (Object)this.packageName)};
        LOGGER.w(APP_TRIM_MEMORY, pairArray);
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
    }

    public void onLowMemory() {
    }

    public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Terminal.Companion.isInitialized()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1: {
                Terminal.Companion.startTerminal$core_publish();
                break;
            }
            case 2: {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)APP_ID, (Object)this.appName)};
                LOGGER.i(APP_FOREGROUND, pairArray);
                Terminal.Companion.resumeTerminal$core_publish();
                break;
            }
            case 3: {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)APP_ID, (Object)this.appName)};
                LOGGER.i(APP_BACKGROUND, pairArray);
                Terminal.Companion.pauseTerminal$core_publish();
                break;
            }
            case 4: {
                Terminal.Companion.destroyTerminal$core_publish();
            }
        }
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.appName == null) {
            Object object = activity.getApplicationContext();
            if (object == null || (object = object.getPackageName()) == null) {
                object = UNKNOWN;
            }
            this.appName = object;
        }
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @JvmStatic
    @NotNull
    public static final TerminalLifecycleObserver getInstance(@NotNull Application application) {
        return Companion.getInstance(application);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/stripeterminal/TerminalLifecycleObserver$Companion;", "", "()V", "APP_BACKGROUND", "", "APP_FOREGROUND", "APP_ID", "APP_TRIM_MEMORY", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "MEMORY_LEVEL", "MEMORY_PROFILE", "TRIM_MEMORY_BACKGROUND", "TRIM_MEMORY_COMPLETE", "TRIM_MEMORY_MODERATE", "TRIM_MEMORY_RUNNING_CRITICAL", "TRIM_MEMORY_RUNNING_LOW", "TRIM_MEMORY_RUNNING_MODERATE", "TRIM_MEMORY_UI_HIDDEN", "UNKNOWN", "getInstance", "Lcom/stripe/stripeterminal/TerminalLifecycleObserver;", "application", "Landroid/app/Application;", "core_publish"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalLifecycleObserver getInstance(@NotNull Application application) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            String string = application.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
            return new TerminalLifecycleObserver(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Lifecycle.Event.values().length];
            try {
                nArray[Lifecycle.Event.ON_START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lifecycle.Event.ON_RESUME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lifecycle.Event.ON_PAUSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lifecycle.Event.ON_DESTROY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

