/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.stripeterminal.dagger;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import com.stripe.jvmcore.dagger.ForApplication;
import com.stripe.jvmcore.logging.terminal.log.SimpleLogger;
import com.stripe.loggingmodels.ApplicationTrace;
import com.stripe.loggingmodels.ApplicationTraceResult;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.introspection.ApiLevelValidator;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/stripe/stripeterminal/dagger/ApiLevelModule;", "", "()V", "provideApiLevelValidator", "Lcom/stripe/stripeterminal/internal/common/introspection/ApiLevelValidator;", "context", "Landroid/content/Context;", "core_publish"})
public final class ApiLevelModule {
    @Provides
    @Singleton
    @NotNull
    public final ApiLevelValidator provideApiLevelValidator(@ForApplication @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new ApiLevelValidator(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
            }

            @SuppressLint(value={"ObsoleteSdkInt"})
            public void validateMinSdkVersion() {
                if (Build.VERSION.SDK_INT < 26) {
                    throw new TerminalException(TerminalException.TerminalErrorCode.ANDROID_API_LEVEL_ERROR, "minSdkVersion must be >= 26 to use Terminal", null, null, 12, null);
                }
            }

            public void logSdkVersions(@NotNull SimpleLogger<ApplicationTrace, ApplicationTraceResult> logger) {
                Intrinsics.checkNotNullParameter(logger, (String)"logger");
                int minSdkVersion = this.$context.getApplicationInfo().minSdkVersion;
                int targetSdkVersion = this.$context.getApplicationInfo().targetSdkVersion;
                int compileSdkVersion = Build.VERSION.SDK_INT >= 31 ? this.$context.getApplicationInfo().compileSdkVersion : 0;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"minSdkVersion", (Object)minSdkVersion), TuplesKt.to((Object)"targetSdkVersion", (Object)targetSdkVersion), TuplesKt.to((Object)"compileSdkVersion", (Object)compileSdkVersion)};
                logger.d("Application version info", pairArray);
            }
        };
    }
}

